/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;

public class ProjectDeltaUtils {
    public static boolean isProjectBeingOpened(IResourceDelta delta) {
        if (delta == null || !(delta.getResource() instanceof IProject)) {
            return false;
        }
        switch (delta.getKind()) {
            case 1: {
                return true;
            }
            case 4: {
                return delta.getResource().isAccessible() && (delta.getFlags() & 0x4000) > 0;
            }
        }
        return false;
    }

    public static boolean isProjectBeingClosed(IResourceDelta delta) {
        if (delta == null || !(delta.getResource() instanceof IProject)) {
            return false;
        }
        switch (delta.getKind()) {
            case 2: {
                return true;
            }
            case 4: {
                return !delta.getResource().isAccessible() && (delta.getFlags() & 0x4000) > 0;
            }
        }
        return false;
    }

    public static boolean isProjectDescriptionChanged(IResourceDelta delta) {
        if (delta == null || !(delta.getResource() instanceof IProject)) {
            return false;
        }
        return (delta.getFlags() & 0x80000) > 0;
    }
}

