/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class ParametrizedHashBag {
    private HashMap myContents = new HashMap();
    private Class myClass;

    public ParametrizedHashBag(Class cls) {
        this.myClass = cls;
    }

    public Collection get(Object key) {
        Collection result = (Collection)this.myContents.get(key);
        if (result == null) {
            result = this.newInstance();
            this.myContents.put(key, result);
        }
        return result;
    }

    public Collection safeGet(Object key) {
        if (this.containsKey(key)) {
            return Collections.unmodifiableCollection((Collection)this.myContents.get(key));
        }
        return Collections.EMPTY_SET;
    }

    private Collection newInstance() {
        try {
            return (Collection)this.myClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public void add(Object key, Object value) {
        this.get(key).add(value);
    }

    public void addAll(Object key, Collection values) {
        this.get(key).addAll(values);
    }

    public boolean remove(Object key, Object value) {
        return this.remove(key, value, false);
    }

    public boolean remove(Object key, Object value, boolean removeEmptyKey) {
        boolean result = this.get(key).remove(value);
        if (this.get(key).isEmpty()) {
            this.myContents.remove(key);
        }
        return result;
    }

    public Collection removeAll(Object key) {
        return (Collection)this.myContents.remove(key);
    }

    public boolean containsKey(Object key) {
        return this.myContents.containsKey(key);
    }

    public boolean containsValue(Object key, Object value) {
        return this.containsKey(key) && this.get(key).contains(value);
    }

    public Iterator keyIterator() {
        return this.myContents.keySet().iterator();
    }

    public Set keySet() {
        return this.myContents.keySet();
    }
}

