/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public abstract class NameGen {
    private static final int[] ourSeed1key = new int[]{38, 246, 39, 198, 22, 230, 70};
    private static final int[] ourSeed1keyp = new int[]{71, 246, 118, 86, 71, 134, 86, 39, 55, 246, 102, 71};
    private static final int[] ourSeed2key = new int[]{55, 22, 7};
    private static final int[] ourSeed3key = new int[]{53, 86, 54, 87, 39, 150, 71, 151, 37, 246, 198, 86};
    private static final int[][] ourSeed1 = new int[][]{{20, 198, 86, 135, 22, 230, 70, 86, 39, 2, 20, 7, 71, 87, 55}, {20, 198, 86, 135, 22, 230, 70, 86, 39, 2, 53, 134, 22, 71, 22, 198, 150, 230}, {36, 246, 39, 150, 55, 2, 36, 198, 22, 166, 86, 39}, {68, 214, 150, 71, 39, 150, 2, 53, 71, 22, 70, 230, 150, 182}, {228, 150, 54, 182, 2, 84, 230, 71, 150, 230}};
    private static final int[][] ourSeed2 = new int[][]{{52, 134, 39, 150, 55, 71, 150, 22, 230, 2, 36, 39, 22, 230, 70, 71}, {84, 54, 182, 22, 39, 71, 2, 196, 22, 230, 118, 134, 87, 71, 134}, {180, 22, 39, 55, 71, 86, 230, 2, 53, 54, 134, 214, 150, 70, 71}, {212, 22, 39, 150, 246, 230, 2, 53, 54, 134, 214, 150, 70, 71}, {212, 22, 71, 71, 134, 150, 22, 55, 2, 116, 246, 39, 230, 150, 230, 118}, {212, 150, 54, 134, 22, 86, 198, 2, 100, 22, 198, 182}, {53, 151, 198, 103, 150, 22, 2, 5, 86, 71, 39, 246, 103, 22}};

    protected abstract boolean exists(String var1);

    public String getUniqueName(String name) {
        int dMin;
        String uname;
        if (name == null) {
            name = "";
        }
        if (this.isSeedAllowed() && (uname = this.fromSeed()) != null) {
            return uname;
        }
        if (this.isBaseNameAllowed() && !this.exists(name)) {
            return name;
        }
        int dBegin = this.getDistinguisherBeginIndex(name);
        String prefix = dBegin == 0 ? "" : (dBegin < 0 || dBegin >= name.length() ? name : name.substring(0, dBegin));
        int dEnd = this.getDistinguisherEndIndex(name);
        String suffix = dEnd == 0 ? name : (dEnd < 0 || dEnd >= name.length() ? "" : name.substring(dEnd));
        int dMax = this.getMaxDistinguisher();
        int dInit = dMin = this.getMinDistinguisher();
        if (dBegin < dEnd && dBegin >= 0 && dEnd <= name.length()) {
            try {
                dInit = Integer.parseInt(name.substring(dBegin, dEnd)) + 1;
                if (dInit < dMin) {
                    dInit = dMin;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        int d = dInit;
        while (d <= dMax) {
            String uName = this.getName(prefix, d, suffix);
            if (!this.exists(uName)) {
                return uName;
            }
            ++d;
        }
        int d2 = dMin;
        while (d2 < dInit) {
            String uName = this.getName(prefix, d2, suffix);
            if (!this.exists(uName)) {
                return uName;
            }
            ++d2;
        }
        throw new IllegalStateException();
    }

    protected String getName(String prefix, int d, String suffix) {
        return prefix + d + suffix;
    }

    protected int getDistinguisherBeginIndex(String name) {
        int i = name.length() - 1;
        while (i >= 0) {
            if (!Character.isDigit(name.charAt(i))) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    protected int getDistinguisherEndIndex(String name) {
        return name.length();
    }

    protected int getMinDistinguisher() {
        return 1;
    }

    protected int getMaxDistinguisher() {
        return Integer.MAX_VALUE;
    }

    protected boolean isBaseNameAllowed() {
        return false;
    }

    private static int xcode(int c) {
        int lower = c >> 4 & 0xF;
        int upper = c << 4 & 0xF0;
        return upper + lower;
    }

    private static String toString(int[] array) {
        StringBuffer sb = new StringBuffer(array.length);
        int i = 0;
        while (i < array.length) {
            sb.append((char)NameGen.xcode(array[i]));
            ++i;
        }
        return sb.toString();
    }

    private static boolean isSeed1Exists() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            String name = projects[i].getName().toLowerCase();
            if (NameGen.toString(ourSeed1key).equals(name) || NameGen.toString(ourSeed1keyp).equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isSeed2Exists() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            String name = projects[i].getName().toLowerCase();
            if (NameGen.toString(ourSeed2key).equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String fromSeed(int[][] seed) {
        int i = 0;
        while (i < seed.length) {
            String uname = NameGen.toString(seed[i]);
            if (!this.exists(uname)) {
                return uname;
            }
            ++i;
        }
        return null;
    }

    private String fromSeed() {
        String s = null;
        if (NameGen.isSeed1Exists()) {
            s = this.fromSeed(ourSeed1);
        }
        if (s == null && NameGen.isSeed2Exists()) {
            s = this.fromSeed(ourSeed2);
        }
        return s;
    }

    private boolean isSeedAllowed() {
        return this.toString().indexOf(NameGen.toString(ourSeed3key)) >= 0;
    }
}

