/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils;

import com.tssap.j2ee.core.utils.Messages;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class FileUtils {
    private FileUtils() {
    }

    public static String getFileContents(String fileName, String defaultContents, Plugin plugin) {
        try {
            InputStream in = plugin.openStream((IPath)new Path(fileName), false);
            return FileUtils.readInputStream(in);
        }
        catch (IOException ioe) {
            String msg = "Unable to read file " + fileName;
            String id = plugin.getDescriptor().getUniqueIdentifier();
            Status status = new Status(4, id, 0, msg, (Throwable)ioe);
            plugin.getLog().log((IStatus)status);
            return defaultContents;
        }
    }

    public static String getFileContents(IFile file) throws CoreException {
        try {
            return FileUtils.readInputStream(file.getContents());
        }
        catch (IOException io) {
            Status status = new Status(4, UtilsPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "Failed to get file contents", (Throwable)io);
            throw new CoreException((IStatus)status);
        }
    }

    public static String readInputStream(InputStream stream) throws IOException {
        String string;
        int BUFFER_SIZE = 4096;
        try {
            int count;
            StringBuffer accumulator = new StringBuffer();
            InputStreamReader in = new InputStreamReader(stream);
            char[] buffer = new char[4096];
            while ((count = in.read(buffer, 0, 4096)) != -1) {
                accumulator.append(buffer, 0, count);
                if (count >= 4096) continue;
                break;
            }
            string = accumulator.toString();
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                stream.close();
            }
            catch (IOException io) {
                Status status = new Status(4, UtilsPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "Failed to close stream", (Throwable)io);
                UtilsPlugin.getDefault().getLog().log((IStatus)status);
            }
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException io) {
            Status status = new Status(4, UtilsPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "Failed to close stream", (Throwable)io);
            UtilsPlugin.getDefault().getLog().log((IStatus)status);
        }
        return string;
    }

    public static byte[] getFileBytes(IFile file) throws CoreException {
        try {
            return FileUtils.getInputStreamAsByteArray(file.getContents());
        }
        catch (IOException io) {
            Status status = new Status(4, UtilsPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "Failed to get file contents", (Throwable)io);
            throw new CoreException((IStatus)status);
        }
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream) throws IOException {
        byte[] byArray;
        int BUFFER_SIZE = 4096;
        try {
            int count;
            byte[] accumulator = new byte[4096];
            int current = 0;
            while ((count = stream.read(accumulator, current, 4096)) != -1) {
                byte[] oldAccumulator;
                if (count == 4096) {
                    oldAccumulator = accumulator;
                    accumulator = new byte[oldAccumulator.length + 4096];
                    System.arraycopy(oldAccumulator, 0, accumulator, 0, oldAccumulator.length);
                }
                if (count < 4096) {
                    oldAccumulator = accumulator;
                    accumulator = new byte[oldAccumulator.length - 4096 + count];
                    System.arraycopy(oldAccumulator, 0, accumulator, 0, accumulator.length);
                    break;
                }
                current += 4096;
            }
            byArray = accumulator;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                stream.close();
            }
            catch (IOException io) {
                Status status = new Status(4, UtilsPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "Failed to close stream", (Throwable)io);
                UtilsPlugin.getDefault().getLog().log((IStatus)status);
            }
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException io) {
            Status status = new Status(4, UtilsPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "Failed to close stream", (Throwable)io);
            UtilsPlugin.getDefault().getLog().log((IStatus)status);
        }
        return byArray;
    }

    public static void createFolder(IContainer container, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.getString("FileUtils.Create_parent_folder"), 100);
        if (container.isAccessible()) {
            monitor.done();
            return;
        }
        switch (container.getType()) {
            case 8: {
                throw new CoreException((IStatus)new Status(4, UtilsPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "Attempt to invoke create on workspace root", null));
            }
            case 4: {
                return;
            }
            case 2: {
                FileUtils.createFolder(container.getParent(), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                ((IFolder)container).create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
        }
    }

    public static IFile createFile(IPath containerPath, String fileName, InputStream contents, IProgressMonitor monitor) throws CoreException {
        IPath newFilePath = containerPath.append(fileName);
        IFile newFileHandle = FileUtils.createFileHandle(newFilePath);
        ContainerGenerator generator = new ContainerGenerator(containerPath);
        generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        FileUtils.createFile(newFileHandle, contents, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        return newFileHandle;
    }

    private static IFile createFileHandle(IPath filePath) {
        return WorkbenchPlugin.getPluginWorkspace().getRoot().getFile(filePath);
    }

    private static void createFile(IFile fileHandle, InputStream contents, IProgressMonitor monitor) throws CoreException {
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        fileHandle.create(contents, false, monitor);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

