/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils;

import com.tssap.j2ee.core.utils.RuntimeSupport;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.selena.gde.internal.DiagramMultiPageViewPart;
import com.tssap.selena.gde.internal.DiagramViewPart;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.ui.multipageview.IMemberViewPart;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditorUtils {
    private static WorkbenchVisitor ourListenersAdder = new WorkbenchVisitor(){

        public void visit(IWorkbench workbench) {
            workbench.addWindowListener(ourWindowListener);
            UtilsPlugin.logInfo("Workbench window listener added " + workbench);
        }

        public void visit(IWorkbenchWindow window) {
            window.getPartService().addPartListener(ourPartListener);
            UtilsPlugin.logInfo("Workbench part listener added " + window);
        }

        public void visit(IEditorPart part) {
            EditorUtils.hookEditPart(part);
            UtilsPlugin.logInfo("Workbench editor hooked " + part);
        }
    };
    private static WorkbenchVisitor ourListenersRemover = new WorkbenchVisitor(){

        public void visit(IWorkbench workbench) {
            workbench.removeWindowListener(ourWindowListener);
            UtilsPlugin.logInfo("Workbench window listener removed " + workbench);
        }

        public void visit(IWorkbenchWindow window) {
            window.getPartService().removePartListener(ourPartListener);
            UtilsPlugin.logInfo("Workbench part listener removed " + window);
        }

        public void visit(IEditorPart part) {
            EditorUtils.unhookEditPart(part);
            UtilsPlugin.logInfo("Workbench editor unhooked " + part);
        }
    };
    private static final IWindowListener ourWindowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow window) {
            UtilsPlugin.logInfo("Workbench window opened " + window);
            EditorUtils.traverse(ourListenersAdder, window);
        }

        public void windowClosed(IWorkbenchWindow window) {
            UtilsPlugin.logInfo("Workbench window closed " + window);
            EditorUtils.traverse(ourListenersRemover, window);
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }
    };
    private static final IPartListener ourPartListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
            UtilsPlugin.logInfo("Workbench part opened " + part);
            if (part instanceof IEditorPart) {
                EditorUtils.hookEditPart((IEditorPart)part);
            }
            if (part instanceof IViewPart) {
                EditorUtils.hookViewPart((IViewPart)part);
            }
        }

        public void partClosed(IWorkbenchPart part) {
            UtilsPlugin.logInfo("Workbench part closed " + part);
            if (part instanceof IEditorPart) {
                EditorUtils.unhookEditPart((IEditorPart)part);
            }
        }

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IViewPart) {
                EditorUtils.hookViewPart((IViewPart)part);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            if (part instanceof IViewPart) {
                EditorUtils.hookViewPart((IViewPart)part);
            }
        }
    };
    private static final IPropertyListener ourPropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (!(source instanceof IEditorPart)) {
                return;
            }
            IEditorPart editorPart = (IEditorPart)source;
            if (258 == propId) {
                IPath prevFile = EditorUtils.getEditorFile(editorPart);
                IEditorInput editorInput = editorPart.getEditorInput();
                IPath currFile = null;
                if (editorInput != null && editorInput instanceof IFileEditorInput) {
                    IFileEditorInput fileInput = (IFileEditorInput)editorInput;
                    currFile = fileInput.getFile().getFullPath();
                }
                if (prevFile != null) {
                    if (prevFile.equals(currFile)) {
                        return;
                    }
                    ourEditedFiles.remove(prevFile);
                }
                if (currFile != null) {
                    ourEditedFiles.put(currFile, editorPart);
                }
                UtilsPlugin.logInfo("Editor input changed: " + prevFile + " -> " + currFile);
            }
        }
    };
    private static final Map ourEditedFiles = new HashMap();
    private static final Set ourMetaclasses = new HashSet();

    private EditorUtils() {
    }

    public static boolean isModified(IFile file) {
        IEditorPart editorPart = (IEditorPart)ourEditedFiles.get(file.getFullPath());
        if (editorPart == null) {
            return false;
        }
        return editorPart.isDirty();
    }

    static void register() {
        EditorUtils.traverse(ourListenersAdder);
    }

    static void unregister() {
        EditorUtils.traverse(ourListenersRemover);
    }

    private static void traverse(WorkbenchVisitor visitor) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            EditorUtils.traverse(visitor, windows[i]);
            ++i;
        }
        visitor.visit(workbench);
    }

    private static void traverse(WorkbenchVisitor visitor, IWorkbenchWindow window) {
        IWorkbenchPage[] pages = window.getPages();
        int j = 0;
        while (j < pages.length) {
            IWorkbenchPage page = pages[j];
            IEditorReference[] editorRefs = page.getEditorReferences();
            int k = 0;
            while (k < editorRefs.length) {
                IEditorReference editorRef = editorRefs[k];
                IEditorPart editorPart = editorRef.getEditor(false);
                if (editorPart != null) {
                    visitor.visit(editorPart);
                }
                ++k;
            }
            ++j;
        }
        visitor.visit(window);
    }

    private static IPath getEditorFile(IEditorPart editorPart) {
        Iterator files = ourEditedFiles.keySet().iterator();
        while (files.hasNext()) {
            IPath next = (IPath)files.next();
            IEditorPart nextPart = (IEditorPart)ourEditedFiles.get(next);
            if (!editorPart.equals(nextPart)) continue;
            return next;
        }
        return null;
    }

    private static void hookEditPart(IEditorPart editorPart) {
        IEditorInput editorInput = editorPart.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return;
        }
        IFileEditorInput fileInput = (IFileEditorInput)editorInput;
        IPath file = fileInput.getFile().getFullPath();
        if (file != null) {
            ourEditedFiles.put(file, editorPart);
            editorPart.addPropertyListener(ourPropertyListener);
            UtilsPlugin.logInfo("File " + file + " is opened by " + editorPart);
        }
    }

    private static void unhookEditPart(IEditorPart editorPart) {
        IEditorInput editorInput = editorPart.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return;
        }
        IFileEditorInput fileInput = (IFileEditorInput)editorInput;
        IFile file = fileInput.getFile();
        if (file != null) {
            IPath filePath = file.getFullPath();
            ourEditedFiles.remove(filePath);
            editorPart.removePropertyListener(ourPropertyListener);
            UtilsPlugin.logInfo("File " + filePath + " is closed");
        }
    }

    private static void hookViewPart(IViewPart viewPart) {
        if (viewPart instanceof DiagramMultiPageViewPart) {
            final DiagramMultiPageViewPart diagramsPart = (DiagramMultiPageViewPart)viewPart;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    int i = diagramsPart.getPageCount() - 1;
                    while (i >= 0) {
                        IMemberViewPart diagramPart = diagramsPart.getPage(i);
                        if (diagramPart instanceof DiagramViewPart) {
                            EditorUtils.diagramActive((DiagramViewPart)diagramPart);
                        }
                        --i;
                    }
                }
            });
        }
    }

    private static void diagramActive(DiagramViewPart diagramPart) {
        UtilsPlugin.logInfo("Diagram active " + diagramPart);
        Element element = diagramPart.getDiagram().getContent();
        if (element instanceof ReferenceCollection) {
            element = ((ReferenceCollection)element).getParent();
        }
        if (element == null || element.isDeleted()) {
            return;
        }
        if (!ourMetaclasses.contains(element.getPropertyValue("$metaclass"))) {
            return;
        }
        String fileName = element.getPropertyValue("$file");
        if (fileName == null) {
            UtilsPlugin.logWarning("Diagram parent has no source file");
            return;
        }
        UniqueName modelUin = element.getModel().getUniqueName();
        if (!EditorUtils.isProjectModel(modelUin)) {
            UtilsPlugin.logWarning("Diagram should be located in project model");
            return;
        }
        IProject project = ModelUinSupport.getProject((UniqueName)modelUin);
        if (project == null) {
            UtilsPlugin.logWarning("Project not found for the model uin " + modelUin);
            return;
        }
        IFile file = project.getFile(fileName);
        EditorUtils.saveModified(file, true);
    }

    public static void saveModified(IFile file, boolean askConfirmation) {
        IPath filePath = file.getFullPath();
        final IEditorPart editorPart = (IEditorPart)ourEditedFiles.get(filePath);
        UtilsPlugin.logInfo("Diagram file " + filePath + " is edited by " + editorPart);
        if (editorPart == null || !editorPart.isDirty()) {
            return;
        }
        if (!askConfirmation || EditorUtils.isSaveRequired(file.getProjectRelativePath().toString())) {
            try {
                RuntimeSupport.run(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        editorPart.doSave(monitor);
                    }
                });
            }
            catch (CoreException ce) {
                UtilsPlugin.logWarning("Unable to save " + file.getProjectRelativePath().toString(), ce);
            }
        }
    }

    private static boolean isProjectModel(UniqueName uin) {
        return "model".equals(uin.getDomain()) && "project".equals(uin.getSubDomain());
    }

    private static boolean isSaveRequired(String fileName) {
        int style = 292;
        MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell(), 292);
        dialog.setMessage("Diagram source is modified in editor. Whould you like to save it?");
        return dialog.open() == 32;
    }

    static {
        ourMetaclasses.add("com.tssap.j2ee.core.ear.EnterpriseApp");
        ourMetaclasses.add("com.tssap.j2ee.core.ejbjar.EjbJar");
        ourMetaclasses.add("com.tssap.j2ee.core.webapp.WebApp");
    }

    private static interface WorkbenchVisitor {
        public void visit(IWorkbench var1);

        public void visit(IWorkbenchWindow var1);

        public void visit(IEditorPart var1);
    }
}

