/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils;

import com.tssap.j2ee.core.utils.EditorSupportFactory;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.selena.gde.ModelNodeEditPart;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;

public class EditorSupportRegistry {
    public static final String ESF_EP = "editors";
    public static final String ESF_TAG = "factory";
    public static final String ESF_TYPE_ATTR = "type";
    public static final String ESF_CLASS_ATTR = "class";
    private static Map ourEditorSupportFactories;

    private EditorSupportRegistry() {
    }

    public static void provideEditorSupport(String type, ModelNodeEditPart part) {
        EditorSupportFactory factory;
        if (ourEditorSupportFactories == null) {
            EditorSupportRegistry.readEditorSupportFactories();
        }
        if ((factory = (EditorSupportFactory)ourEditorSupportFactories.get(type)) == null) {
            return;
        }
        factory.provideEditorSupport(part);
    }

    private static void readEditorSupportFactories() {
        ourEditorSupportFactories = new HashMap();
        IExtensionPoint ep = UtilsPlugin.getDefault().getDescriptor().getExtensionPoint(ESF_EP);
        if (ep == null) {
            return;
        }
        IConfigurationElement[] ces = ep.getConfigurationElements();
        if (ces == null || ces.length == 0) {
            return;
        }
        int i = 0;
        while (i < ces.length) {
            String type;
            IConfigurationElement ce = ces[i];
            if (ESF_TAG.equals(ce.getName()) && (type = ce.getAttribute(ESF_TYPE_ATTR)) != null) {
                try {
                    EditorSupportFactory factory = (EditorSupportFactory)ce.createExecutableExtension(ESF_CLASS_ATTR);
                    ourEditorSupportFactories.put(type, factory);
                    UtilsPlugin.logInfo("Editor support factory added " + factory);
                }
                catch (Exception e) {
                    UtilsPlugin.logWarning("Unable to create editor support facrory " + e);
                }
            }
            ++i;
        }
    }
}

