/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils;

import com.tssap.selena.model.elements.UniqueName;
import java.lang.reflect.Array;

public class ArrayUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private ArrayUtils() {
    }

    public static int indexOf(Object[] array, Object obj) {
        if (array != null && array.length > 0 && obj != null) {
            int i = 0;
            while (i < array.length) {
                if (obj.equals(array[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static Object[] add(Object[] array, Object obj) {
        Class<?> type = array.getClass().getComponentType();
        if (array == null || array.length == 0) {
            Object[] result = (Object[])Array.newInstance(type, 1);
            result[0] = obj;
            return result;
        }
        Object[] result = (Object[])Array.newInstance(type, array.length + 1);
        System.arraycopy(array, 0, result, 0, array.length);
        result[result.length - 1] = obj;
        return result;
    }

    public static UniqueName[] addUniqueName(UniqueName[] array, UniqueName uin) {
        if (array == null || array.length == 0) {
            return new UniqueName[]{uin};
        }
        UniqueName[] result = new UniqueName[array.length + 1];
        System.arraycopy(array, 0, result, 0, array.length);
        result[result.length - 1] = uin;
        return result;
    }

    public static String[] addString(String[] array, String str) {
        if (array == null || array.length == 0) {
            return new String[]{str};
        }
        String[] result = new String[array.length + 1];
        System.arraycopy(array, 0, result, 0, array.length);
        result[result.length - 1] = str;
        return result;
    }

    public static Object[] remove(Object[] array, Object obj) {
        if (array == null || array.length == 0) {
            return null;
        }
        int i = 0;
        while (i < array.length) {
            if (obj.equals(array[i])) {
                return ArrayUtils.kill(array, i);
            }
            ++i;
        }
        return array;
    }

    public static UniqueName[] removeUniqueName(UniqueName[] array, UniqueName uin) {
        if (array == null || array.length == 0) {
            return null;
        }
        int i = 0;
        while (i < array.length) {
            if (uin.equals(array[i])) {
                return (UniqueName[])ArrayUtils.kill(array, i);
            }
            ++i;
        }
        return array;
    }

    public static String[] removeString(String[] array, String str) {
        if (array == null || array.length == 0) {
            return null;
        }
        int i = 0;
        while (i < array.length) {
            if (str.equals(array[i])) {
                return (String[])ArrayUtils.kill(array, i);
            }
            ++i;
        }
        return array;
    }

    public static String[] replaceString(String[] array, String original, String substitute) {
        if (array == null || array.length == 0) {
            return array;
        }
        int i = 0;
        while (i < array.length) {
            if (original.equals(array[i])) {
                array[i] = substitute;
                break;
            }
            ++i;
        }
        return array;
    }

    public static boolean contains(Object[] array, Object value) {
        if (array == null || array.length == 0 || value == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (value.equals(array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Object[] subtract(Object[] from, Object[] what) {
        if (from == null || from.length == 0) {
            return null;
        }
        Object[] result = (Object[])from.clone();
        if (what == null || what.length == 0) {
            return result;
        }
        int i = 0;
        while (i < what.length) {
            Object remove = what[i];
            if (remove != null) {
                int j = 0;
                while (j < result.length) {
                    if (remove.equals(result[j])) {
                        result = ArrayUtils.kill(result, j);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public static Object[] intersect(Object[] array1, Object[] array2) {
        if (array1 == null || array1.length == 0 || array2 == null || array2.length == 0) {
            return null;
        }
        if (array1.length > array2.length) {
            Object[] tmp = array1;
            array1 = array2;
            array2 = tmp;
        }
        Object[] result = (Object[])array1.clone();
        int i = 0;
        while (i < result.length) {
            Object tmp = result[i];
            if (tmp != null) {
                int j = 0;
                while (j < array2.length) {
                    if (tmp.equals(array2[j])) {
                        tmp = null;
                        break;
                    }
                    ++j;
                }
                if (tmp != null) {
                    result = ArrayUtils.kill(result, i--);
                }
            }
            ++i;
        }
        return result;
    }

    public static void move(Object[] array, Object what, int index) {
        int prevIndex = ArrayUtils.indexOf(array, what);
        if (prevIndex < 0 || index < 0 || index >= array.length || prevIndex == index) {
            return;
        }
        int delta = Math.abs(index - prevIndex);
        Object tmp = array[prevIndex];
        if (delta == 1) {
            array[prevIndex] = array[index];
        } else if (index > prevIndex) {
            System.arraycopy(array, prevIndex + 1, array, prevIndex, delta);
        } else {
            System.arraycopy(array, index, array, index + 1, delta);
        }
        array[index] = tmp;
    }

    private static Object[] kill(Object[] array, int i) {
        Class<?> type = array.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(type, array.length - 1);
        if (i != 0) {
            System.arraycopy(array, 0, result, 0, i);
        }
        if (i != array.length - 1) {
            System.arraycopy(array, i + 1, result, i, result.length - i);
        }
        return result;
    }
}

