/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils;

import com.tssap.j2ee.core.utils.AbstractJ2eeProject;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public abstract class AbstractJ2eeProjectNature
implements IProjectNature {
    private static final String IMPLEMENTATION_TAG = "implementation";
    private static final String CLASS_ATTRIBUTE = "class";

    public abstract AbstractJ2eeProject getJ2eeProject();

    protected abstract void setJ2eeProject(AbstractJ2eeProject var1);

    protected abstract IExtensionPoint getExtPoint();

    public IProject getProject() {
        AbstractJ2eeProject j2eeProject = this.getJ2eeProject();
        if (j2eeProject == null) {
            return null;
        }
        return j2eeProject.getProject();
    }

    public void setProject(IProject project) {
        AbstractJ2eeProject j2eeProject = null;
        IExtensionPoint extPoint = this.getExtPoint();
        IExtension[] extensions = extPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement next = elements[j];
                if (IMPLEMENTATION_TAG.equals(next.getName())) {
                    if (j2eeProject != null) {
                        UtilsPlugin.logWarning("One more j2ee project implementation found: " + next.getAttribute(CLASS_ATTRIBUTE));
                    } else {
                        try {
                            j2eeProject = (AbstractJ2eeProject)next.createExecutableExtension(CLASS_ATTRIBUTE);
                            j2eeProject.setProject(project);
                            this.setJ2eeProject(j2eeProject);
                            UtilsPlugin.logInfo("J2ee project created: " + j2eeProject);
                        }
                        catch (Throwable e) {
                            j2eeProject = null;
                            UtilsPlugin.logError("Unable to instantiate j2ee project: " + next.getAttribute(CLASS_ATTRIBUTE), e);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void configure() throws CoreException {
        AbstractJ2eeProject j2eeProject = this.getJ2eeProject();
        if (j2eeProject == null) {
            return;
        }
        j2eeProject.configureProject();
    }

    public void deconfigure() throws CoreException {
    }
}

