/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public abstract class AbstractJ2eeProject {
    private static String EJB = "javax.ejb.EnterpriseBean";
    protected static String OUR_EJB_LIB = "lib/ejb20.jar";
    protected static String OUR_JMS_LIB = "lib/jms.jar";
    protected static String OUR_WEB_LIB = "lib/servlet.jar";
    protected static String OUR_JDBC_LIB = "lib/jdbc20.jar";
    private IProject myProject;
    private IJavaProject myJavaProject;

    public final IJavaProject getJavaProject() {
        if (this.myJavaProject == null) {
            this.myJavaProject = JavaCore.create((IProject)this.getProject());
        }
        return this.myJavaProject;
    }

    public final IProject getProject() {
        return this.myProject;
    }

    protected void setProject(IProject project) {
        this.myProject = project;
        this.myJavaProject = null;
    }

    protected void configureProject() throws CoreException {
    }

    protected boolean isJ2eeApiAvailable() {
        try {
            IJavaProject javaProject = this.getJavaProject();
            if (javaProject == null) {
                return false;
            }
            IType type = javaProject.findType(EJB);
            return type != null && type.exists();
        }
        catch (JavaModelException jme) {
            return false;
        }
    }

    protected void addJ2eeLibrary() {
        IClasspathEntry[] classPath;
        Path[] libPath;
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            UtilsPlugin.logWarning("Java nature required to add j2ee library");
            return;
        }
        IPath extLibJavaxDir = JavaCore.getClasspathVariable((String)"TSSAP_JAVAX_HOME");
        if (extLibJavaxDir != null) {
            String[] libFiles = this.getRequiredLibraries();
            if (libFiles != null) {
                libPath = new Path[libFiles.length];
                int i = 0;
                while (i < libFiles.length) {
                    libPath[i] = new Path("TSSAP_JAVAX_HOME" + File.separator + libFiles[i]);
                    ++i;
                }
            } else {
                libPath = new Path[]{};
            }
        } else {
            UtilsPlugin.logError("javax plugin not found");
            return;
        }
        try {
            classPath = javaProject.getRawClasspath();
        }
        catch (JavaModelException jme) {
            UtilsPlugin.logError("Unable to retieve project classpath", jme);
            return;
        }
        ArrayList<IClasspathEntry> newClasspathEntries = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < libPath.length) {
            IClasspathEntry varEntry = JavaCore.newVariableEntry((IPath)libPath[i], null, null, (boolean)true);
            if (this.classpathContains(classPath, varEntry)) {
                UtilsPlugin.logInfo("J2ee library already added to classpath");
            } else {
                newClasspathEntries.add(varEntry);
            }
            ++i;
        }
        if (newClasspathEntries.size() > 0) {
            IClasspathEntry[] newClassPath = new IClasspathEntry[classPath.length + newClasspathEntries.size()];
            System.arraycopy(classPath, 0, newClassPath, 0, classPath.length);
            int i2 = 0;
            while (i2 < newClasspathEntries.size()) {
                newClassPath[classPath.length + i2] = (IClasspathEntry)newClasspathEntries.get(i2);
                ++i2;
            }
            try {
                javaProject.setRawClasspath(newClassPath, null);
            }
            catch (JavaModelException jme) {
                UtilsPlugin.logError("Unable to set project classpath", jme);
            }
        }
    }

    protected abstract String[] getRequiredLibraries();

    protected boolean classpathContains(IClasspathEntry[] list, IClasspathEntry entry) {
        int i = 0;
        while (i < list.length) {
            IClasspathEntry other = list[i];
            if (other.getContentKind() == entry.getContentKind() && other.getEntryKind() == entry.getEntryKind() && other.getPath().equals((Object)entry.getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

