/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.toolkit;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class ProjectManager {
    private IProject[] m_projects;
    private IContainer workspaceRoot;

    public ProjectManager() {
        this.setWorkspaceRoot();
        this.setProjects();
    }

    private void setWorkspaceRoot() {
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    }

    public IContainer getWorkspaceRoot() {
        return this.workspaceRoot;
    }

    private void setProjects() {
        this.m_projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public IProject[] getProjects() {
        return this.m_projects;
    }

    public String[] getProjectNames() {
        String[] m_projectnames = new String[this.m_projects.length];
        int j = 0;
        while (j < this.m_projects.length) {
            m_projectnames[j] = this.m_projects[j].getName();
            ++j;
        }
        return m_projectnames;
    }

    public IPath getProjectLocation(String projectname) {
        int j = 0;
        while (j < this.m_projects.length) {
            if (this.m_projects[j].getName().equals(projectname)) {
                return this.m_projects[j].getLocation();
            }
            ++j;
        }
        return null;
    }

    public IPath getProjectPath(String projectname) {
        int j = 0;
        while (j < this.m_projects.length) {
            if (this.m_projects[j].getName().equals(projectname)) {
                return this.m_projects[j].getFullPath();
            }
            ++j;
        }
        return null;
    }

    public IProject getProjectFromName(String projectname) {
        int j = 0;
        while (j < this.m_projects.length) {
            if (this.m_projects[j].getName().equals(projectname)) {
                return this.m_projects[j];
            }
            ++j;
        }
        return null;
    }

    public static String getEclipseRootPath() {
        StringTokenizer stoken = new StringTokenizer(System.getProperty("java.class.path"), ";");
        String rootPath = "";
        while (stoken.hasMoreElements()) {
            rootPath = stoken.nextToken().replace('\\', '/');
            if (!rootPath.endsWith("startup.jar")) continue;
            rootPath = rootPath.substring(0, rootPath.length() - "startup.jar".length() - 1);
            break;
        }
        return rootPath;
    }
}

