/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.toolkit;

import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.toolkit.DocumentNavigationException;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DocumentNavigator {
    private Document m_document;

    public DocumentNavigator(Document document) {
        this.m_document = document;
    }

    public Document getDocument() {
        return this.m_document;
    }

    private static Vector getChildrenAsList(Element base) {
        Vector<Node> nodeVec = new Vector<Node>();
        NodeList nodes = base.getChildNodes();
        int j = 0;
        while (j < nodes.getLength()) {
            if (nodes.item(j).getNodeType() == 1) {
                nodeVec.add(nodes.item(j));
            }
            ++j;
        }
        return nodeVec;
    }

    private Vector getChildrenAsList(Vector elementVector) {
        Vector levelNodeVec = new Vector();
        int j = 0;
        while (j < elementVector.size()) {
            if (((Element)elementVector.get(j)).getNodeType() == 1) {
                levelNodeVec.addAll(DocumentNavigator.getChildrenAsList((Element)elementVector.get(j)));
            }
            ++j;
        }
        return levelNodeVec;
    }

    private Vector getElementListByName(Vector elementVector, String name) throws DocumentNavigationException {
        Vector nameVec = new Vector();
        int j = 0;
        while (j < elementVector.size()) {
            try {
                if (((Element)elementVector.get(j)).getNodeType() == 1 && ((Element)elementVector.get(j)).getNodeName().trim().equals(name.trim())) {
                    nameVec.add(elementVector.get(j));
                }
            }
            catch (Exception e) {
                throw new DocumentNavigationException(e.getMessage() + " Maybe mismatch of type of object in list.");
            }
            ++j;
        }
        return nameVec;
    }

    public Element getElement(String elementName, int level, int siblingNumber) throws DocumentNavigationException {
        int column = siblingNumber - 1;
        Vector tempVec = new Vector();
        if (level < 0 || column < 0) {
            throw new DocumentNavigationException("Illegal tree coordinates: Level = " + level + ", Column = " + siblingNumber);
        }
        if (level == 0 && this.m_document.getDocumentElement().getNodeName().trim().equals(elementName.trim())) {
            return this.m_document.getDocumentElement();
        }
        tempVec.add(this.m_document.getDocumentElement());
        int j = 0;
        while (j < level) {
            tempVec = this.getChildrenAsList(tempVec);
            ++j;
        }
        if ((tempVec = this.getElementListByName(tempVec, elementName)).size() < column + 1) {
            throw new DocumentNavigationException("Number of elements with name \"" + elementName + "\" at level " + level + ": " + tempVec.size() + "; Selected Column number = " + siblingNumber);
        }
        return (Element)tempVec.get(column);
    }

    public ByteArrayOutputStream getDocumentAsOutputStream() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Thread.currentThread().setContextClassLoader(cl);
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(this.m_document);
            StreamResult result = new StreamResult(output);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException tce) {
            tce.printStackTrace();
        }
        catch (TransformerException te) {
            te.printStackTrace();
        }
        return output;
    }

    private static String switchWhitespaceToBlank(String text, boolean switchAllWhiteSpaces) {
        boolean lastCharIsBlank = false;
        String adjustedText = text;
        adjustedText.trim();
        if (!switchAllWhiteSpaces) {
            return adjustedText;
        }
        StringBuffer textBuffer = new StringBuffer(text);
        int j = 0;
        while (j < textBuffer.length()) {
            if (Character.isWhitespace(textBuffer.charAt(j))) {
                if (lastCharIsBlank) {
                    textBuffer.deleteCharAt(j);
                    --j;
                } else {
                    textBuffer.setCharAt(j, ' ');
                }
                lastCharIsBlank = true;
            } else {
                lastCharIsBlank = false;
            }
            ++j;
        }
        return textBuffer.toString().trim();
    }

    public static boolean compareNodes(Node n1, Node n2) {
        return DocumentNavigator.compareNodes(n1, n2, false, true, true);
    }

    public static boolean compareNodes(Node n1, Node n2, boolean ignoreWhitespaceType, boolean ignoreComments, boolean deep) {
        if (n1.equals(n2)) {
            return true;
        }
        if (n1.getNodeType() != n2.getNodeType()) {
            return false;
        }
        if (n1.getNodeType() == 5 || n1.getNodeType() == 6 || n1.getNodeType() == 7 || n1.getNodeType() == 8 || n1.getNodeType() == 9 || n1.getNodeType() == 10 || n1.getNodeType() == 11 || n1.getNodeType() == 12) {
            return true;
        }
        if (n1.getNodeType() == 3) {
            return DocumentNavigator.switchWhitespaceToBlank(((Text)n1).getData(), ignoreWhitespaceType).equals(DocumentNavigator.switchWhitespaceToBlank(((Text)n2).getData(), ignoreWhitespaceType));
        }
        if (n1.getNodeType() == 4) {
            return DocumentNavigator.switchWhitespaceToBlank(((CDATASection)n1).getData(), ignoreWhitespaceType).equals(DocumentNavigator.switchWhitespaceToBlank(((CDATASection)n2).getData(), ignoreWhitespaceType));
        }
        if (!n1.getNodeName().trim().equals(n2.getNodeName().trim())) {
            return false;
        }
        if (n1.getNodeType() == 2) {
            return ((Attr)n1).getValue().trim().equals(((Attr)n2).getValue().trim());
        }
        if (!DocumentNavigator.compareAttributes(n1, n2)) {
            return false;
        }
        if (!deep) {
            return true;
        }
        return DocumentNavigator.compareNodeLists(n1.getChildNodes(), n2.getChildNodes(), ignoreWhitespaceType, ignoreComments, deep);
    }

    private static Vector attributeListFromNodeMap(NamedNodeMap map) {
        Vector<Node> list = new Vector<Node>();
        int j = 0;
        while (j < map.getLength()) {
            list.add(map.item(j));
            ++j;
        }
        return list;
    }

    private static Vector nodeListFromNodeList(NodeList nodeList, boolean ignoreComments) {
        Vector<Node> list = new Vector<Node>();
        int j = 0;
        while (j < nodeList.getLength()) {
            if (ignoreComments && nodeList.item(j).getNodeType() == 8) {
                Node previousSibling = nodeList.item(j).getPreviousSibling();
                Node nextSibling = nodeList.item(j).getNextSibling();
                if (previousSibling.getNodeType() == 3 && nextSibling.getNodeType() == 3) {
                    previousSibling.setNodeValue(previousSibling.getNodeValue() + " " + nextSibling.getNodeValue());
                }
                j += 2;
            }
            list.add(nodeList.item(j));
            ++j;
        }
        return list;
    }

    public static NodeList getNodeListFromTag(Document doc, String tagname) {
        return doc.getElementsByTagName(tagname);
    }

    public static boolean isContainedIn(String containee, String container) {
        boolean check = false;
        int j = 0;
        while (j < container.length() - containee.length() && !check) {
            check = container.regionMatches(j, containee, 0, containee.length());
            ++j;
        }
        return check;
    }

    public static boolean compareAttributes(Node n1, Node n2) {
        int marker = -1;
        boolean check = false;
        NamedNodeMap map1 = n1.getAttributes();
        NamedNodeMap map2 = n2.getAttributes();
        Vector attributeList = DocumentNavigator.attributeListFromNodeMap(map2);
        int j = 0;
        while (j < map1.getLength()) {
            Attr a1 = (Attr)map1.item(j);
            check = false;
            int i = 0;
            while (i < attributeList.size()) {
                Attr a2 = (Attr)attributeList.get(i);
                if (a1.getName().trim().equals(a2.getName().trim()) && a1.getValue().trim().equals(a2.getValue().trim())) {
                    check = true;
                    marker = i;
                    break;
                }
                check |= false;
                ++i;
            }
            if (!check) {
                return check;
            }
            attributeList.removeElementAt(marker);
            marker = -1;
            ++j;
        }
        return attributeList.size() == 0;
    }

    public static boolean compareNodeLists(NodeList list1, NodeList list2) {
        return DocumentNavigator.compareNodeLists(list1, list2, false, true, true);
    }

    public static boolean compareNodeLists(NodeList list1, NodeList list2, boolean ignoreWhitespaceType, boolean ignoreComments, boolean deep) {
        int marker = -1;
        boolean check = false;
        Vector nodeList1 = DocumentNavigator.nodeListFromNodeList(list1, ignoreComments);
        Vector nodeList2 = DocumentNavigator.nodeListFromNodeList(list2, ignoreComments);
        int j = 0;
        while (j < nodeList1.size()) {
            if (nodeList2.size() == 0) {
                return false;
            }
            Node node1 = (Node)nodeList1.get(j);
            check = false;
            int i = 0;
            while (i < nodeList2.size()) {
                Node node2 = (Node)nodeList2.get(i);
                if (DocumentNavigator.compareNodes(node1, node2, ignoreWhitespaceType, ignoreComments, deep)) {
                    check = true;
                    marker = i;
                    break;
                }
                check |= false;
                ++i;
            }
            if (!check) {
                return check;
            }
            nodeList2.removeElementAt(marker);
            marker = -1;
            ++j;
        }
        return nodeList2.size() == 0;
    }

    public static boolean firstIsChildOfSecond(Node child, Node parent) {
        return DocumentNavigator.firstIsChildOfSecond(child, parent, false, true);
    }

    public static boolean firstIsChildOfSecond(Node child, Node parent, boolean ignoreComments) {
        return DocumentNavigator.firstIsChildOfSecond(child, parent, false, ignoreComments);
    }

    public static boolean firstIsChildOfSecond(Node child, Node parent, boolean ignoreWhitespace, boolean ignoreComments) {
        boolean check = false;
        NodeList allChildren = parent.getChildNodes();
        int j = 0;
        while (!check && j < allChildren.getLength()) {
            check |= DocumentNavigator.compareNodes(child, allChildren.item(j), ignoreWhitespace, ignoreComments, true);
            ++j;
        }
        return check;
    }

    public static boolean setAttributesForKey(Node adjustee, Node adjuster, String attribKey, boolean merge) {
        boolean adjusted = false;
        NamedNodeMap adjusteeAttributes = adjustee.getAttributes();
        NamedNodeMap adjusterAttributes = adjuster.getAttributes();
        Attr attributer = (Attr)adjusterAttributes.getNamedItem(attribKey);
        Attr attributee = (Attr)adjusteeAttributes.getNamedItem(attribKey);
        if (attributer == null || attributee == null || !attributer.getValue().equals(attributee.getValue())) {
            return false;
        }
        int i = 0;
        while (i < adjusterAttributes.getLength()) {
            if (merge || adjusteeAttributes.getNamedItem(((Attr)adjusterAttributes.item(i)).getName()) != null) {
                ((Attr)adjusteeAttributes.getNamedItem(((Attr)adjusterAttributes.item(i)).getName())).setValue(((Attr)adjusterAttributes.item(i)).getValue());
                adjusted = true;
            }
            ++i;
        }
        return adjusted;
    }

    public static boolean setAttributesForKey(Node adjustee, Node adjuster, String attribKey) {
        return DocumentNavigator.setAttributesForKey(adjustee, adjuster, attribKey, false);
    }
}

