/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards;

import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.RepositoryManagerBaseWizard;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.ServiceFilterGeneratorController;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.ServiceFilterGeneratorModel;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.ServiceFilterWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class ServiceFilterWizard
extends RepositoryManagerBaseWizard {
    private ServiceFilterWizardPage wizardPage;
    private boolean worked = true;
    private IProject project;
    private String templateLocation;
    private ISelection selection;
    private String projectRootPath = "";
    private ServiceFilterGeneratorModel sfModel;

    public ServiceFilterWizard() {
        this.setWindowTitle("KMC Wizard");
    }

    public ServiceFilterWizard(IProject selectedProject) {
        super(selectedProject);
    }

    public void addPages() {
        this.wizardPage = this.getProject() != null ? new ServiceFilterWizardPage(this.selection, this.sfModel, this.getProject()) : new ServiceFilterWizardPage(this.selection, this.sfModel, this.projectRootPath);
        this.addPage((IWizardPage)this.wizardPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.sfModel = new ServiceFilterGeneratorModel();
        StringTokenizer stoken = new StringTokenizer(System.getProperty("java.class.path"), ";");
        String testString = "";
        while (stoken.hasMoreElements()) {
            testString = stoken.nextToken().replace('\\', '/');
            if (!testString.endsWith("startup.jar")) continue;
            testString = testString.substring(0, testString.length() - "startup.jar".length() - 1);
            break;
        }
        this.sfModel.setEclipseRootPath(testString);
    }

    public boolean performFinish() {
        List serviceFilterList = this.sfModel.getServiceFilterVariantList();
        this.sfModel.setConfigFrameworkVersion(this.wizardPage.getConfigFrameworkVersion());
        this.sfModel.setProjectName(this.wizardPage.getSelectedProjectName());
        this.sfModel.getSelectedServiceFilterDescription().clear();
        Iterator serviceFilterIter = serviceFilterList.iterator();
        while (serviceFilterIter.hasNext()) {
            String serviceFilterVariant = (String)serviceFilterIter.next();
            HashMap<String, String> descriptor = new HashMap<String, String>();
            descriptor.put("classname", ((Text)this.wizardPage.getClassNameMap().get(serviceFilterVariant)).getText());
            descriptor.put("packagename", ((Text)this.wizardPage.getPackageNameMap().get(serviceFilterVariant)).getText());
            descriptor.put("sfname", ((Text)this.wizardPage.getServiceFilterNameMap().get(serviceFilterVariant)).getText());
            String folderOrProjectName = "";
            if (this.wizardPage.getProjectRootPath().equals("") && !this.wizardPage.getSelectedProjectLocation().equals("")) {
                this.setCurrentProject(null);
            }
            folderOrProjectName = this.wizardPage.getGeneratedSourceFolderName();
            descriptor.put("foldername", folderOrProjectName);
            this.sfModel.getSelectedServiceFilterDescription().put(serviceFilterVariant, descriptor);
        }
        this.sfModel.setRepositoryFilterSubtype(this.wizardPage.getRepositoryFilterSubtypeName());
        this.sfModel.setClasspathGenerationOption(this.wizardPage.getClasspathGenerationOption());
        Iterator iter = this.wizardPage.getServicesAndFiltersMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String packageName = (String)entry.getKey();
            String[] serviceFilterInterfaces = ((org.eclipse.swt.widgets.List)entry.getValue()).getSelection();
            int i = 0;
            while (i < serviceFilterInterfaces.length) {
                this.sfModel.setServiceFilterInterface(packageName, serviceFilterInterfaces[i], true);
                ++i;
            }
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    ServiceFilterWizard.this.doFinish(ServiceFilterWizard.this.sfModel, monitor);
                }
                catch (CoreException e) {
                    System.out.println("doFinish() terminated erroneously: ");
                    e.printStackTrace();
                    MessageDialog.openError((Shell)ServiceFilterWizard.this.getShell(), (String)"Error: dofinish() terminated erroneously ", (String)e.getMessage());
                    throw new InvocationTargetException(e, "doFinish() terminated erroneously.");
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            System.out.println("getContainer() terminated erroneously: " + e.getMessage());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error: getContainer() terminated erroneously ", (String)e.getMessage());
            return false;
        }
        catch (InvocationTargetException e) {
            System.out.println("getContainer() terminated erroneously: ");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void doFinish(ServiceFilterGeneratorModel sfModel, IProgressMonitor monitor) throws CoreException {
        int taskTime = 0;
        taskTime = 7;
        int statusCode = 0;
        if (!sfModel.getSelectedServiceFilterDescription().isEmpty()) {
            monitor.beginTask("Generating services and filters ...", taskTime);
            monitor.worked(2);
            monitor.setTaskName("Prepare controller ...");
            ServiceFilterGeneratorController sfController = new ServiceFilterGeneratorController();
            monitor.worked(3);
            monitor.setTaskName("Create configuration and source files ...");
            if (this.getProject() == null) {
                this.setProject(this.wizardPage.getSelectedProject());
            }
            if (this.getProject() != null) {
                sfModel.setProjectName(this.getProject().getName());
            } else {
                sfModel.setProjectName("");
            }
            sfController.generate(sfModel);
            monitor.worked(2);
            if (this.getProject() != null) {
                try {
                    this.getProject().build(6, monitor);
                    this.getProject().refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    statusCode = e.getStatus().getCode();
                    monitor.setTaskName(e.getStatus().getMessage());
                    e.printStackTrace();
                    throw e;
                }
            }
            if (statusCode != 4) {
                monitor.done();
            }
        }
    }

    public void setCurrentProject(IProject project) {
        this.project = project != null ? project : this.wizardPage.getSelectedProject();
    }
}

