/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards;

import com.sap.netweaver.bc.km.plugin.eprf.general.kmWizards.ControllerAttributes;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.ServiceFilterGeneratorModel;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.toolkit.DocumentNavigator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eclipse.core.runtime.model.PluginRegistryModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceFilterGeneratorController {
    private PluginRegistryModel pmodel = new PluginRegistryModel();
    static /* synthetic */ Class class$com$sap$netweaver$bc$km$plugin$eprf$ideSpecific$kmComponentWizards$RFPluginLogger;

    public void generate(ServiceFilterGeneratorModel sfModel, String sfVariant) {
        boolean scratch = false;
        String packageName = "";
        Map descr = (Map)sfModel.getSelectedServiceFilterDescription().get(sfVariant);
        String className = (String)descr.get("classname");
        packageName = descr.get("packagename") != null && !((String)descr.get("packagename")).equals("") ? (String)descr.get("packagename") : "com.sap.standard";
        String serviceFilterName = (String)descr.get("sfname");
        String repositoryFilterType = sfModel.getRepositoryFilterSubtype();
        String cc_extension = "";
        String cc_type = "";
        String cc_manager = "";
        if (sfVariant.equals("GlobalService")) {
            cc_extension = "Service";
            cc_type = "type=\"singleton\"";
            cc_manager = "";
        }
        if (sfVariant.equals("RepositoryService")) {
            cc_extension = "RepositoryService";
            cc_type = "";
            cc_manager = "";
        }
        if (sfVariant.equals("RepositoryFilter")) {
            cc_extension = "RepositoryFilter";
            cc_type = "";
            cc_manager = "Manager";
        }
        if (sfVariant.equals("SchedulerTask")) {
            cc_extension = "SchedulerTask";
            cc_type = "";
            cc_manager = "";
        }
        if (className.equals("")) {
            return;
        }
        if (serviceFilterName.equals("") || serviceFilterName.length() == 0 || serviceFilterName == null) {
            serviceFilterName = className;
        }
        try {
            block17: {
                try {
                    VelocityEngine engine = new VelocityEngine();
                    Properties velocityProperties = new Properties();
                    ((Hashtable)velocityProperties).put("resource.loader", "class");
                    ((Hashtable)velocityProperties).put("class.resource.loader.description", "Velocity Classpath Resource Loader");
                    ((Hashtable)velocityProperties).put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
                    ((Hashtable)velocityProperties).put("runtime.log.logsystem.class", (class$com$sap$netweaver$bc$km$plugin$eprf$ideSpecific$kmComponentWizards$RFPluginLogger == null ? (class$com$sap$netweaver$bc$km$plugin$eprf$ideSpecific$kmComponentWizards$RFPluginLogger = ServiceFilterGeneratorController.class$("com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.RFPluginLogger")) : class$com$sap$netweaver$bc$km$plugin$eprf$ideSpecific$kmComponentWizards$RFPluginLogger).getName());
                    engine.init(velocityProperties);
                    VelocityContext context = new VelocityContext();
                    context.put("rmModel", (Object)sfModel);
                    context.put("sfModel", (Object)sfModel);
                    context.put("sfVariant", (Object)sfVariant);
                    context.put("descr", (Object)descr);
                    context.put("className", (Object)className);
                    context.put("packageName", (Object)packageName);
                    context.put("serviceFilterName", (Object)serviceFilterName);
                    context.put("repositoryFilterType", (Object)repositoryFilterType);
                    context.put("cc_extension", (Object)cc_extension);
                    context.put("cc_type", (Object)cc_type);
                    context.put("cc_manager", (Object)cc_manager);
                    String sourceFolderName = (String)descr.get("foldername");
                    String srcApiFolderName = sourceFolderName + File.separator + "src.api";
                    String srcConfigFolderName = sourceFolderName + File.separator + "src.config";
                    String metaCmFolderName = sourceFolderName + File.separator + (String)ControllerAttributes.getVersionedMetaDirectory().get(sfModel.getConfigFrameworkVersion()) + File.separator + "cm";
                    String dataCmFolderName = sourceFolderName + File.separator + (String)ControllerAttributes.getVersionedDataDirectory().get(sfModel.getConfigFrameworkVersion()) + File.separator + "cm";
                    String portalAppFolderName = sourceFolderName + File.separator + "dist" + File.separator + "PORTAL-INF";
                    String packageApiFolderName = srcApiFolderName + File.separator + packageName.replace('.', File.separatorChar);
                    String repositoryFilterClassFolderName = metaCmFolderName + File.separator + "repository_filters";
                    String repositoryServiceClassFolderName = metaCmFolderName + File.separator + "repository_services";
                    String serviceClassFolderName = metaCmFolderName + File.separator + "services";
                    String schedulerTaskClassFolderName = serviceClassFolderName + File.separator + "schedulertasks";
                    String repositoryFilterInstanceFolderName = dataCmFolderName + File.separator + "repository_filters";
                    String repositoryServiceInstanceFolderName = dataCmFolderName + File.separator + "repository_services";
                    String serviceInstanceFolderName = dataCmFolderName + File.separator + "services";
                    String schedulerTaskInstanceFolderName = serviceInstanceFolderName + File.separator + "schedulertasks";
                    File srcConfigFolder = new File(srcConfigFolderName);
                    File metaCmFolder = new File(metaCmFolderName);
                    File portalAppFolder = new File(portalAppFolderName);
                    File packageApiFolder = new File(packageApiFolderName);
                    File repositoryFilterClassFolder = new File(repositoryFilterClassFolderName);
                    File repositoryServiceClassFolder = new File(repositoryServiceClassFolderName);
                    File schedulerTaskClassFolder = new File(schedulerTaskClassFolderName);
                    File repositoryFilterInstanceFolder = new File(repositoryFilterInstanceFolderName);
                    File repositoryServiceInstanceFolder = new File(repositoryServiceInstanceFolderName);
                    File schedulerTaskInstanceFolder = new File(schedulerTaskInstanceFolderName);
                    File outputFolderForWrapper = new File(srcApiFolderName + File.separator + ControllerAttributes.GENERIC_WRAPPER_PATHLET);
                    srcConfigFolder.mkdirs();
                    metaCmFolder.mkdirs();
                    portalAppFolder.mkdirs();
                    packageApiFolder.mkdirs();
                    outputFolderForWrapper.mkdirs();
                    repositoryFilterClassFolder.mkdirs();
                    repositoryServiceClassFolder.mkdirs();
                    schedulerTaskClassFolder.mkdirs();
                    repositoryFilterInstanceFolder.mkdirs();
                    repositoryServiceInstanceFolder.mkdirs();
                    schedulerTaskInstanceFolder.mkdirs();
                    this.generatePortalApp(engine, context, "GeneralServiceFilter/RFServiceWrapperPortalapp.xml.template", new File(portalAppFolderName, "portalapp.xml"));
                    if (!new File(srcConfigFolder, "configArchive.properties").exists()) {
                        this.generate(engine, context, "RepositoryManager/configArchive.properties.template", new File(srcConfigFolder, "configArchive.properties"), scratch);
                    }
                    if (!new File(outputFolderForWrapper, "IRFServiceWrapper.java").exists()) {
                        this.generate(engine, context, "GeneralServiceFilter/IRFServiceWrapper.java.template", new File(outputFolderForWrapper, "IRFServiceWrapper.java"), scratch);
                    }
                    if (!new File(outputFolderForWrapper, "RFServiceWrapper.java").exists()) {
                        this.generate(engine, context, "GeneralServiceFilter/RFServiceWrapper.java.template", new File(outputFolderForWrapper, "RFServiceWrapper.java"), scratch);
                    }
                    if (sfVariant.equals("GlobalService")) {
                        this.generate(engine, context, "GlobalService/GlobalService.java.template", new File(packageApiFolderName, className + ".java"), scratch);
                        this.generate(engine, context, "GeneralServiceFilter/ServiceFilter.cc.xml.template", new File(serviceClassFolderName, packageName + "." + serviceFilterName + ".cc.xml"), scratch);
                        this.generate(engine, context, "GeneralServiceFilter/ServiceFilter.co.xml.template", new File(serviceInstanceFolderName, packageName + "." + serviceFilterName + ".co.xml"), scratch);
                    }
                    if (sfVariant.equals("RepositoryFilter")) {
                        this.generate(engine, context, "RepositoryFilter/Repository" + repositoryFilterType + "Filter.java.template", new File(packageApiFolderName, className + ".java"), scratch);
                        this.generate(engine, context, "RepositoryFilter/Repository" + repositoryFilterType + "FilterManager.java.template", new File(packageApiFolderName, className + "Manager.java"), scratch);
                        this.generate(engine, context, "GeneralServiceFilter/ServiceFilter.cc.xml.template", new File(repositoryFilterClassFolderName, packageName + "." + serviceFilterName + ".cc.xml"), scratch);
                        this.generate(engine, context, "GeneralServiceFilter/ServiceFilter.co.xml.template", new File(repositoryFilterInstanceFolderName, packageName + "." + serviceFilterName + ".co.xml"), scratch);
                    }
                    if (sfVariant.equals("RepositoryService")) {
                        this.generate(engine, context, "RepositoryService/RepositoryService.java.template", new File(packageApiFolderName, className + ".java"), scratch);
                        this.generate(engine, context, "GeneralServiceFilter/ServiceFilter.cc.xml.template", new File(repositoryServiceClassFolderName, packageName + "." + serviceFilterName + ".cc.xml"), scratch);
                        this.generate(engine, context, "GeneralServiceFilter/ServiceFilter.co.xml.template", new File(repositoryServiceInstanceFolderName, packageName + "." + serviceFilterName + ".co.xml"), scratch);
                    }
                    if (sfVariant.equals("SchedulerTask")) {
                        this.generate(engine, context, "SchedulerTask/SchedulerTask.java.template", new File(packageApiFolderName, className + ".java"), scratch);
                        this.generate(engine, context, "GeneralServiceFilter/ServiceFilter.cc.xml.template", new File(schedulerTaskClassFolderName, packageName + "." + serviceFilterName + ".cc.xml"), scratch);
                        this.generate(engine, context, "GeneralServiceFilter/ServiceFilter.co.xml.template", new File(schedulerTaskInstanceFolderName, packageName + "." + serviceFilterName + ".co.xml"), scratch);
                    }
                    if (!sfModel.getClasspathGenerationOption().equals("Yes")) break block17;
                    this.generateClasspathFile(engine, context, "RepositoryManager/classpath.template", new File(sourceFolderName, ".classpath"), true);
                    this.generateClasspathFile(engine, context, "GeneralServiceFilter/SFclasspath.template", new File(sourceFolderName, ".classpath"), false);
                }
                catch (Exception exception) {
                    System.out.println("Caught exception: " + exception.getMessage());
                    exception.printStackTrace();
                    Object var42_43 = null;
                }
            }
            Object var42_42 = null;
        }
        catch (Throwable throwable) {
            Object var42_44 = null;
            throw throwable;
        }
    }

    public void generate(ServiceFilterGeneratorModel sfmodel) {
        Map selectionMap = sfmodel.getSelectedServiceFilterDescription();
        Iterator iter = selectionMap.keySet().iterator();
        while (iter.hasNext()) {
            String sfVariant = (String)iter.next();
            this.generate(sfmodel, sfVariant);
        }
    }

    private void generate(String templateName, File outputFile) {
    }

    private void generate(VelocityEngine engine, VelocityContext context, String templateName, File outputFile, boolean scratch) {
        if (!scratch && outputFile.isFile()) {
            return;
        }
        try {
            try {
                Template template = engine.getTemplate(templateName);
                BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
                template.merge((Context)context, (Writer)writer);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (Exception exception) {
                System.out.println("Caught exception: " + exception.getMessage());
                exception.printStackTrace();
                Object var9_10 = null;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            throw throwable;
        }
    }

    private void generatePortalApp(VelocityEngine engine, VelocityContext context, String templateName, File outputFile) {
        if (!outputFile.isFile()) {
            this.generate(engine, context, templateName, outputFile, true);
            return;
        }
        try {
            Template template = engine.getTemplate(templateName);
            File tempFile = new File(outputFile.getAbsoluteFile() + ".tmp");
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
            template.merge((Context)context, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Thread.currentThread().setContextClassLoader(cl);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document templateDocument = builder.parse(tempFile);
            tempFile.deleteOnExit();
            Document fileDocument = builder.parse(outputFile);
            DocumentNavigator templateNav = new DocumentNavigator(templateDocument);
            DocumentNavigator fileNav = new DocumentNavigator(fileDocument);
            Element appConf = fileNav.getElement("application-config", 1, 1);
            Element services = fileNav.getElement("services", 1, 1);
            NodeList appConfPropList = appConf.getElementsByTagName("property");
            Element appConfTemplate = templateNav.getElement("application-config", 1, 1);
            Element servicesTemplate = templateNav.getElement("services", 1, 1);
            NodeList appConfTemplatePropList = appConfTemplate.getElementsByTagName("property");
            NodeList servicesTemplateServList = servicesTemplate.getElementsByTagName("service");
            boolean replaced = false;
            int j = 0;
            while (j < appConfTemplatePropList.getLength()) {
                replaced = false;
                if (!DocumentNavigator.firstIsChildOfSecond(appConfTemplatePropList.item(j), appConf)) {
                    int i = 0;
                    while (i < appConfPropList.getLength()) {
                        replaced = DocumentNavigator.setAttributesForKey(appConfPropList.item(i), appConfTemplatePropList.item(j), "name", true);
                        ++i;
                    }
                    if (!replaced) {
                        appConf.appendChild(fileDocument.importNode(appConfTemplatePropList.item(j), true));
                        appConf.appendChild(fileDocument.createTextNode("\n  "));
                    }
                }
                ++j;
            }
            int j2 = 0;
            while (j2 < servicesTemplateServList.getLength()) {
                if (!DocumentNavigator.firstIsChildOfSecond(servicesTemplateServList.item(j2), services)) {
                    services.appendChild(fileDocument.createTextNode("\n  "));
                    services.appendChild(fileDocument.importNode(servicesTemplateServList.item(j2), true));
                    appConf.appendChild(fileDocument.createTextNode("\n  "));
                }
                ++j2;
            }
            fileNav.getDocumentAsOutputStream().writeTo(new FileOutputStream(outputFile));
        }
        catch (Exception exception) {
            System.out.println("Caught exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void generateClasspathFile(VelocityEngine engine, VelocityContext context, String templateName, File outputFile, boolean overwrite) {
        if (!outputFile.isFile()) {
            this.generate(engine, context, templateName, outputFile, true);
            return;
        }
        try {
            Template template = engine.getTemplate(templateName);
            File tempFile = new File(outputFile.getAbsoluteFile() + ".tmp");
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
            template.merge((Context)context, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Thread.currentThread().setContextClassLoader(cl);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document templateDocument = builder.parse(tempFile);
            tempFile.deleteOnExit();
            Document fileDocument = builder.parse(outputFile);
            DocumentNavigator templateNav = new DocumentNavigator(templateDocument);
            DocumentNavigator fileNav = new DocumentNavigator(fileDocument);
            Element classpathTag = fileNav.getElement("classpath", 0, 1);
            Element classpathTemplate = templateNav.getElement("classpath", 0, 1);
            NodeList classpathTemplateClsList = classpathTemplate.getElementsByTagName("classpathentry");
            NodeList classpathTagClsList = classpathTag.getElementsByTagName("classpathentry");
            Vector<Node> allNodesToDelete = new Vector<Node>();
            boolean incorrectOutput = false;
            boolean incorrectSource = true;
            int j = 0;
            while (overwrite && j < classpathTagClsList.getLength()) {
                NamedNodeMap attribMap = classpathTagClsList.item(j).getAttributes();
                Node pathnode = attribMap.getNamedItem("path");
                String pathname = pathnode.getNodeValue();
                if (pathname.equals("src.api") && attribMap.getNamedItem("kind").getNodeValue().equals("src")) {
                    incorrectSource = false;
                }
                if (pathname.equals("") && attribMap.getNamedItem("kind").getNodeValue().equals("src")) {
                    allNodesToDelete.add(classpathTagClsList.item(j));
                }
                if (pathname.equals("") && attribMap.getNamedItem("kind").getNodeValue().equals("output")) {
                    allNodesToDelete.add(classpathTagClsList.item(j));
                    incorrectOutput = true;
                }
                if (DocumentNavigator.isContainedIn("com.sap.km.rfwizard", pathname)) {
                    allNodesToDelete.add(classpathTagClsList.item(j));
                    if (classpathTagClsList.item(j).getPreviousSibling().getNodeType() == 3 && classpathTagClsList.item(j).getPreviousSibling().getNodeValue().trim().length() == 0) {
                        allNodesToDelete.add(classpathTagClsList.item(j).getPreviousSibling());
                    }
                }
                ++j;
            }
            int k = 0;
            while (overwrite && k < allNodesToDelete.size()) {
                classpathTag.removeChild((Node)allNodesToDelete.get(k));
                ++k;
            }
            if (classpathTag.getLastChild().getNodeType() == 3 && classpathTag.getLastChild().getNodeValue().trim().length() == 0) {
                classpathTag.removeChild(classpathTag.getLastChild());
            }
            int l = 0;
            while (l < classpathTemplateClsList.getLength()) {
                if (!DocumentNavigator.firstIsChildOfSecond(classpathTemplateClsList.item(l), classpathTag) && (classpathTemplateClsList.item(l).getAttributes().getNamedItem("kind").getNodeValue().equals("output") && incorrectOutput || classpathTemplateClsList.item(l).getAttributes().getNamedItem("kind").getNodeValue().equals("src") && incorrectSource || classpathTemplateClsList.item(l).getAttributes().getNamedItem("kind").getNodeValue().equals("var"))) {
                    classpathTag.appendChild(fileDocument.createTextNode("\n  "));
                    classpathTag.appendChild(fileDocument.importNode(classpathTemplateClsList.item(l), true));
                }
                ++l;
            }
            classpathTag.appendChild(fileDocument.createTextNode("\n"));
            fileNav.getDocumentAsOutputStream().writeTo(new FileOutputStream(outputFile));
        }
        catch (Exception exception) {
            System.out.println("Caught exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static void deleteAll(File dir) {
        if (dir.isDirectory() && dir.list().length != 0) {
            String[] list = dir.list();
            int j = 0;
            while (j < list.length) {
                ServiceFilterGeneratorController.deleteAll(new File(dir.toString() + File.separator + list[j]));
                ++j;
            }
        }
        dir.delete();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

