/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards;

import com.sap.netweaver.bc.km.plugin.eprf.general.gui.swt.ILabelGroup;
import com.sap.netweaver.bc.km.plugin.eprf.general.gui.swt.LabeledOptionGroup;
import com.sap.netweaver.bc.km.plugin.eprf.general.gui.swt.LabelledOptionGroup;
import com.sap.netweaver.bc.km.plugin.eprf.general.kmWizards.ControllerAttributes;
import com.sap.netweaver.bc.km.plugin.eprf.general.kmWizards.IWizardAttributes;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.RepositoryManagerGeneratorModel;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.RepositoryManagerWizard;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.RepositoryManagerWizardSubPage;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.toolkit.FolderText;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.toolkit.ProjectManager;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RepositoryManagerWizardPage
extends WizardPage
implements IWizardAttributes {
    private ISelection selection;
    private RepositoryManagerGeneratorModel rmModel;
    private Text repManName;
    private Text repManPrefix;
    private Text repManPackageName;
    private FolderText fSourceFolderName;
    private Text fProjectName;
    private ILabelGroup fLabeledConfigOptions;
    private Button fSupportedOptions;
    private Button fGeneratingOptions;
    private Button cpButton;
    private ILabelGroup fLabeledClasspathOptions;
    private Combo configCombo;
    private String projectRootPath = "";
    private IProject project;
    private IProject m_project = null;
    RepositoryManagerWizardSubPage subWizardPage;
    private String selectedProjectName = "";
    private String generatedFolderName = "";
    private Combo projectCombo;
    private String[] projectNames;
    private ProjectManager pManager;

    public RepositoryManagerWizardPage(ISelection selection, RepositoryManagerGeneratorModel rmmodel, String pRootPath) {
        super("RM-KM-New-Page");
        this.setTitle("Repository Manager Wizard");
        this.setDescription("Generation of repository managers");
        this.selection = selection;
        this.setProjectRootPath(pRootPath);
        this.rmModel = rmmodel;
        this.rmModel.setProjectRootPath(pRootPath);
    }

    public RepositoryManagerWizardPage(ISelection selection, RepositoryManagerGeneratorModel sfgmodel, IProject project) {
        this(selection, sfgmodel, project.getLocation().toString());
        this.m_project = project;
    }

    public IProject getInitialProject() {
        return this.m_project;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        container.setLayout((Layout)layout);
        GridData gridData = new GridData();
        container.setLayoutData((Object)gridData);
        Composite buttonComposite = new Composite(container, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.verticalSpacing = 3;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData buttonGridData = new GridData();
        buttonComposite.setLayoutData((Object)buttonGridData);
        this.cpButton = new Button(buttonComposite, 32);
        this.cpButton.setText("Generate project classpath with BC libraries from plugin");
        this.cpButton.setSelection(true);
        this.fSupportedOptions = new Button(buttonComposite, 32);
        this.fSupportedOptions.setText("Enable selection of supported options");
        this.fSupportedOptions.setSelection(false);
        this.fSupportedOptions.setVisible(false);
        this.fSupportedOptions.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryManagerWizardPage.this.rmModel.setSupportedOptionFlag(RepositoryManagerWizardPage.this.fSupportedOptions.getSelection());
                RepositoryManagerWizardPage.this.dialogChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                RepositoryManagerWizardPage.this.dialogChanged();
            }
        });
        this.fGeneratingOptions = new Button(buttonComposite, 32);
        this.fGeneratingOptions.setText("Generate classes from scratch");
        this.fGeneratingOptions.setSelection(true);
        this.fGeneratingOptions.setVisible(false);
        Label configComboLabel = new Label(buttonComposite, 0);
        configComboLabel.setText("Config Framework Version: ");
        this.configCombo = new Combo(buttonComposite, 0);
        this.configCombo.setItems(ControllerAttributes.VERSION_DATA);
        this.configCombo.select(0);
        try {
            this.configCombo.setText(this.configCombo.getItem(0));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.configCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryManagerWizardPage.this.dialogChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                RepositoryManagerWizardPage.this.dialogChanged();
            }
        });
        this.configCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositoryManagerWizardPage.this.dialogChanged();
            }
        });
        this.repManName = this.createLabeledText("Repository Manager Name:", "", container);
        this.repManPackageName = this.createLabeledText("Repository Manager Package:", "", container);
        this.repManPrefix = this.createLabeledText("Repository Prefix:", "", container);
        if (this.getInitialProject() == null) {
            this.fSourceFolderName = this.createLabeledPath("Generation Directory" + (this.getProjectRootPath().equals("") ? " *:" : ":"), this.getProjectRootPath(), container);
            this.setGeneratedSourceFolderName(this.fSourceFolderName.getText());
            if (this.getProjectRootPath().equals("")) {
                this.pManager = new ProjectManager();
                this.projectNames = this.pManager.getProjectNames();
                Label comboLabel = new Label(container, 0);
                comboLabel.setText("* or select Eclipse project:");
                this.projectCombo = new Combo(container, 0);
                this.projectCombo.setItems(this.projectNames);
                try {
                    this.projectCombo.setText(this.projectCombo.getItem(0));
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                this.projectCombo.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        RepositoryManagerWizardPage.this.setSelectedProjectName(RepositoryManagerWizardPage.this.projectCombo.getItem(RepositoryManagerWizardPage.this.projectCombo.getSelectionIndex()));
                        System.out.println("Selected project: " + RepositoryManagerWizardPage.this.getSelectedProjectName());
                        RepositoryManagerWizardPage.this.fSourceFolderName.setTextEnabled(false);
                        RepositoryManagerWizardPage.this.setGeneratedSourceFolderName(RepositoryManagerWizardPage.this.getSelectedProjectLocation());
                        RepositoryManagerWizardPage.this.dialogChanged();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        RepositoryManagerWizardPage.this.dialogChanged();
                    }
                });
                this.projectCombo.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        RepositoryManagerWizardPage.this.dialogChanged();
                    }
                });
            }
            this.fSourceFolderName.getBrowseButton().addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!RepositoryManagerWizardPage.this.fSourceFolderName.getTextInstance().isEnabled()) {
                        RepositoryManagerWizardPage.this.fSourceFolderName.setTextEnabled(true);
                        System.out.println("Deselected project: " + RepositoryManagerWizardPage.this.getSelectedProjectName());
                        RepositoryManagerWizardPage.this.setSelectedProjectName("");
                        RepositoryManagerWizardPage.this.setGeneratedSourceFolderName(RepositoryManagerWizardPage.this.fSourceFolderName.getText());
                        RepositoryManagerWizardPage.this.projectCombo.deselectAll();
                        RepositoryManagerWizardPage.this.projectCombo.setText(RepositoryManagerWizardPage.this.projectCombo.getItem(0));
                    }
                    RepositoryManagerWizardPage.this.dialogChanged();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    RepositoryManagerWizardPage.this.dialogChanged();
                }
            });
            this.fSourceFolderName.getTextInstance().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RepositoryManagerWizardPage.this.setGeneratedSourceFolderName(RepositoryManagerWizardPage.this.fSourceFolderName.getText());
                    RepositoryManagerWizardPage.this.dialogChanged();
                }
            });
        } else {
            this.fSourceFolderName = this.createLabeledFolderText("Project:", this.getInitialProject().getName(), container);
            this.setGeneratedSourceFolderName(this.getInitialProject().getLocation().toString());
            this.fSourceFolderName.getTextInstance().setEditable(false);
        }
        this.dialogChanged();
        this.setControl((Control)container);
    }

    public boolean canFlipToNextPage() {
        this.rmModel.setSupportedOptionFlag(this.useSupportedOptions());
        this.rmModel.setClasspathGenerationOption(this.getClasspathGenerationOption());
        if (this.isPageComplete()) {
            ((RepositoryManagerWizardSubPage)this.getNextPage()).setModel(this.rmModel);
            return true;
        }
        return false;
    }

    private void dialogChanged() {
        if (this.repManName.getText().trim().length() == 0) {
            this.updateStatus("Repository manager name must be specified");
            return;
        }
        String name = this.repManName.getText();
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            this.updateStatus("Repository manager name must start with a java identifier start character");
            return;
        }
        int i = 1;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                this.updateStatus("Repository manager name must consist of java identifier characters");
                return;
            }
            ++i;
        }
        if (this.repManPackageName.getText().trim().length() == 0) {
            this.updateStatus("Repository manager package name must be specified");
            return;
        }
        String packageName = this.repManPackageName.getText();
        if (packageName.charAt(0) == '.' || packageName.charAt(packageName.length() - 1) == '.') {
            this.updateStatus("Repository manager package name must not start or end with a dot \".\"");
            return;
        }
        i = 1;
        while (i < packageName.length()) {
            if (!Character.isJavaIdentifierPart(packageName.charAt(i)) && packageName.charAt(i) != '.') {
                this.updateStatus("Repository manager package name must consist of java identifier characters and dots");
                return;
            }
            ++i;
        }
        if (this.repManPrefix.getText().trim().length() == 0) {
            this.updateStatus("Repository prefix must be specified");
            return;
        }
        String repositoryPrefix = this.repManPrefix.getText().toLowerCase();
        if (!Character.isLetter(repositoryPrefix.charAt(0)) || !Character.isLowerCase(repositoryPrefix.charAt(0))) {
            this.updateStatus("Repository prefix must start with a lower case letter");
            return;
        }
        i = 1;
        while (i < repositoryPrefix.length()) {
            if (!Character.isLetterOrDigit(repositoryPrefix.charAt(i)) || Character.isUpperCase(repositoryPrefix.charAt(i))) {
                this.updateStatus("Subsequent characters in repository prefix must be a lower case letter or a digit");
                return;
            }
            ++i;
        }
        if (this.getInitialProject() == null && this.fSourceFolderName != null && this.fSourceFolderName.getText().trim().length() == 0 && this.getSelectedProjectName().equals("")) {
            this.updateStatus("Manager files directory or project must be specified");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
        if (this.isPageComplete() && ((RepositoryManagerWizard)this.getWizard()).getSubPage() == null) {
            this.setSubPage(new RepositoryManagerWizardSubPage(this.selection, this.rmModel, "dummy", "RM-KM-SubPage"));
            this.getSubPage().setPreviousPage(this.getWizard().getPage(this.getName()));
            this.getSubPage().setModel(this.rmModel);
            ((RepositoryManagerWizard)this.getWizard()).addPage((IWizardPage)this.subWizardPage);
        }
    }

    private FolderText createLabeledPath(String title, String value, Composite defPanel, boolean enable) {
        Label label = new Label(defPanel, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(title);
        try {
            FolderText folderText = new FolderText(defPanel, 2052);
            folderText.setEnabled(enable);
            final Text fText = folderText.getTextInstance();
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            fText.setLayoutData((Object)gridData);
            fText.setText(value);
            if (value.equals("")) {
                fText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        RepositoryManagerWizardPage.this.dialogChanged();
                    }
                });
            }
            Button fButton = new Button(defPanel, 8);
            folderText.setBrowseButton(fButton);
            fButton.setVisible(enable);
            fButton.setText("Browse...");
            fButton.setLayoutData((Object)new GridData());
            fButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dlg = new DirectoryDialog(RepositoryManagerWizardPage.this.getControl().getShell(), 4096);
                    dlg.setFilterPath(fText.getText());
                    String res = dlg.open();
                    if (res != null) {
                        fText.setText(res);
                        RepositoryManagerWizardPage.this.dialogChanged();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            return folderText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Text createLabeledText(String title, String value, Composite defPanel) {
        Label label = new Label(defPanel, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(title);
        Text fText = new Text(defPanel, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        fText.setLayoutData((Object)gridData);
        fText.setText(value);
        fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositoryManagerWizardPage.this.dialogChanged();
            }
        });
        return fText;
    }

    private FolderText createLabeledFolderText(String title, String value, Composite defPanel) {
        Label label = new Label(defPanel, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(title);
        FolderText fText = new FolderText(defPanel, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        fText.getTextInstance().setLayoutData((Object)gridData);
        fText.setText(value);
        fText.getTextInstance().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositoryManagerWizardPage.this.dialogChanged();
            }
        });
        return fText;
    }

    private Combo createLabeledCombo(String title, String[] values, Composite defPanel) {
        Label label = new Label(defPanel, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(title);
        Combo fCombo = new Combo(defPanel, 2048);
        int i = 0;
        while (i < values.length) {
            fCombo.add(values[i]);
            ++i;
        }
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        fCombo.setLayoutData((Object)gridData);
        fCombo.select(0);
        fCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositoryManagerWizardPage.this.dialogChanged();
            }
        });
        return fCombo;
    }

    private ILabelGroup createRadioButtons(String boxtitle, String title, String[] values, Composite defPanel) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 3;
        defPanel.setLayout((Layout)layout);
        Label label = new Label(defPanel, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(title);
        HashSet<String> controls = new HashSet<String>();
        int i = 0;
        while (i < values.length) {
            controls.add(values[i]);
            ++i;
        }
        LabeledOptionGroup labeledOptionGroup = new LabeledOptionGroup(defPanel, "", 0, 16, controls);
        labeledOptionGroup.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent foc) {
                RepositoryManagerWizardPage.this.dialogChanged();
            }

            public void focusLost(FocusEvent foc) {
                RepositoryManagerWizardPage.this.dialogChanged();
            }
        });
        return labeledOptionGroup;
    }

    private ILabelGroup createRadioButtons(String boxtitle, String title, String[] values, Composite defPanel, String selectedName) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 3;
        defPanel.setLayout((Layout)layout);
        Label label = new Label(defPanel, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(title);
        HashSet<String> controls = new HashSet<String>();
        int i = 0;
        while (i < values.length) {
            controls.add(values[i]);
            ++i;
        }
        LabelledOptionGroup labelledOptionGroup = new LabelledOptionGroup(defPanel, boxtitle, 0, 16, controls, selectedName);
        return labelledOptionGroup;
    }

    private ILabelGroup createRadioButtonsInPanel(String boxtitle, String title, String[] values, Composite defPanel) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 3;
        defPanel.setLayout((Layout)layout);
        Label label = new Label(defPanel, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(title);
        HashSet<String> controls = new HashSet<String>();
        int i = 0;
        while (i < values.length) {
            controls.add(values[i]);
            ++i;
        }
        LabeledOptionGroup labeledOptionGroup = new LabeledOptionGroup(defPanel, boxtitle, 0, 16, controls);
        return labeledOptionGroup;
    }

    private FolderText createLabeledPath(String title, String value, Composite defPanel) {
        return this.createLabeledPath(title, value, defPanel, true);
    }

    public Text getNameField() {
        return this.repManName;
    }

    public Text getPackageNameField() {
        return this.repManPackageName;
    }

    public Text getRepositoryPrefixField() {
        return this.repManPrefix;
    }

    public String getConfigFrameworkVersion() {
        if (this.configCombo != null) {
            return this.configCombo.getItem(this.configCombo.getSelectionIndex());
        }
        return "";
    }

    public String getSelectedProjectName() {
        return this.selectedProjectName;
    }

    public void setSelectedProjectName(String pname) {
        this.selectedProjectName = pname;
    }

    public String getSelectedProjectLocation() {
        if (this.pManager.getProjectLocation(this.getSelectedProjectName()) != null) {
            return this.pManager.getProjectLocation(this.getSelectedProjectName()).toString();
        }
        return "";
    }

    public IProject getSelectedProject() {
        if (this.pManager != null && !this.getSelectedProjectName().equals("")) {
            return this.pManager.getProjectFromName(this.getSelectedProjectName());
        }
        return null;
    }

    public boolean useSupportedOptions() {
        return this.fSupportedOptions.getSelection();
    }

    public void setSubPage(RepositoryManagerWizardSubPage subPage) {
        this.subWizardPage = subPage;
    }

    public RepositoryManagerWizardSubPage getSubPage() {
        return this.subWizardPage;
    }

    public boolean getGenerationOption() {
        return this.fLabeledConfigOptions == null || this.fGeneratingOptions.getSelection();
    }

    public boolean getClasspathGenerationOption() {
        if (this.cpButton != null) {
            return this.cpButton.getSelection();
        }
        return true;
    }

    public String getSelectedOption(ILabelGroup log) {
        if (log != null) {
            HashSet selectedOptions = log.getSelection();
            Iterator it = selectedOptions.iterator();
            if (it.hasNext()) {
                return (String)it.next();
            }
        }
        return "";
    }

    public Text getConfigFolderNameField() {
        if (this.getInitialProject() != null) {
            this.fSourceFolderName.setText(this.getInitialProject().getLocation().toString());
        }
        return this.fSourceFolderName.getTextInstance();
    }

    public Text getSourceFolderNameField() {
        if (this.getInitialProject() != null) {
            this.fSourceFolderName.setText(this.getInitialProject().getLocation().toString());
        }
        return this.fSourceFolderName.getTextInstance();
    }

    private void setProjectRootPath(String pRootPath) {
        this.projectRootPath = pRootPath;
    }

    public String getProjectRootPath() {
        return this.projectRootPath;
    }

    public String getGeneratedSourceFolderName() {
        return this.generatedFolderName;
    }

    public void setGeneratedSourceFolderName(String fname) {
        this.generatedFolderName = fname;
    }
}

