/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards;

import com.sap.netweaver.bc.km.plugin.eprf.general.kmWizards.IWizardAttributes;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.RepositoryManagerGeneratorController;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.RepositoryManagerGeneratorModel;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.RepositoryManagerWizardPage;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.RepositoryManagerWizardSubPage;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmWizards.ICustomKMComponentWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class RepositoryManagerWizard
extends Wizard
implements ICustomKMComponentWizard,
IWizardAttributes,
IWizard {
    private RepositoryManagerWizardPage wizardPage;
    private RepositoryManagerWizardSubPage subWizardPage;
    private boolean worked = true;
    private IProject selectedProject;
    private String templateLocation;
    private ISelection selection;
    private String projectRootPath = "";
    private RepositoryManagerGeneratorModel rmModel;
    private boolean triggerRebuild = false;

    public RepositoryManagerWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("KMC Wizard");
    }

    public RepositoryManagerWizard(IProject selProject) {
        this();
        this.setSelectedProject(selProject);
    }

    public void setSelectedProject(IProject proj) {
        this.selectedProject = proj;
    }

    public IProject getSelectedProject() {
        return this.selectedProject;
    }

    public void addPages() {
        this.wizardPage = this.getProject() != null ? new RepositoryManagerWizardPage(this.selection, this.rmModel, this.getProject()) : new RepositoryManagerWizardPage(this.selection, this.rmModel, this.projectRootPath);
        if (this.wizardPage.getSubPage() == null) {
            this.setSubPage(new RepositoryManagerWizardSubPage(this.selection, this.rmModel, this.projectRootPath, "RM-KM-SubPage"));
        }
        this.addPage((IWizardPage)this.wizardPage);
        this.addPage((IWizardPage)this.getSubPage());
    }

    public void setSubPage(RepositoryManagerWizardSubPage sPage) {
        this.subWizardPage = sPage;
    }

    public RepositoryManagerWizardSubPage getSubPage() {
        return this.subWizardPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.rmModel = new RepositoryManagerGeneratorModel();
        StringTokenizer stoken = new StringTokenizer(System.getProperty("java.class.path"), ";");
        String testString = "";
        while (stoken.hasMoreElements()) {
            testString = stoken.nextToken().replace('\\', '/');
            if (!testString.endsWith("startup.jar")) continue;
            testString = testString.substring(0, testString.length() - "startup.jar".length() - 1);
            break;
        }
        this.rmModel.setEclipseRootPath(testString);
    }

    public boolean performFinish() {
        if (this.getSubPage() == null) {
            this.setSubPage((RepositoryManagerWizardSubPage)this.getPage("RM-KM-SubPage"));
        }
        this.rmModel.setRepositoryManagerName(this.wizardPage.getNameField().getText());
        this.rmModel.setRepositoryPrefix(this.wizardPage.getRepositoryPrefixField().getText());
        this.rmModel.setPackageName(this.wizardPage.getPackageNameField().getText());
        this.rmModel.setConfigFrameworkNew(this.wizardPage.getConfigFrameworkVersion().equals("New") || this.wizardPage.getConfigFrameworkVersion().equals(""));
        this.rmModel.setConfigFrameworkVersion(this.wizardPage.getConfigFrameworkVersion());
        if (this.wizardPage.getProjectRootPath().equals("") && !this.wizardPage.getSelectedProjectLocation().equals("")) {
            this.setCurrentProject(null);
        }
        this.rmModel.setConfigFolderName(this.wizardPage.getGeneratedSourceFolderName());
        this.rmModel.setSourceFolderName(this.wizardPage.getGeneratedSourceFolderName());
        this.rmModel.setSupportedOptionFlag(this.wizardPage.useSupportedOptions());
        this.rmModel.setGenerationOption(this.wizardPage.getGenerationOption());
        this.rmModel.setGenerationType(this.subWizardPage.getGenerationType());
        this.rmModel.setClasspathGenerationOption(this.wizardPage.getClasspathGenerationOption());
        Iterator iter = this.subWizardPage.getSubManagersMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String packageName = (String)entry.getKey();
            String[] subManagerInterfaces = ((List)entry.getValue()).getSelection();
            int i = 0;
            while (i < subManagerInterfaces.length) {
                this.rmModel.setSubManagerInterface(packageName, subManagerInterfaces[i], true);
                ++i;
            }
        }
        if (this.rmModel.useSupportedOptionFlag()) {
            Iterator iter2 = this.subWizardPage.getSupportedOptionsMap().entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry = iter2.next();
                String packageName = (String)entry.getKey();
                String[] subManagerOptions = ((List)entry.getValue()).getSelection();
                int i = 0;
                while (i < subManagerOptions.length) {
                    this.rmModel.setSubManagerOption(packageName, subManagerOptions[i], true);
                    ++i;
                }
            }
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    RepositoryManagerWizard.this.doFinish(RepositoryManagerWizard.this.rmModel, monitor);
                }
                catch (CoreException e) {
                    System.out.println("doFinish() terminated erroneously: ");
                    e.printStackTrace();
                    MessageDialog.openError((Shell)RepositoryManagerWizard.this.getShell(), (String)"Error: dofinish() terminated erroneously ", (String)e.getMessage());
                    throw new InvocationTargetException(e, "doFinish() terminated erroneously.");
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            System.out.println("getContainer() terminated erroneously: ");
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error: getContainer() terminated erroneously ", (String)e.getMessage());
            return false;
        }
        catch (InvocationTargetException e) {
            System.out.println("getContainer() terminated erroneously: ");
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error getContainer() terminated erroneously ", (String)e.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(RepositoryManagerGeneratorModel rmModel, IProgressMonitor monitor) throws CoreException {
        int taskTime = 7;
        monitor.beginTask("Generating repository managers ...", taskTime);
        monitor.worked(2);
        monitor.setTaskName("Prepare controller ...");
        RepositoryManagerGeneratorController rmController = new RepositoryManagerGeneratorController();
        monitor.worked(3);
        monitor.setTaskName("Create configuration and source files ...");
        if (this.getProject() == null) {
            this.setProject(this.wizardPage.getSelectedProject());
        }
        if (this.getProject() != null) {
            rmModel.setProjectName(this.getProject().getName());
        } else {
            rmModel.setProjectName("");
        }
        rmController.generate(rmModel);
        monitor.worked(2);
        if (this.getProject() != null) {
            this.getProject().build(6, monitor);
            this.getProject().refreshLocal(2, monitor);
        }
        monitor.done();
    }

    public void setCurrentProject(IProject project) {
        this.selectedProject = project != null ? project : this.wizardPage.getSelectedProject();
    }

    public IProject getProject() {
        return this.selectedProject;
    }

    public void setProject(IProject project) {
        this.selectedProject = project;
    }
}

