/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards;

import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.MonoServiceFilterWizardPage;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.RepositoryManagerBaseWizard;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.ServiceFilterGeneratorController;
import com.sap.netweaver.bc.km.plugin.eprf.ideSpecific.kmComponentWizards.ServiceFilterGeneratorModel;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class MonoServiceFilterWizard
extends RepositoryManagerBaseWizard {
    private MonoServiceFilterWizardPage wizardPage;
    private boolean worked = true;
    private IProject project;
    private String templateLocation;
    private ISelection selection;
    private String projectRootPath = "";
    private ServiceFilterGeneratorModel sfModel;
    private String serviceFilterVariant;
    private String wizardPageTitle;
    private String wizardPageDescription;

    public MonoServiceFilterWizard() {
        this.setForcePreviousAndNextButtons(false);
        this.setServiceFilterVariant("");
        this.setWindowTitle("KMC Wizard");
    }

    public MonoServiceFilterWizard(IProject selectedProject) {
        super(selectedProject);
        this.setForcePreviousAndNextButtons(false);
        this.setServiceFilterVariant("");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setForcePreviousAndNextButtons(false);
        this.setSelection((ISelection)selection);
        this.setModel(new ServiceFilterGeneratorModel());
        StringTokenizer stoken = new StringTokenizer(System.getProperty("java.class.path"), ";");
        String testString = "";
        while (stoken.hasMoreElements()) {
            testString = stoken.nextToken().replace('\\', '/');
            if (!testString.endsWith("startup.jar")) continue;
            testString = testString.substring(0, testString.length() - "startup.jar".length() - 1);
            break;
        }
        this.getModel().setEclipseRootPath(testString);
    }

    public boolean performFinish() {
        this.setForcePreviousAndNextButtons(false);
        List serviceFilterList = this.getModel().getServiceFilterVariantList(this.getWizardPage().getServiceFilterVariant());
        this.getModel().setConfigFrameworkVersion(this.getWizardPage().getConfigFrameworkVersion());
        this.getModel().setProjectName(this.getWizardPage().getSelectedProjectName());
        this.getModel().getSelectedServiceFilterDescription().clear();
        this.getModel().getServiceFilterVariantList(this.getWizardPage().getServiceFilterVariant());
        Iterator serviceFilterIter = serviceFilterList.iterator();
        while (serviceFilterIter.hasNext()) {
            String serviceFilterVariant = (String)serviceFilterIter.next();
            HashMap<String, String> descriptor = new HashMap<String, String>();
            descriptor.put("classname", ((Text)this.getWizardPage().getClassNameMap().get(serviceFilterVariant)).getText());
            descriptor.put("packagename", ((Text)this.getWizardPage().getPackageNameMap().get(serviceFilterVariant)).getText());
            descriptor.put("sfname", ((Text)this.getWizardPage().getServiceFilterNameMap().get(serviceFilterVariant)).getText());
            String folderOrProjectName = "";
            if (this.getWizardPage().getProjectRootPath().equals("") && !this.getWizardPage().getSelectedProjectLocation().equals("")) {
                this.setCurrentProject(null);
            }
            folderOrProjectName = this.getWizardPage().getGeneratedSourceFolderName();
            descriptor.put("foldername", folderOrProjectName);
            this.getModel().getSelectedServiceFilterDescription().put(serviceFilterVariant, descriptor);
        }
        if (this.getWizardPage().getServiceFilterVariant().equals("RepositoryFilter")) {
            this.getModel().setRepositoryFilterSubtype(this.getWizardPage().getRepositoryFilterSubtypeName());
        }
        this.getModel().setClasspathGenerationOption(this.getWizardPage().getClasspathGenerationOption());
        Iterator iter = this.getWizardPage().getServicesAndFiltersMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String packageName = (String)entry.getKey();
            String[] serviceFilterInterfaces = ((org.eclipse.swt.widgets.List)entry.getValue()).getSelection();
            int i = 0;
            while (i < serviceFilterInterfaces.length) {
                this.getModel().setServiceFilterInterface(packageName, serviceFilterInterfaces[i], true);
                ++i;
            }
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    MonoServiceFilterWizard.this.doFinish(MonoServiceFilterWizard.this.getModel(), monitor);
                }
                catch (CoreException e) {
                    System.out.println("doFinish() terminated erroneously: ");
                    e.printStackTrace();
                    MessageDialog.openError((Shell)MonoServiceFilterWizard.this.getShell(), (String)"Error: dofinish() terminated erroneously ", (String)e.getMessage());
                    throw new InvocationTargetException(e, "doFinish() terminated erroneously.");
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            System.out.println("getContainer() terminated erroneously: " + e.getMessage());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error: getContainer() terminated erroneously ", (String)e.getMessage());
            return false;
        }
        catch (InvocationTargetException e) {
            System.out.println("getContainer() terminated erroneously: ");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void doFinish(ServiceFilterGeneratorModel sflModel, IProgressMonitor monitor) throws CoreException {
        int taskTime = 0;
        taskTime = 7;
        int statusCode = 0;
        if (!sflModel.getSelectedServiceFilterDescription().isEmpty()) {
            monitor.beginTask("Generating services and filters ...", taskTime);
            monitor.worked(2);
            monitor.setTaskName("Prepare controller ...");
            ServiceFilterGeneratorController sfController = new ServiceFilterGeneratorController();
            monitor.worked(3);
            monitor.setTaskName("Create configuration and source files ...");
            if (this.getProject() == null) {
                this.setProject(this.wizardPage.getSelectedProject());
            }
            if (this.getProject() != null) {
                this.sfModel.setProjectName(this.getProject().getName());
            } else {
                this.sfModel.setProjectName("");
            }
            sfController.generate(this.sfModel);
            monitor.worked(2);
            if (this.getProject() != null) {
                try {
                    this.getProject().build(6, monitor);
                    this.getProject().refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    statusCode = e.getStatus().getCode();
                    monitor.setTaskName(e.getStatus().getMessage());
                    e.printStackTrace();
                    throw e;
                }
            }
            if (statusCode != 4) {
                monitor.done();
            }
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setCurrentProject(IProject project) {
        this.project = project != null ? project : this.getWizardPage().getSelectedProject();
    }

    public String getServiceFilterVariant() {
        return this.serviceFilterVariant;
    }

    public void setServiceFilterVariant(String string) {
        this.serviceFilterVariant = string;
    }

    public MonoServiceFilterWizardPage getWizardPage() {
        return this.wizardPage;
    }

    public void setWizardPage(MonoServiceFilterWizardPage page) {
        this.wizardPage = page;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public ServiceFilterGeneratorModel getModel() {
        return this.sfModel;
    }

    public void setModel(ServiceFilterGeneratorModel model) {
        this.sfModel = model;
    }

    public String getProjectRootPath() {
        return this.projectRootPath;
    }

    public void setProjectRootPath(String string) {
        this.projectRootPath = string;
    }

    public void setPageTitleAndDescription(String title, String desc) {
        this.wizardPageTitle = title;
        this.wizardPageDescription = desc;
    }

    public void setTitleAndDescriptionForPage(WizardPage wPage) {
        wPage.setTitle(this.wizardPageTitle);
        wPage.setDescription(this.wizardPageDescription);
    }
}

