/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editorsupport.win32;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class OleEditor
extends EditorPart {
    private IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta mainDelta = event.getDelta();
            if (mainDelta == null) {
                return;
            }
            IResourceDelta affectedElement = mainDelta.findMember(OleEditor.this.resource.getFullPath());
            if (affectedElement != null) {
                try {
                    this.processDelta(affectedElement);
                }
                catch (CoreException coreException) {
                    OleEditor.this.getSite().getPage().closeEditor((IEditorPart)OleEditor.this, true);
                }
            }
        }

        private boolean processDelta(IResourceDelta delta) throws CoreException {
            Runnable changeRunnable = null;
            switch (delta.getKind()) {
                case 2: {
                    changeRunnable = (0x2000 & delta.getFlags()) != 0 ? new Runnable(this, delta){
                        private final /* synthetic */ IResourceDelta val$delta;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$delta = iResourceDelta;
                        }

                        public void run() {
                            IPath path = this.val$delta.getMovedToPath();
                            IFile newFile = this.val$delta.getResource().getWorkspace().getRoot().getFile(path);
                            if (newFile != null) {
                                OleEditor.access$1(1.access$0(this.this$1), newFile);
                            }
                        }
                    } : new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            1.access$0(this.this$1).sourceDeleted = true;
                            1.access$0(this.this$1).getSite().getPage().closeEditor((IEditorPart)1.access$0(this.this$1), true);
                        }
                    };
                }
            }
            if (changeRunnable != null) {
                OleEditor.this.update(changeRunnable);
            }
            return true;
        }

        static /* synthetic */ OleEditor access$0(1 var0) {
            return var0.OleEditor.this;
        }
    };
    private OleFrame clientFrame;
    private OleClientSite clientSite;
    private File source;
    private IFile resource;
    private Image oleTitleImage;
    boolean sourceDeleted = false;
    boolean sourceChanged = false;
    private boolean clientActive = false;
    private boolean oleActivated = false;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            OleEditor.this.activateClient(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            OleEditor.this.deactivateClient(part);
        }
    };
    private static final String RENAME_ERROR_TITLE = WorkbenchMessages.getString((String)"OleEditor.errorSaving");
    private static final String OLE_EXCEPTION_TITLE = WorkbenchMessages.getString((String)"OleEditor.oleExceptionTitle");
    private static final String OLE_EXCEPTION_MESSAGE = WorkbenchMessages.getString((String)"OleEditor.oleExceptionMessage");
    private static final String SAVE_ERROR_TITLE = WorkbenchMessages.getString((String)"OleEditor.savingTitle");
    private static final String SAVE_ERROR_MESSAGE = WorkbenchMessages.getString((String)"OleEditor.savingMessage");

    private void activateClient(IWorkbenchPart part) {
        if (part == this) {
            this.oleActivate();
            this.clientActive = true;
        }
    }

    public void createPartControl(Composite parent) {
        this.clientFrame = new OleFrame(parent, 4096);
        this.clientFrame.setBackground(JFaceColors.getBannerBackground((Display)this.clientFrame.getDisplay()));
        this.initializeWorkbenchMenus();
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            this.setResource(((IFileEditorInput)input).getFile());
            this.resource.getWorkspace().addResourceChangeListener(this.resourceListener);
        }
        this.createClientSite();
    }

    private void createClientSite() {
        if (this.clientFrame == null || this.clientFrame.isDisposed()) {
            return;
        }
        this.clientSite = new OleClientSite((Composite)this.clientFrame, 0, this.source);
        this.clientSite.setBackground(JFaceColors.getBannerBackground((Display)this.clientFrame.getDisplay()));
    }

    private void deactivateClient(IWorkbenchPart part) {
        if (part == this && this.clientActive) {
            if (this.clientSite != null) {
                this.clientSite.deactivateInPlaceClient();
            }
            this.clientActive = false;
            this.oleActivated = false;
        }
    }

    private void displayErrorDialog(String title, String message) {
        Shell parent = null;
        if (this.getClientSite() != null) {
            parent = this.getClientSite().getShell();
        }
        MessageDialog.openError((Shell)parent, (String)title, (String)message);
    }

    public void dispose() {
        if (this.resource != null) {
            this.resource.getWorkspace().removeResourceChangeListener(this.resourceListener);
        }
        if (this.oleTitleImage != null) {
            this.oleTitleImage.dispose();
            this.oleTitleImage = null;
        }
        if (this.getSite() != null && this.getSite().getPage() != null) {
            this.getSite().getPage().removePartListener(this.partListener);
        }
    }

    public void doPrint() {
        if (this.clientSite == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.clientSite.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                OleEditor.this.clientSite.exec(6, 1, null, null);
            }
        });
    }

    public void doSave(final IProgressMonitor monitor) {
        if (this.clientSite == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.clientSite.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                int result;
                if (!OleEditor.this.sourceChanged && ((result = OleEditor.this.clientSite.queryStatus(3)) & 2) != 0) {
                    result = OleEditor.this.clientSite.exec(3, 1, null, null);
                    if (result == 0) {
                        try {
                            OleEditor.this.resource.refreshLocal(0, monitor);
                        }
                        catch (CoreException coreException) {}
                        return;
                    }
                    OleEditor.this.displayErrorDialog(OLE_EXCEPTION_TITLE, String.valueOf(OLE_EXCEPTION_MESSAGE) + String.valueOf(result));
                    return;
                }
                if (OleEditor.this.saveFile(OleEditor.this.source)) {
                    try {
                        OleEditor.this.resource.refreshLocal(0, monitor);
                    }
                    catch (CoreException coreException) {}
                } else {
                    OleEditor.this.displayErrorDialog(SAVE_ERROR_TITLE, String.valueOf(SAVE_ERROR_MESSAGE) + OleEditor.this.source.getName());
                }
            }
        });
    }

    public void doSaveAs() {
        if (this.clientSite == null) {
            return;
        }
        WorkspaceModifyOperation op = this.saveNewFileOperation();
        Shell shell = this.clientSite.getShell();
        try {
            new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationException) {
            MessageDialog.openError((Shell)shell, (String)RENAME_ERROR_TITLE, (String)invocationException.getTargetException().getMessage());
        }
    }

    public OleClientSite getClientSite() {
        return this.clientSite;
    }

    public File getSourceFile() {
        return this.source;
    }

    public void gotoMarker(IMarker marker) {
    }

    private void handleWord() {
        Variant pVarResult;
        OleAutomation dispInterface = new OleAutomation(this.clientSite);
        int[] appId = dispInterface.getIDsOfNames(new String[]{"Application"});
        if (appId != null && (pVarResult = dispInterface.getProperty(appId[0])) != null) {
            OleAutomation application = pVarResult.getAutomation();
            int[] dispid = application.getIDsOfNames(new String[]{"DisplayScrollBars"});
            if (dispid != null) {
                Variant rgvarg = new Variant(true);
                application.setProperty(dispid[0], rgvarg);
            }
            application.dispose();
        }
        dispInterface.dispose();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException(WorkbenchMessages.format((String)"OleEditor.invalidInput", (Object[])new Object[]{input}));
        }
        IFile file = ((IFileEditorInput)input).getFile();
        if (file.getLocation() == null || !new File(file.getLocation().toOSString()).exists()) {
            throw new PartInitException(WorkbenchMessages.format((String)"OleEditor.noFileInput", (Object[])new Object[]{file.getLocation()}));
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setTitle(input.getName());
        this.setTitleToolTip(input.getToolTipText());
        ImageDescriptor desc = input.getImageDescriptor();
        if (desc != null) {
            this.oleTitleImage = desc.createImage();
            this.setTitleImage(this.oleTitleImage);
        }
        site.getPage().addPartListener(this.partListener);
    }

    protected void initializeWorkbenchMenus() {
        if (this.clientFrame == null || this.clientFrame.isDisposed()) {
            return;
        }
        Shell shell = this.clientFrame.getShell();
        Menu menuBar = shell.getMenuBar();
        if (menuBar == null) {
            menuBar = new Menu((Decorations)shell, 2);
            shell.setMenuBar(menuBar);
        }
        MenuItem[] windowMenu = new MenuItem[1];
        MenuItem[] fileMenu = new MenuItem[1];
        Vector<MenuItem> containerItems = new Vector<MenuItem>();
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        int i = 0;
        while (i < menuBar.getItemCount()) {
            MenuItem item = menuBar.getItem(i);
            String id = "";
            if (item.getData() instanceof IMenuManager) {
                id = ((IMenuManager)item.getData()).getId();
            }
            if (id.equals("file")) {
                fileMenu[0] = item;
            } else if (id.equals("window")) {
                windowMenu[0] = item;
            } else if (window.isApplicationMenu(id)) {
                containerItems.addElement(item);
            }
            ++i;
        }
        Object[] containerMenu = new MenuItem[containerItems.size()];
        containerItems.copyInto(containerMenu);
        this.clientFrame.setFileMenus(fileMenu);
        this.clientFrame.setContainerMenus((MenuItem[])containerMenu);
        this.clientFrame.setWindowMenus(windowMenu);
    }

    public boolean isDirty() {
        return this.clientSite != null;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveNeeded() {
        return this.getClientSite() != null && this.isDirty();
    }

    private boolean saveFile(File file) {
        File tempFile = new File(String.valueOf(file.getAbsolutePath()) + ".tmp");
        file.renameTo(tempFile);
        boolean saved = false;
        saved = OLE.isOleFile((File)file) || OleEditor.usesStorageFiles(this.clientSite.getProgramID()) ? this.clientSite.save(file, true) : this.clientSite.save(file, false);
        if (saved) {
            tempFile.delete();
            return true;
        }
        tempFile.renameTo(file);
        return false;
    }

    private WorkspaceModifyOperation saveNewFileOperation() {
        return new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                SaveAsDialog dialog = new SaveAsDialog(OleEditor.this.clientFrame.getShell());
                IFileEditorInput input = (IFileEditorInput)OleEditor.this.getEditorInput();
                IFile sFile = input.getFile();
                dialog.setOriginalFile(sFile);
                dialog.open();
                IPath newPath = dialog.getResult();
                if (newPath == null) {
                    return;
                }
                if (dialog.getReturnCode() == 0) {
                    String projectName = newPath.segment(0);
                    newPath = newPath.removeFirstSegments(1);
                    IProject project = OleEditor.this.resource.getWorkspace().getRoot().getProject(projectName);
                    newPath = project.getLocation().append(newPath);
                    File newFile = newPath.toFile();
                    if (OleEditor.this.saveFile(newFile)) {
                        IFile newResource = OleEditor.this.resource.getWorkspace().getRoot().getFileForLocation(newPath);
                        if (newResource != null) {
                            OleEditor.this.sourceChanged(newResource);
                            newResource.refreshLocal(0, monitor);
                        }
                    } else {
                        OleEditor.this.displayErrorDialog(SAVE_ERROR_TITLE, String.valueOf(SAVE_ERROR_MESSAGE) + newFile.getName());
                        return;
                    }
                }
            }
        };
    }

    public void setFocus() {
    }

    private void oleActivate() {
        if (this.clientSite == null || this.clientFrame == null || this.clientFrame.isDisposed()) {
            return;
        }
        if (!this.oleActivated) {
            this.clientSite.doVerb(-1);
            this.oleActivated = true;
            String progId = this.clientSite.getProgramID();
            if (progId != null && progId.startsWith("Word.Document")) {
                this.handleWord();
            }
        }
    }

    protected void setResource(IFile file) {
        this.resource = file;
        this.source = new File(file.getLocation().toOSString());
    }

    private static boolean usesStorageFiles(String progID) {
        return progID != null && (progID.startsWith("Word.", 0) || progID.startsWith("MSGraph", 0) || progID.startsWith("PowerPoint", 0) || progID.startsWith("Excel", 0));
    }

    private void sourceChanged(IFile newFile) {
        FileEditorInput newInput = new FileEditorInput(newFile);
        this.setInput((IEditorInput)newInput);
        this.setResource(newFile);
        this.sourceChanged = true;
        this.setTitle(newInput.getName());
    }

    public boolean isSaveOnCloseNeeded() {
        return !this.sourceDeleted && super.isSaveOnCloseNeeded();
    }

    private void update(Runnable runnable) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows != null && windows.length > 0) {
            Display display = windows[0].getShell().getDisplay();
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }
}

