/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.svc.notifyqueue;

import com.sap.caf.km.ejb.data.util.ProxyHelper;
import com.sap.caf.km.ejb.svc.notifyqueue.IResourceKeys;
import com.sap.caf.km.ejb.svc.notifyqueue.NotifyQueueException;
import com.sap.caf.km.proxies.svc.kmnotif.KMNotificationSvc;
import com.sap.caf.km.proxies.svc.kmnotif.KMNotificationSvcService;
import com.sap.caf.km.proxies.svc.kmnotif.types.KMRecipient;
import com.sap.caf.km.proxies.svc.kmnotif.types.KMTemplate;
import com.sap.caf.km.proxies.svc.kmnotif.types.KMTemplateParam;
import com.sap.caf.rt.services.notify.notif.send.NotifMessage;
import com.sap.caf.rt.services.notify.notif.send.NotifRecipient;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.rpc.ServiceException;

public class NotifyQueueBean
implements MessageDrivenBean,
MessageListener,
IResourceKeys {
    private static final String PROP_PROXY_ENDPOINT = "javax.xml.rpc.service.endpoint.address";
    private transient KMNotificationSvc m_proxy;
    private static final String JARM_REQUEST = "CAF:RT:oal:notifyqueue";
    private transient MessageDrivenContext m_msgContext;
    static /* synthetic */ Class class$com$sap$caf$km$proxies$svc$kmnotif$KMNotificationSvc;

    public void ejbCreate() {
    }

    public void ejbRemove() throws EJBException {
    }

    public void setMessageDrivenContext(MessageDrivenContext context) throws EJBException {
        this.m_msgContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message jmsMsg) {
        String method = "onMessage(Message msg)";
        this.enter("onMessage(Message msg)");
        try {
            NotifMessage notifMsg = (NotifMessage)((ObjectMessage)jmsMsg).getObject();
            KMNotificationSvc service = this.getNotifSvc();
            Calendar createdAt = Calendar.getInstance();
            createdAt.setTime(notifMsg.getCreatedAt());
            KMTemplate template = new KMTemplate();
            template.setId(notifMsg.getTemplateId());
            template.setParams(this.convertParams(notifMsg.getParameters()));
            template.setSubject(notifMsg.getSubject());
            service.notify(notifMsg.getOriginator(), this.convertRecipients(notifMsg.getRecipients()), template, createdAt);
        }
        catch (Throwable e) {
            NotifyQueueException ntfyEx = new NotifyQueueException("CANT_PROCESS_MSG", e);
            this.log(ntfyEx, "onMessage(Message msg)");
        }
        finally {
            this.exit("onMessage(Message msg)");
        }
    }

    private KMRecipient[] convertRecipients(Collection notifRecipients) {
        int size = notifRecipients.size();
        ArrayList<KMRecipient> recips = new ArrayList<KMRecipient>(size);
        Iterator itr = notifRecipients.iterator();
        while (itr.hasNext()) {
            NotifRecipient notifRecip = (NotifRecipient)itr.next();
            KMRecipient kmRecip = new KMRecipient();
            kmRecip.setUserId(notifRecip.getUserId());
            kmRecip.setActionInboxEnabled(notifRecip.isActionInboxEnabled());
            recips.add(kmRecip);
        }
        return recips.toArray(new KMRecipient[size]);
    }

    private Collection resolveUniqUserIds(Collection userIds) throws UMException {
        IUserFactory userFactory = UMFactory.getUserFactory();
        ArrayList<String> uniqIds = new ArrayList<String>(userIds.size());
        Iterator itr = userIds.iterator();
        while (itr.hasNext()) {
            IUser user;
            String userId = (String)itr.next();
            try {
                user = userFactory.getUser(userId);
            }
            catch (UMException e) {
                user = userFactory.getUserByLogonID(userId);
            }
            uniqIds.add(user.getUniqueName());
        }
        return uniqIds;
    }

    private KMTemplateParam[] convertParams(Map params) {
        ArrayList<KMTemplateParam> templParams = new ArrayList<KMTemplateParam>(params.size());
        if (params != null && !params.isEmpty()) {
            int i = 0;
            Iterator itr = params.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key instanceof String && value instanceof String) {
                    KMTemplateParam templParam = new KMTemplateParam();
                    templParam.setName((String)key);
                    templParam.setValue((String)value);
                    templParams.add(templParam);
                }
                ++i;
            }
        }
        return templParams.toArray(new KMTemplateParam[templParams.size()]);
    }

    private String[] convertUserIds(Collection userIds) {
        return userIds.toArray(new String[userIds.size()]);
    }

    private synchronized KMNotificationSvc getNotifSvc() throws NamingException, ServiceException {
        if (this.m_proxy == null) {
            InitialContext context = new InitialContext();
            KMNotificationSvcService service = (KMNotificationSvcService)context.lookup("wsclients/proxies/sap.com/caf~km.proxies/KMNotificationSvc");
            KMNotificationSvc proxy = (KMNotificationSvc)service.getLogicalPort(class$com$sap$caf$km$proxies$svc$kmnotif$KMNotificationSvc == null ? (class$com$sap$caf$km$proxies$svc$kmnotif$KMNotificationSvc = NotifyQueueBean.class$("com.sap.caf.km.proxies.svc.kmnotif.KMNotificationSvc")) : class$com$sap$caf$km$proxies$svc$kmnotif$KMNotificationSvc);
            String url = ProxyHelper.getActualUrl((String)proxy._getProperty(PROP_PROXY_ENDPOINT));
            proxy._setProperty(PROP_PROXY_ENDPOINT, (Object)url);
            this.m_proxy = proxy;
        }
        return this.m_proxy;
    }

    private void exit(String method) {
        CAFPublicLogger.exiting(null, (String)JARM_REQUEST, (String)method, (Location)CAFPublicLogger.LOC_CAF);
    }

    private void enter(String method) {
        CAFPublicLogger.entering(null, (String)JARM_REQUEST, (String)method, (Location)CAFPublicLogger.LOC_CAF);
    }

    private void log(NotifyQueueException e, String method) {
        CAFPublicLogger.logThrowable((int)500, (Category)CAFPublicLogger.categoryCAF, (String)method, (Throwable)((Object)e));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

