/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.svc.idxsearch.util;

import com.sap.caf.km.ejb.svc.idxsearch.common.IIndex;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigException;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigProps;
import com.sap.caf.km.ejb.svc.idxsearch.util.IConfigProps;
import com.sap.caf.km.ejb.svc.idxsearch.util.IIndexCache;

public class IndexCache
implements IIndexCache,
IConfigProps {
    protected static IndexCache m_cache;
    protected ConfigProps m_props;
    protected static long m_expireInterval;
    protected static long m_expireDate;
    protected static boolean m_isValid;
    protected static IIndex[] m_indexes;

    protected IndexCache(ConfigProps props) throws ConfigException {
        try {
            this.m_props = props;
            m_expireInterval = Integer.parseInt(this.m_props.getNotNullProperty("IDX_CACHE_LIFETIME")) * 60000;
            this.invalidate();
        }
        catch (Throwable e) {
            m_expireInterval = 1800000L;
        }
    }

    public static synchronized IndexCache getInstance() throws ConfigException {
        if (m_cache == null) {
            m_cache = new IndexCache(ConfigProps.getInstance());
        }
        return m_cache;
    }

    public boolean isValid() {
        return m_isValid && System.currentTimeMillis() < m_expireDate;
    }

    public void invalidate() {
        m_isValid = false;
    }

    public void setIndexes(IIndex[] indexes) {
        m_indexes = indexes;
        this.refresh();
    }

    public IIndex[] getIndexes() {
        return this.isValid() ? m_indexes : new IIndex[]{};
    }

    protected void refresh() {
        m_expireDate = System.currentTimeMillis() + m_expireInterval;
        m_isValid = true;
    }
}

