/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.svc.idxsearch.util;

import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigException;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigProps;
import com.sap.caf.km.ejb.svc.idxsearch.util.IConfigProps;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class ConnectionManager
implements IConfigProps {
    protected static ConnectionManager s_manager;
    protected ConfigProps m_props;
    protected DataSource m_ds;

    protected ConnectionManager(ConfigProps props) {
        this.m_props = props;
    }

    public static synchronized ConnectionManager getInstance() throws ConfigException {
        if (s_manager == null) {
            s_manager = new ConnectionManager(ConfigProps.getInstance());
        }
        return s_manager;
    }

    protected synchronized DataSource getDataSource() throws SQLException {
        if (this.m_ds == null) {
            try {
                this.m_ds = (DataSource)this.m_props.getNotNullObject("java:comp/env/SAP/CAF_RT");
            }
            catch (ConfigException e) {
                throw new SQLException("Could not get Data Source, cause:[" + e.getMessage() + "]");
            }
        }
        return this.m_ds;
    }

    public Connection getConnection() throws SQLException {
        DataSource ds = this.getDataSource();
        Connection conn = ds.getConnection();
        return conn;
    }

    public Connection getAutoCommitedConnection() throws SQLException {
        DataSource ds = this.getDataSource();
        return ds.getConnection();
    }
}

