/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.svc.idxsearch.util;

import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigException;
import com.sap.caf.km.ejb.svc.idxsearch.util.IConfigProps;
import com.sap.caf.rt.bol.context.CAFProperties;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;

public class ConfigProps
implements IConfigProps {
    protected static ConfigProps s_config;
    protected Context m_context;
    protected Properties m_props;

    protected ConfigProps(Context context, Properties props) {
        this.m_props = props;
        this.m_context = context;
    }

    public static synchronized ConfigProps getInstance() throws ConfigException {
        if (s_config == null) {
            try {
                InitialContext context = new InitialContext();
                CAFProperties cafProps = new CAFProperties();
                cafProps.loadApplicationProperties();
                Properties localProps = new Properties((Properties)cafProps);
                ConfigProps.loadDefaults(localProps);
                s_config = new ConfigProps(context, localProps);
            }
            catch (Exception e) {
                throw new ConfigException("Could not create ConfigProps instance:[" + e.getMessage() + "]");
            }
        }
        return s_config;
    }

    public String getNotNullProperty(String name) throws ConfigException {
        try {
            String value = this.m_props.getProperty(name);
            if (value == null) {
                throw new ConfigException("Property:[" + name + "] is undefined!");
            }
            return value;
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ConfigException("Could not get property:[" + name + "], cause:[" + e.getMessage() + "]");
        }
    }

    public Object getNotNullObject(String name) throws ConfigException {
        try {
            Object value = this.m_context.lookup(name);
            if (value == null) {
                throw new ConfigException("Property:[" + name + "] is undefined!");
            }
            return value;
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ConfigException("Could not get property:[" + name + "], cause:[" + e.getMessage() + "]");
        }
    }

    protected static void loadDefaults(Properties props) {
        props.setProperty("CLASS.IKMIndexSearchIndexSvc", "com.sap.caf.km.ejb.svc.idxsearch.index.KMIndexSearchIndexSvc");
        props.setProperty("CLASS.IKMIndexSearchClassifySvc", "com.sap.caf.km.ejb.svc.idxsearch.classify.KMIndexSearchClassifySvc");
        props.setProperty("CLASS.IKMIndexSearchSearchSvc", "com.sap.caf.km.ejb.svc.idxsearch.search.KMIndexSearchSearchSvc");
        props.setProperty("JNDI_NAME.KMIndexSearchSvc", "wsclients/proxies/sap.com/caf~km.proxies/KMIndexSearchJNDI");
    }
}

