/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.svc.idxsearch.search;

import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchResourceKeys;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchSearchSvc;
import com.sap.caf.km.ejb.svc.idxsearch.common.ISearchEntry;
import com.sap.caf.km.ejb.svc.idxsearch.common.ISearchResult;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexSearchException;
import com.sap.caf.km.ejb.svc.idxsearch.common.SearchException;
import com.sap.caf.km.ejb.svc.idxsearch.kmproxy.KMIndexSearchSvcProxy;
import com.sap.caf.km.ejb.svc.idxsearch.search.KMSearchResultLocal;
import com.sap.caf.km.proxies.svc.idxsearch.types.IKMSearchEntry;
import com.sap.caf.km.proxies.svc.idxsearch.types.IKMSearchResult;
import java.util.ArrayList;
import java.util.Calendar;

public class KMIndexSearchSearchSvc
extends KMIndexSearchSvcProxy
implements IIndexSearchSearchSvc,
IIndexSearchResourceKeys {
    public ISearchResult[] searchForGlobalResource(ISearchEntry[] queryEntryArray, String[] indexIdArray, int maxResults) throws SearchException {
        try {
            return this.prepareResults(this.m_port.searchForGlobalResource(this.prepareEntries(queryEntryArray), indexIdArray, maxResults));
        }
        catch (Exception e) {
            throw new SearchException("ERR_SEARCH_GLOBAL", (Throwable)e);
        }
    }

    public ISearchResult[] searchForGlobalResource(ISearchEntry[] queryEntryArray, String[] indexIdArray, String searchStartFolder, int maxResults) throws SearchException {
        try {
            return this.prepareResults(this.m_port.searchForGlobalResource(this.prepareEntries(queryEntryArray), indexIdArray, searchStartFolder, maxResults));
        }
        catch (Exception e) {
            throw new SearchException("ERR_SEARCH_GLOBAL", (Throwable)e);
        }
    }

    public ISearchResult[] searchForBO(ISearchEntry[] queryEntryArray, String[] indexIdArray, int maxResults) throws SearchException {
        try {
            return this.prepareResults(this.m_port.searchForBO(this.prepareEntries(queryEntryArray), indexIdArray, maxResults));
        }
        catch (Exception e) {
            throw new SearchException("ERR_SEARCH_ALL_BO", (Throwable)e);
        }
    }

    public ISearchResult[] searchForSimilar(String resourceRid, String[] indexIdArray, int maxResults) throws SearchException {
        try {
            return this.prepareResults(this.m_port.searchForSimilar(resourceRid, indexIdArray, maxResults));
        }
        catch (Exception e) {
            throw new SearchException("ERR_SEARCH_SIMILAR", (Throwable)e);
        }
    }

    public ISearchResult[] searchForRelatedResource(ISearchEntry[] queryEntryArray, String[] indexIdArray, int resultType, int maxResults) throws SearchException {
        try {
            return this.prepareResults(this.m_port.searchForRelatedResource(this.prepareEntries(queryEntryArray), indexIdArray, resultType, maxResults));
        }
        catch (Exception e) {
            throw new SearchException("ERR_SEARCH_RELATED", (Throwable)e);
        }
    }

    public ISearchResult[] searchForBOInRelatedIndex(ISearchEntry[] queryEntryArray, String[] indexIdArray, int maxResults) throws SearchException {
        try {
            return this.prepareResults(this.m_port.searchForBOInRelatedIndex(this.prepareEntries(queryEntryArray), indexIdArray, maxResults));
        }
        catch (Exception e) {
            throw new SearchException("ERR_SEARCH_RELATED_BO", (Throwable)e);
        }
    }

    protected ISearchResult[] prepareResults(IKMSearchResult[] source) {
        ArrayList<KMSearchResultLocal> results = new ArrayList<KMSearchResultLocal>();
        for (int i = 0; i < source.length; ++i) {
            results.add(new KMSearchResultLocal(source[i]));
        }
        return results.toArray(new ISearchResult[results.size()]);
    }

    protected IKMSearchEntry[] prepareEntries(ISearchEntry[] source) {
        ArrayList<IKMSearchEntry> results = new ArrayList<IKMSearchEntry>();
        for (int i = 0; i < source.length; ++i) {
            Calendar calendar = Calendar.getInstance();
            IKMSearchEntry entry = new IKMSearchEntry();
            entry.setTaxonomySearch(source[i].isTaxonomySearch());
            if (source[i].getValueAsString() != null) {
                entry.setValueAsString(source[i].getValueAsString());
            }
            entry.setValueAsInt(source[i].getValueAsInt());
            entry.setRangeValue1StAsInt(source[i].getRangeValue1stAsInt());
            entry.setRangeValue2NdAsInt(source[i].getRangeValue2ndAsInt());
            if (source[i].getValueAsDate() != null) {
                calendar.setTime(source[i].getValueAsDate());
                entry.setValueAsDate(calendar);
            }
            if (source[i].getRangeValue1stAsDate() != null) {
                calendar.setTime(source[i].getRangeValue1stAsDate());
                entry.setRangeValue1StAsDate(calendar);
            }
            if (source[i].getRangeValue2ndAsDate() != null) {
                calendar.setTime(source[i].getRangeValue2ndAsDate());
                entry.setRangeValue2NdAsDate(calendar);
            }
            if (source[i].getRowType() != null) {
                entry.setRowType(source[i].getRowType());
            }
            entry.setTermWeight(source[i].getTermWeight());
            entry.setTermAction(source[i].getTermAction());
            entry.setPropertyType(source[i].getPropertyType());
            if (source[i].getPropertyName() != null) {
                entry.setPropertyNamespace(source[i].getPropertyNamespace());
                entry.setPropertyName(source[i].getPropertyName());
                entry.setPropertyOperator(source[i].getPropertyOperator());
            }
            entry.setFuzziness(source[i].getFuzziness());
            entry.setValueType(source[i].getValueType());
            results.add(entry);
        }
        return results.toArray(new IKMSearchEntry[results.size()]);
    }
}

