/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.svc.idxsearch.index;

import com.sap.caf.km.ejb.svc.idxsearch.bo.BOAccessException;
import com.sap.caf.km.ejb.svc.idxsearch.bo.BOAccessor;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigException;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigProps;
import com.sap.caf.km.ejb.svc.idxsearch.util.IConfigProps;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;

public final class KMIndexUtil
implements IConfigProps {
    private static Properties s_props;
    protected static Map m_indexes;
    protected static Map m_globalIndexes;
    protected static Map m_folders;
    private static int IDX_TYPE_PROPER;
    private static int IDX_TYPE_RELATED;
    public static final char[] FORBIDDEN_CHARS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIndexId(String BOName) throws ConfigException, RemoteException, NamingException {
        Map map = m_indexes;
        synchronized (map) {
            String sId = (String)m_indexes.get(BOName);
            if (sId == null) {
                sId = KMIndexUtil.generateIndexId(BOName, IDX_TYPE_PROPER);
                m_indexes.put(BOName, sId);
            }
            return sId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRelatedIndexId(String BOName) throws RemoteException, ConfigException, NamingException {
        Map map = m_globalIndexes;
        synchronized (map) {
            String sId = (String)m_globalIndexes.get(BOName);
            if (sId == null) {
                sId = KMIndexUtil.generateIndexId(BOName, IDX_TYPE_RELATED);
                m_globalIndexes.put(BOName, sId);
            }
            return sId;
        }
    }

    private static String generateIndexId(String BOName, int idxType) throws ConfigException, RemoteException, NamingException {
        ConfigProps props = ConfigProps.getInstance();
        String prefix = props.getNotNullProperty("IDX_PREFIX");
        String suffix = idxType == IDX_TYPE_PROPER ? props.getNotNullProperty("IDX_SUFFIX") : props.getNotNullProperty("IDX_SUFFIX_RELATED");
        String delimeter = props.getNotNullProperty("IDX_DELIMETER");
        String id = new StringBuffer(prefix.length() + suffix.length() + BOName.length() + delimeter.length() * 2).append(prefix).append(delimeter).append(KMIndexUtil.convertBONameForKM(BOName)).append(delimeter).append(suffix).toString();
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFolderRID(String BOName) throws ConfigException, BOAccessException {
        Map map = m_folders;
        synchronized (map) {
            String sFolder = (String)m_folders.get(BOName);
            if (sFolder == null) {
                ConfigProps props = ConfigProps.getInstance();
                BOAccessor access = BOAccessor.getInstance();
                sFolder = props.getNotNullProperty("KM_REPOSITORY") + "/" + access.getGUID(BOName);
                m_folders.put(BOName, sFolder);
            }
            return sFolder;
        }
    }

    public static String getBOGuid(String sBORid) {
        if (sBORid == null || sBORid.length() == 0) {
            return null;
        }
        int keyPos = sBORid.lastIndexOf(47);
        if (keyPos == -1) {
            return null;
        }
        if (sBORid.length() <= (keyPos += 2)) {
            return null;
        }
        return sBORid.substring(keyPos);
    }

    public static Object getBOTypeGuid(String sBORid) {
        int j;
        if (sBORid == null || sBORid.length() < 2) {
            return null;
        }
        int i = sBORid.indexOf(47, 1);
        if (i == -1) {
            return null;
        }
        if ((j = sBORid.indexOf(47, ++i)) == -1) {
            return null;
        }
        return sBORid.subSequence(i, j);
    }

    protected static String convertBONameForKM(String sBOName) throws ConfigException {
        ConfigProps props = ConfigProps.getInstance();
        String sDelimeter = props.getNotNullProperty("IDX_DELIMETER");
        char[] chars = sBOName.toCharArray();
        int len = FORBIDDEN_CHARS.length;
        int i = chars.length;
        block0: while (--i >= 0) {
            int j = len;
            while (--j >= 0) {
                if (chars[i] != FORBIDDEN_CHARS[j]) continue;
                chars[i] = sDelimeter.charAt(0);
                continue block0;
            }
        }
        return new String(chars);
    }

    static {
        m_indexes = new HashMap();
        m_globalIndexes = new HashMap();
        m_folders = new HashMap();
        IDX_TYPE_PROPER = 1;
        IDX_TYPE_RELATED = 2;
        FORBIDDEN_CHARS = new char[]{'/', '.', ':', '\\', '\"', '\''};
    }
}

