/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.svc.idxsearch.index;

import com.sap.caf.km.ejb.svc.idxsearch.bo.BODbHelper;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndex;
import com.sap.caf.km.ejb.svc.idxsearch.index.KMIndex;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConnectionManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public final class KMIndexHelper
extends BODbHelper {
    public KMIndexHelper(ConnectionManager manager) {
        super(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIndex assignIndex(String BOName, String indexId, int indexType) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        boolean iUpdateType = false;
        try {
            KMIndex kMIndex;
            String sql;
            BigDecimal boId = this.getBusinessObjectId(conn, BOName);
            PreparedStatement pstmt = conn.prepareStatement("select 1 from CAF_RT_IDX where BO_ID=? and INDEX_TYPE=?");
            try {
                pstmt.setBigDecimal(1, boId);
                pstmt.setInt(2, indexType);
                ResultSet rs = pstmt.executeQuery();
                if (indexType == 3 || !rs.next()) {
                    sql = "insert into CAF_RT_IDX (INDEX_NAME,REINDEX_DATE,BO_ID,INDEX_TYPE, INDEX_ID) values (?,?,?,?,?)";
                } else {
                    iUpdateType = true;
                    sql = "update CAF_RT_IDX set INDEX_NAME=?,REINDEX_DATE=? where BO_ID=? and INDEX_TYPE=?";
                }
            }
            finally {
                pstmt.close();
            }
            pstmt = conn.prepareStatement(sql);
            try {
                Timestamp creationDate = new Timestamp(System.currentTimeMillis());
                pstmt.setString(1, indexId);
                pstmt.setTimestamp(2, creationDate);
                pstmt.setBigDecimal(3, boId);
                pstmt.setInt(4, indexType);
                if (!iUpdateType) {
                    BigDecimal key = this.getNextInSequence(conn, 0);
                    pstmt.setBigDecimal(5, key);
                }
                pstmt.executeUpdate();
                kMIndex = new KMIndex(indexId, creationDate, BOName, indexType, -1);
            }
            catch (Throwable throwable) {
                pstmt.close();
                throw throwable;
            }
            pstmt.close();
            return kMIndex;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unassignIndex(String BOName, int indexType) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            BigDecimal boId = this.getBusinessObjectId(conn, BOName);
            PreparedStatement pstmt = conn.prepareStatement("delete from CAF_RT_IDX where BO_ID=? and INDEX_TYPE=?");
            try {
                pstmt.setBigDecimal(1, boId);
                pstmt.setInt(2, indexType);
                pstmt.executeUpdate();
            }
            finally {
                pstmt.close();
            }
            this.deleteBusinessObject(conn, BOName);
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unassignIndex(String BOName, String indexId, int indexType) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            BigDecimal boId = this.getBusinessObjectId(conn, BOName);
            PreparedStatement pstmt = conn.prepareStatement("delete from CAF_RT_IDX where BO_ID=? and INDEX_NAME=? and INDEX_TYPE=?");
            try {
                pstmt.setBigDecimal(1, boId);
                pstmt.setString(2, indexId);
                pstmt.setInt(3, indexType);
                pstmt.execute();
            }
            finally {
                pstmt.close();
            }
            this.deleteBusinessObject(conn, BOName);
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIndex[] getAllIndexes() throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            IIndex[] iIndexArray;
            PreparedStatement pstmt = conn.prepareStatement("select BO_NAME,INDEX_NAME,REINDEX_DATE,INDEX_TYPE from CAF_RT_IDX A,CAF_RT_BO B where A.BO_ID=B.BO_ID");
            try {
                ResultSet rs = pstmt.executeQuery();
                ArrayList<KMIndex> indexes = new ArrayList<KMIndex>();
                while (rs.next()) {
                    String BOName = rs.getString("BO_NAME");
                    String indexId = rs.getString("INDEX_NAME");
                    Timestamp reindexDate = rs.getTimestamp("REINDEX_DATE");
                    int indexType = rs.getInt("INDEX_TYPE");
                    indexes.add(new KMIndex(indexId, reindexDate, BOName, indexType, -1));
                }
                iIndexArray = indexes.toArray(new IIndex[indexes.size()]);
            }
            catch (Throwable throwable) {
                pstmt.close();
                throw throwable;
            }
            pstmt.close();
            return iIndexArray;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndexDate(String BOName, int indexType) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            BigDecimal boId = this.getBusinessObjectId(conn, BOName);
            PreparedStatement pstmt = conn.prepareStatement("update CAF_RT_IDX set REINDEX_DATE=? where BO_ID=? and INDEX_TYPE=?");
            try {
                Timestamp reindexDate = new Timestamp(System.currentTimeMillis());
                pstmt.setTimestamp(1, reindexDate);
                pstmt.setBigDecimal(2, boId);
                pstmt.setInt(3, indexType);
                pstmt.executeUpdate();
            }
            finally {
                pstmt.close();
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            conn.close();
        }
    }

    public IIndex[] merge(IIndex[] remoteIndexes, IIndex[] localIndexes) throws SQLException {
        IIndex local;
        block0: for (int i = 0; i < remoteIndexes.length; ++i) {
            IIndex remote = remoteIndexes[i];
            String remoteIndexId = remote.getName();
            remote.setType(3);
            boolean merged = false;
            for (int j = 0; j < localIndexes.length; ++j) {
                local = localIndexes[j];
                if (local == null || !remoteIndexId.equals(local.getName())) continue;
                local.setState(remoteIndexes[i].getState());
                remoteIndexes[i] = local;
                localIndexes[j] = null;
                continue block0;
            }
        }
        ArrayList<IIndex> remoteList = new ArrayList<IIndex>(Arrays.asList(remoteIndexes));
        for (int i = 0; i < localIndexes.length; ++i) {
            local = localIndexes[i];
            if (local == null || local.getType() != 3 || local.getBOName() == null) continue;
            local.setType(0);
            remoteList.add(local);
            localIndexes[i] = null;
        }
        remoteIndexes = remoteList.toArray(new IIndex[remoteList.size()]);
        this.deleteUnused(localIndexes);
        return remoteIndexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteUnused(IIndex[] indexes) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            PreparedStatement pstmt = conn.prepareStatement("delete from CAF_RT_IDX where INDEX_NAME=?");
            try {
                for (int i = 0; i < indexes.length; ++i) {
                    IIndex index = indexes[i];
                    if (index == null) continue;
                    pstmt.setString(1, index.getName());
                    pstmt.execute();
                }
                this.deleteBusinessObjects(conn);
            }
            finally {
                pstmt.close();
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getIndexId(String BOName, int type) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            ArrayList<String> arrayList;
            PreparedStatement pstmt = conn.prepareStatement("select INDEX_NAME from CAF_RT_IDX A,CAF_RT_BO B where A.BO_ID=B.BO_ID and B.BO_NAME=? and INDEX_TYPE=?");
            pstmt.setString(1, BOName);
            pstmt.setInt(2, type);
            try {
                ResultSet rs = pstmt.executeQuery();
                ArrayList<String> indices = new ArrayList<String>();
                while (rs.next()) {
                    indices.add(rs.getString("INDEX_NAME"));
                }
                arrayList = indices;
            }
            catch (Throwable throwable) {
                pstmt.close();
                throw throwable;
            }
            pstmt.close();
            return arrayList;
        }
        finally {
            conn.close();
        }
    }

    public boolean checkIndexExist(String BOName, int type) throws SQLException {
        List coll = this.getIndexId(BOName, type);
        return coll != null && coll.size() > 0;
    }

    public boolean checkAtLeastOneIndexExist(Collection BONames, int type) throws SQLException {
        Iterator i = BONames.iterator();
        while (i.hasNext()) {
            String BOName = (String)i.next();
            List coll = this.getIndexId(BOName, type);
            if (coll == null || coll.size() <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIndex bless(IIndex remote) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            IIndex iIndex;
            PreparedStatement pstmt = conn.prepareStatement("select BO_NAME,REINDEX_DATE,INDEX_TYPE from CAF_RT_IDX A,CAF_RT_BO B where A.BO_ID=B.BO_ID and INDEX_NAME=?");
            String indexName = remote.getName();
            pstmt.setString(1, indexName);
            try {
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    remote.setBOName(rs.getString("BO_NAME"));
                    remote.setType(rs.getInt("INDEX_TYPE"));
                    remote.setCreationDate((Date)rs.getTimestamp("REINDEX_DATE"));
                }
                iIndex = remote;
            }
            catch (Throwable throwable) {
                pstmt.close();
                throw throwable;
            }
            pstmt.close();
            return iIndex;
        }
        finally {
            conn.close();
        }
    }
}

