/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.svc.idxqueue;

import com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex;
import com.sap.caf.km.ejb.svc.idxsearch.bean.IndexSearchLocal;
import com.sap.caf.km.ejb.svc.idxsearch.bean.IndexSearchLocalHome;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.rt.exception.CAFBaseException;
import com.sap.caf.rt.metamodel.MetaModel;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.naming.InitialContext;

public class IndexQueueBean
implements MessageDrivenBean,
MessageListener {
    private static final String APPLICATION = (class$com$sap$caf$km$ejb$svc$idxqueue$IndexQueueBean == null ? (class$com$sap$caf$km$ejb$svc$idxqueue$IndexQueueBean = IndexQueueBean.class$("com.sap.caf.km.ejb.svc.idxqueue.IndexQueueBean")) : class$com$sap$caf$km$ejb$svc$idxqueue$IndexQueueBean).getName();
    private static final String jARMReqPrefix = "CAF:RT:oal:";
    private static final String JARM_REQUEST = "CAF:RT:oal:" + APPLICATION;
    private static final Location location = Location.getLocation((String)APPLICATION);
    private MessageDrivenContext myContext;
    private static final String jndiIndexSearchBean = "localejbs/sap.com/caf~com.sap.caf.runtime/IndexSearchBean";
    private static final String separator = "%$%";
    private static final String CHANGE = "BUSINESS_OBJECT_CHANGED";
    private static final String REMOVE = "BUSINESS_OBJECT_REMOVED";
    private static final String CREATE = "BUSINESS_OBJECT_CREATED";
    static /* synthetic */ Class class$com$sap$caf$km$ejb$svc$idxqueue$IndexQueueBean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        String method = JARM_REQUEST + ":onMessage(Message)";
        this.enter(method, new Object[]{msg});
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            Enumeration enumeration = msg.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String value = msg.getStringProperty(name);
                map.put(name, value);
            }
            ArrayList<String> col = new ArrayList<String>();
            String usedby = (String)map.get("USEDBY");
            StringTokenizer tok2 = new StringTokenizer(usedby, ";");
            while (tok2.hasMoreTokens()) {
                String tmp = tok2.nextToken();
                col.add(tmp);
            }
            if (msg.getStringProperty("ACTION").equals(CHANGE)) {
                this.put((String)map.get("RID"), (String)map.get("OBJTYPE"), col, 1);
            } else if (msg.getStringProperty("ACTION").equals(CREATE)) {
                this.put((String)map.get("RID"), (String)map.get("OBJTYPE"), col, 1);
            } else if (msg.getStringProperty("ACTION").equals(REMOVE)) {
                this.put((String)map.get("RID"), (String)map.get("OBJTYPE"), col, 0);
            }
        }
        catch (Exception ex) {
            CAFBaseException indexqEx = new CAFBaseException((Throwable)ex);
            this.log(indexqEx, method, null);
        }
        finally {
            this.exit(method, null);
        }
    }

    public void ejbRemove() {
    }

    public void setMessageDrivenContext(MessageDrivenContext context) {
        this.myContext = context;
    }

    public void ejbCreate() {
    }

    private synchronized void put(String rid, String objType, Collection usedBy, int bReindex) throws CAFBaseException {
        String method = JARM_REQUEST + ":put(String, String, Collection, int)";
        this.enter(method, new Object[]{rid, objType, usedBy, new Integer(bReindex)});
        try {
            IndexSearchLocal bean = null;
            InitialContext ctx = new InitialContext();
            IndexSearchLocalHome home = (IndexSearchLocalHome)ctx.lookup(jndiIndexSearchBean);
            bean = home.create();
            if (bReindex == 1) {
                bean.indexObject(objType, rid);
            } else if (bReindex == 0) {
                bean.deindexObject(objType, rid);
            }
            if (usedBy != null && usedBy.size() > 0) {
                this.updateIndexByRelatedObject(usedBy, rid, bReindex, (IIndexSearchIndex)bean);
            }
        }
        catch (Exception ex) {
            CAFBaseException indexqEx = new CAFBaseException((Throwable)ex);
            this.log(indexqEx, method, null);
            throw indexqEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    private void updateIndexByRelatedObject(Collection usedBy, String objRid, int bReindex, IIndexSearchIndex bean) throws CAFBaseException {
        String method = JARM_REQUEST + ":updateIndexByRelatedObject(Collection, String, int, IIndexSearchIndex)";
        this.enter(method, new Object[]{usedBy, objRid, new Integer(bReindex), bean});
        try {
            String fullBOName;
            HashSet<String> objNames = new HashSet<String>();
            MetaModel model = new MetaModel();
            Iterator i = usedBy.iterator();
            while (i.hasNext()) {
                String sMofId;
                int m;
                int k;
                String rid = (String)i.next();
                if (rid.length() == 0 || (k = rid.indexOf(47, 1)) == -1 || (m = rid.indexOf(47, ++k)) == -1 || objNames.contains(sMofId = rid.substring(k, m))) continue;
                DataObject dataObj = model.getDataObjectByGUID(sMofId);
                Application appl = dataObj.getApplication();
                fullBOName = appl.getProviderName() + "/" + appl.getName() + "/" + dataObj.getName();
                objNames.add(fullBOName);
            }
            if (objNames.isEmpty()) {
                return;
            }
            i = objNames.iterator();
            while (i.hasNext()) {
                fullBOName = (String)i.next();
                if (bReindex == 1) {
                    bean.indexRelatedObject(fullBOName, objRid);
                    continue;
                }
                if (bReindex != 0) continue;
                bean.deindexRelatedObject(fullBOName, objRid);
            }
        }
        catch (Exception ex) {
            CAFBaseException indexqEx = new CAFBaseException((Throwable)ex);
            this.log(indexqEx, method, null);
            throw indexqEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    protected void log(CAFBaseException e, String method, Object[] args) {
        CAFPublicLogger.logThrowable((int)500, (Category)CAFPublicLogger.categoryCAF, (Location)this.getLocation(), (String)method, (String)e.getMessage(), (Throwable)e);
    }

    protected void info(String method, String message, Object[] args) {
        CAFPublicLogger.logThrowable((int)300, (Category)CAFPublicLogger.categoryCAF, (Location)this.getLocation(), (String)method, (String)message, null);
    }

    protected void enter(String method, Object[] args) {
        CAFPublicLogger.entering(null, (String)this.getJARMRequest(), (String)method, (Location)this.getLocation(), (Object[])args, (int)1);
    }

    protected void exit(String method, Object result) {
        CAFPublicLogger.exiting(null, (String)this.getJARMRequest(), (String)method, (Location)this.getLocation(), (Object)result, (int)1);
    }

    protected Location getLocation() {
        return location;
    }

    protected String getJARMRequest() {
        return JARM_REQUEST;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

