/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.data.folder;

import com.sap.caf.km.da.KMDataAccessBean;
import com.sap.caf.km.da.KMDataAccessException;
import com.sap.caf.km.ejb.data.util.IKMNodeExceptionResourceKeys;
import com.sap.caf.km.ejb.data.util.INodeHeader;
import com.sap.caf.km.ejb.data.util.KMNodeException;
import com.sap.caf.km.ejb.data.util.NodeChildren;
import com.sap.caf.km.ejb.data.util.NodeContent;
import com.sap.caf.km.ejb.data.util.NodeHeader;
import com.sap.caf.km.ejb.data.util.ProxyHelper;
import com.sap.caf.km.proxies.data.kmnode.KMNodeService;
import com.sap.caf.km.proxies.data.kmnode.KMNodeServiceService;
import com.sap.caf.km.proxies.data.kmnode.types.KMNodeAttribute;
import com.sap.caf.km.proxies.data.kmnode.types.KMNodeContent;
import com.sap.caf.km.proxies.data.kmnode.types.KMNodeHeader;
import com.sap.caf.km.proxies.data.kmnode.types.KMNodePermission;
import com.sap.caf.km.proxies.data.kmnode.types.KMUserContext;
import com.sap.caf.km.proxies.svc.kmrelation.KMRelationSvc;
import com.sap.caf.km.proxies.svc.kmrelation.KMRelationSvcService;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;

public class FolderProxyEJBBean
extends KMDataAccessBean
implements IKMNodeExceptionResourceKeys {
    private static final String APPLICATION = (class$com$sap$caf$km$ejb$data$folder$FolderProxyEJBBean == null ? (class$com$sap$caf$km$ejb$data$folder$FolderProxyEJBBean = FolderProxyEJBBean.class$("com.sap.caf.km.ejb.data.folder.FolderProxyEJBBean")) : class$com$sap$caf$km$ejb$data$folder$FolderProxyEJBBean).getName();
    private static final String jARMReqPrefix = "CAF:RT:oal:";
    private static final String JARM_REQUEST = "CAF:RT:oal:" + APPLICATION;
    private static final Location location = Location.getLocation((String)APPLICATION);
    private final String separator = "/";
    transient InitialContext JNDIcontext = null;
    transient KMNodeService WS = null;
    transient KMNodeServiceService WSService = null;
    transient KMRelationSvc WSRelation = null;
    transient KMRelationSvcService WSRelationService = null;
    String userId = null;
    IUser user = null;
    transient IUserFactory userFactory;
    private transient SessionContext myContext;
    static /* synthetic */ Class class$com$sap$caf$km$ejb$data$folder$FolderProxyEJBBean;
    static /* synthetic */ Class class$com$sap$caf$km$proxies$data$kmnode$KMNodeService;
    static /* synthetic */ Class class$com$sap$caf$km$proxies$svc$kmrelation$KMRelationSvc;

    public FolderProxyEJBBean() {
        UMFactory.getInstance();
        this.userFactory = UMFactory.getUserFactory();
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext context) {
        this.myContext = context;
    }

    public void ejbCreate() throws CreateException {
        String method = JARM_REQUEST + ":ejbCreate()";
        this.enter(method, null);
        try {
            if (this.JNDIcontext == null) {
                this.JNDIcontext = new InitialContext();
                this.WSService = (KMNodeServiceService)this.JNDIcontext.lookup("wsclients/proxies/sap.com/caf~km.proxies/KMNodeJNDI");
                this.WS = (KMNodeService)this.WSService.getLogicalPort(class$com$sap$caf$km$proxies$data$kmnode$KMNodeService == null ? (class$com$sap$caf$km$proxies$data$kmnode$KMNodeService = FolderProxyEJBBean.class$("com.sap.caf.km.proxies.data.kmnode.KMNodeService")) : class$com$sap$caf$km$proxies$data$kmnode$KMNodeService);
                String url = ProxyHelper.getActualUrl((String)this.WS._getProperty("javax.xml.rpc.service.endpoint.address"));
                if (!url.equals(this.WS._getProperty("javax.xml.rpc.service.endpoint.address"))) {
                    this.WS._setProperty("javax.xml.rpc.service.endpoint.address", (Object)url);
                }
                this.WSRelationService = (KMRelationSvcService)this.JNDIcontext.lookup("wsclients/proxies/sap.com/caf~km.proxies/KMRelationJNDI");
                this.WSRelation = (KMRelationSvc)this.WSRelationService.getLogicalPort(class$com$sap$caf$km$proxies$svc$kmrelation$KMRelationSvc == null ? (class$com$sap$caf$km$proxies$svc$kmrelation$KMRelationSvc = FolderProxyEJBBean.class$("com.sap.caf.km.proxies.svc.kmrelation.KMRelationSvc")) : class$com$sap$caf$km$proxies$svc$kmrelation$KMRelationSvc);
                url = ProxyHelper.getActualUrl((String)this.WSRelation._getProperty("javax.xml.rpc.service.endpoint.address"));
                if (!url.equals(this.WSRelation._getProperty("javax.xml.rpc.service.endpoint.address"))) {
                    this.WSRelation._setProperty("javax.xml.rpc.service.endpoint.address", (Object)url);
                }
            }
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTCREATEEJB", e);
            this.log((KMDataAccessException)nodeEx, method, null);
            throw new CreateException(nodeEx.getLocalizedMessage());
        }
        finally {
            this.exit(method, null);
        }
    }

    public void move(String sourceRid, String targetRid) throws KMNodeException {
        String method = JARM_REQUEST + ":move(String, String)";
        Object[] args = new Object[]{sourceRid, targetRid};
        this.enter(method, args);
        try {
            if (sourceRid == null || targetRid == null) {
                throw new KMNodeException("NULLINPUT");
            }
            KMUserContext userContext = this.getUserContext();
            this.WS.moveNode(userContext, sourceRid, targetRid);
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTMOVENODE", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public boolean exists(String folderRid) throws KMNodeException {
        String method = JARM_REQUEST + ":exists(String)";
        Object[] args = new Object[]{folderRid};
        this.enter(method, args);
        try {
            if (folderRid == null) {
                throw new KMNodeException("NULLINPUT");
            }
            boolean bl = this.WS.exists(this.getUserContext(), folderRid);
            return bl;
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTCHECKEXIST", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void createFolderHeader(String name, String parentRid, String displayName, String description, Collection relations) throws KMNodeException {
        String method = JARM_REQUEST + ":createFolderHeader(String, String, String, String, Collection)";
        Object[] args = new Object[]{name, parentRid, displayName, description, relations};
        this.enter(method, args);
        try {
            if (parentRid == null || name == null) {
                throw new KMNodeException("NULLINPUT");
            }
            String userId = this.getContextUserId();
            KMUserContext userContext = this.getUserContext();
            if (displayName == null) {
                displayName = name;
            }
            if (description == null) {
                description = "";
            }
            KMNodeHeader header = new KMNodeHeader();
            boolean isFolder = true;
            KMNodeAttribute[] attributes = this.setAttributesCreateHeader(userId, displayName, description);
            KMNodePermission[] permissions = this.setPermissions(userId);
            this.WS.createNode(userContext, parentRid, name, isFolder, null, attributes, permissions, relations.toArray(new String[relations.size()]));
        }
        catch (Exception e) {
            KMNodeException nodeEx = new KMNodeException("CANTCREATEFOLDERHEADER", args, (Throwable)e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public NodeHeader readFolderHeader(String name, String parentRid) throws KMNodeException {
        String method = JARM_REQUEST + ":readFolderHeader(String, String)";
        Object[] args = new Object[]{name, parentRid};
        this.enter(method, args);
        try {
            if (parentRid == null || name == null) {
                throw new KMNodeException("NULLINPUT");
            }
            String rid = this.getRid(name, parentRid);
            KMNodeHeader kmHeader = this.WS.readNodeHeader(this.getUserContext(), rid, true, true, true);
            NodeHeader nodeHeader = this.createNodeHeader(kmHeader);
            return nodeHeader;
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTREADFOLDERHEADER", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public NodeContent readFolderContent(String name, String parentRid) throws KMNodeException {
        String method = JARM_REQUEST + ":readFolderContent(String, String)";
        Object[] args = new Object[]{name, parentRid};
        this.enter(method, args);
        try {
            if (parentRid == null || name == null) {
                throw new KMNodeException("NULLINPUT");
            }
            String rid = this.getRid(name, parentRid);
            KMUserContext userContext = this.getUserContext();
            KMNodeContent content = this.WS.readContent(userContext, rid, 1000000);
            NodeContent resultContent = new NodeContent();
            resultContent.setName(name);
            resultContent.setParentRid(parentRid);
            resultContent.setContentLength(content.getContentLength());
            resultContent.setContentType(content.getContentType());
            resultContent.setContentEncoding(content.getContentEncoding());
            resultContent.setContent(content.getContent());
            NodeContent nodeContent = resultContent;
            return nodeContent;
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTREADFOLDERCONTENT", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void deleteFolder(String name, String parentRid) throws KMNodeException {
        String method = JARM_REQUEST + ":deleteFolder(String, String)";
        Object[] args = new Object[]{name, parentRid};
        this.enter(method, args);
        try {
            if (parentRid == null || name == null) {
                throw new KMNodeException("NULLINPUT");
            }
            String rid = this.getRid(name, parentRid);
            this.WS.deleteNode(this.getUserContext(), rid);
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTDELETEFOLDER", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void deleteEmptyFolders(String name, String parentRid) throws KMNodeException {
        String method = JARM_REQUEST + ":deleteEmptyFolders(String, String)";
        Object[] args = new Object[]{name, parentRid};
        this.enter(method, args);
        try {
            if (parentRid == null || name == null) {
                throw new KMNodeException("NULLINPUT", args);
            }
            String rid = this.getRid(name, parentRid);
            KMUserContext userContext = this.getUserContext();
            this.WS.deleteEmptyFolders(userContext, rid);
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTDELETEEMPTYFOLDERS", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void saveFolderHeader(String name, String parentRid, String displayName, String description, Collection relations) throws KMNodeException {
        String method = JARM_REQUEST + ":saveFolderHeader(String, String, String, String, Collection)";
        Object[] args = new Object[]{name, parentRid};
        this.enter(method, args);
        try {
            if (name == null || parentRid == null) {
                throw new KMNodeException("NULLINPUT");
            }
            if (displayName == null) {
                displayName = name;
            }
            if (description == null) {
                description = "";
            }
            String userId = this.getContextUserId();
            KMUserContext userContext = this.getUserContext();
            String rid = this.getRid(name, parentRid);
            KMNodeHeader header = new KMNodeHeader();
            KMNodeAttribute[] attributes = this.setAttributesSaveHeader(userId, displayName, description);
            KMNodePermission[] permissions = this.setPermissions(userId);
            this.WS.saveNodeHeader(userContext, rid, null, attributes, permissions, relations.toArray(new String[relations.size()]));
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTSAVEFODLERHEADER", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void saveFolderContent(String name, String parentRid, long contentLength, String contentType, String contentEncoding, byte[] content) throws KMNodeException {
        String method = JARM_REQUEST + ":saveFolderContent(String, String, long, String, String, byte[])";
        Object[] args = new Object[]{name, parentRid, new Long(contentLength), contentType, contentEncoding, content};
        this.enter(method, args);
        try {
            if (name == null || parentRid == null || content == null) {
                throw new KMNodeException("NULLINPUT");
            }
            String rid = this.getRid(name, parentRid);
            KMUserContext userContext = this.getUserContext();
            this.WS.saveNodeContent(userContext, rid, content, contentType, contentEncoding, contentLength);
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTSAVEFOLDERCONTENT", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection findFolder(String searchString, String startSearchRid) throws KMNodeException {
        String method = JARM_REQUEST + ":findFolder(String, String)";
        Object[] args = new Object[]{searchString, startSearchRid};
        this.enter(method, args);
        try {
            if (searchString == null || startSearchRid == null) {
                throw new KMNodeException("NULLINPUT");
            }
            KMNodeHeader[] proxyHeaders = null;
            LinkedList<KMNodeHeader> nodeHeaders = new LinkedList<KMNodeHeader>();
            KMUserContext userContext = this.getUserContext();
            proxyHeaders = this.WS.findNodeByDisplayName(userContext, searchString, startSearchRid);
            if (proxyHeaders != null) {
                for (int i = 0; i < proxyHeaders.length; ++i) {
                    nodeHeaders.add(proxyHeaders[i]);
                }
            }
            LinkedList<KMNodeHeader> linkedList = nodeHeaders;
            return linkedList;
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTFINDFOLDER", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public NodeHeader[] getChildren(String name, String parentRid) throws KMNodeException {
        String method = JARM_REQUEST + ":getChildren(String, String)";
        Object[] args = new Object[]{name, parentRid};
        this.enter(method, args);
        try {
            if (name == null || parentRid == null) {
                throw new KMNodeException("NULLINPUT");
            }
            String rid = this.getRid(name, parentRid);
            rid = rid.length() == 0 ? "/" : rid;
            KMUserContext userContext = this.getUserContext();
            KMNodeHeader[] proxyHeaders = this.WS.readChildren(userContext, rid, true, true, true);
            if (proxyHeaders.length == 0) {
                NodeHeader[] nodeHeaderArray = null;
                return nodeHeaderArray;
            }
            NodeHeader[] nodeHeaders = new NodeHeader[proxyHeaders.length];
            for (int i = 0; i < proxyHeaders.length; ++i) {
                nodeHeaders[i] = this.createNodeHeader(proxyHeaders[i]);
            }
            NodeHeader[] nodeHeaderArray = nodeHeaders;
            return nodeHeaderArray;
        }
        catch (Throwable e) {
            KMNodeException nodeEx = new KMNodeException("CANTGETCHILDERN", args, e);
            this.log((KMDataAccessException)nodeEx, method, args);
            throw nodeEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public NodeChildren getNodeChildren(String name, String parentRid) throws KMNodeException {
        ArrayList<String> documents = new ArrayList<String>();
        ArrayList<String> folder = new ArrayList<String>();
        NodeChildren children = new NodeChildren();
        children.setName(name);
        children.setParentRid(parentRid);
        NodeHeader[] tmp = this.getChildren(name, parentRid);
        if (tmp != null) {
            for (int i = 0; i < tmp.length; ++i) {
                if (tmp[i].isFolder()) {
                    folder.add(tmp[i].getParentRid() + "/" + tmp[i].getName());
                    continue;
                }
                documents.add(tmp[i].getParentRid() + "/" + tmp[i].getName());
            }
        }
        children.setDocuments(documents);
        children.setFolder(folder);
        return children;
    }

    private NodeHeader createNodeHeader(KMNodeHeader kmHeader) throws KMNodeException {
        NodeHeader cafHeader = (NodeHeader)this.setExplicitAttributes(kmHeader);
        String[] relations = kmHeader.getRelations();
        cafHeader.setRelationRids(Arrays.asList(relations));
        return cafHeader;
    }

    private KMNodeAttribute[] setAttributesCreateHeader(String userId, String displayName, String description) {
        KMNodeAttribute[] attributes = new KMNodeAttribute[2];
        Calendar currentDate = Calendar.getInstance();
        KMNodeAttribute attributeDescription = new KMNodeAttribute();
        attributeDescription.setNamespace("http://sapportals.com/xmlns/cm");
        attributeDescription.setName("description");
        attributeDescription.setStringValue(description);
        attributes[0] = attributeDescription;
        KMNodeAttribute attributeDisplayname = new KMNodeAttribute();
        attributeDisplayname.setNamespace("http://sapportals.com/xmlns/cm");
        attributeDisplayname.setName("displayname");
        attributeDisplayname.setStringValue(displayName);
        attributes[1] = attributeDisplayname;
        return attributes;
    }

    private KMNodeAttribute[] setAttributesSaveHeader(String userId, String displayName, String description) {
        KMNodeAttribute[] attributes = new KMNodeAttribute[2];
        Calendar currentDate = Calendar.getInstance();
        KMNodeAttribute attributeDescription = new KMNodeAttribute();
        attributeDescription.setNamespace("http://sapportals.com/xmlns/cm");
        attributeDescription.setName("description");
        attributeDescription.setStringValue(description);
        attributes[0] = attributeDescription;
        KMNodeAttribute attributeDisplayname = new KMNodeAttribute();
        attributeDisplayname.setNamespace("http://sapportals.com/xmlns/cm");
        attributeDisplayname.setName("displayname");
        attributeDisplayname.setStringValue(displayName);
        attributes[1] = attributeDisplayname;
        return attributes;
    }

    private KMNodeAttribute[] setAttributesSaveContent(String userId, long contentLength) {
        KMNodeAttribute[] attributes = new KMNodeAttribute[2];
        Calendar currentDate = Calendar.getInstance();
        KMNodeAttribute attributeContentType = new KMNodeAttribute();
        attributeContentType.setNamespace("http://sapportals.com/xmlns/cm");
        attributeContentType.setName("contenttype");
        attributeContentType.setStringValue("text/plain");
        attributes[0] = attributeContentType;
        KMNodeAttribute attributeContentLength = new KMNodeAttribute();
        attributeContentLength.setNamespace("http://sapportals.com/xmlns/cm");
        attributeContentLength.setName("contentlength");
        attributeContentLength.setLongIntValue(contentLength);
        attributes[1] = attributeContentLength;
        return attributes;
    }

    private KMNodePermission[] setPermissions(String userId) {
        KMNodePermission[] permissions = new KMNodePermission[1];
        KMNodePermission permission = new KMNodePermission();
        permission.setPrincipalId(userId);
        permission.setPrincipalType(0);
        permission.setPermission("fullcontrol");
        permissions[0] = permission;
        return permissions;
    }

    private KMNodeAttribute getAttribute(String attributeName, KMNodeAttribute[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equalsIgnoreCase(attributeName) || !attributes[i].getNamespace().equalsIgnoreCase("http://sapportals.com/xmlns/cm")) continue;
            return attributes[i];
        }
        return null;
    }

    private String getName(String Rid) {
        int keyLength = 0;
        int keyLastSeparator = 0;
        keyLength = Rid.length();
        if (keyLength == 0) {
            return null;
        }
        keyLastSeparator = Rid.lastIndexOf("/");
        if (keyLastSeparator == keyLength - 1) {
            keyLastSeparator = Rid.lastIndexOf("/", keyLength - 1);
        }
        return Rid.substring(keyLastSeparator + 1);
    }

    private String getRid(String name, String parentRid) {
        int keyLength = 0;
        int keyLastSeparator = 0;
        keyLength = parentRid.length();
        keyLastSeparator = parentRid.lastIndexOf("/");
        if (keyLastSeparator == keyLength - 1) {
            return parentRid + name;
        }
        return parentRid + "/" + name;
    }

    private String getParentRid(String Rid) {
        if (Rid == null) {
            return null;
        }
        int keyLength = 0;
        int keyLastSeparator = 0;
        keyLength = Rid.length();
        if (keyLength == 0) {
            return "";
        }
        keyLastSeparator = Rid.lastIndexOf("/");
        if (keyLastSeparator == keyLength - 1) {
            keyLastSeparator = Rid.lastIndexOf("/", keyLength - 1);
        }
        return Rid.substring(0, keyLastSeparator);
    }

    private INodeHeader setExplicitAttributes(KMNodeHeader listHeader) {
        NodeHeader attributeHeader = new NodeHeader();
        String rid = listHeader.getRid();
        attributeHeader.setName(this.getName(rid));
        attributeHeader.setParentRid(this.getParentRid(rid));
        attributeHeader.setIsFolder(listHeader.getFolder());
        attributeHeader.setSize(listHeader.getNodeSize());
        KMNodeAttribute[] attrs = listHeader.getAttributes();
        if (attrs != null) {
            KMNodeAttribute attr = this.getAttribute("created", attrs);
            if (attr != null) {
                attributeHeader.setCreationdate(attr.getDateValue());
            }
            if ((attr = this.getAttribute("createdby", attrs)) != null) {
                attributeHeader.setCreatedBy(attr.getStringValue());
            }
            if ((attr = this.getAttribute("modified", attrs)) != null) {
                attributeHeader.setLastmodifieddate(attr.getDateValue());
            }
            if ((attr = this.getAttribute("modifiedby", attrs)) != null) {
                attributeHeader.setLastmodifiedBy(attr.getStringValue());
            }
            if ((attr = this.getAttribute("displayname", attrs)) != null) {
                attributeHeader.setDisplayName(attr.getStringValue());
            }
            if ((attr = this.getAttribute("description", attrs)) != null) {
                attributeHeader.setDescription(attr.getStringValue());
            }
            if ((attr = this.getAttribute("hidden", attrs)) != null) {
                attributeHeader.setIsHidden(attr.getBooleanValue());
            }
        }
        attributeHeader.setPermissions(listHeader.getPermissions());
        return attributeHeader;
    }

    private KMUserContext getUserContext() throws UMException {
        KMUserContext userContext = null;
        userContext = new KMUserContext();
        userContext.setCountryCode(Locale.US.getCountry());
        userContext.setLanguageCode(Locale.US.getLanguage());
        return userContext;
    }

    private String getContextUserId() throws UMException {
        return "admin";
    }

    protected Location getLocation() {
        return location;
    }

    protected String getJARMRequest() {
        return JARM_REQUEST;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

