/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.notification;

import com.sapportals.portal.prt.logger.ILogger;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.service.notification.StreamData;
import com.sapportals.portal.prt.service.notification.TopicDataContainer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileData
extends StreamData {
    private String mm_filePath;
    private ByteArrayOutputStream mm_bout;
    private ILogger mm_logger = PortalRuntime.getLogger((String)"notification_logger");

    public FileData(String filePath) {
        this.mm_type = TopicDataContainer.FILE;
        this.mm_filePath = filePath;
        this.mm_bout = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(this.mm_bout);
        this.zipDir(this.mm_filePath, zout);
        this.mm_inputStream = new ByteArrayInputStream(this.mm_bout.toByteArray());
        this.mm_value = this.mm_bout.toString();
    }

    public FileData(InputStream inputStream) {
        super(inputStream);
        this.mm_type = TopicDataContainer.FILE;
    }

    public void copyToDir(String path) {
        ZipInputStream zipis = new ZipInputStream(this.getInputStream());
        StringBuffer dir = new StringBuffer(128);
        dir.append(path + File.separator);
        ZipEntry entry = null;
        try {
            while ((entry = zipis.getNextEntry()) != null) {
                this.extractZipEntry(zipis, entry, dir.toString());
                zipis.closeEntry();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getFilePath() {
        return this.mm_filePath;
    }

    public void setFilePath(String filePath) {
        this.mm_filePath = filePath;
    }

    /*
     * WARNING - void declaration
     */
    private void extractZipEntry(ZipInputStream zis, ZipEntry target, String targetDir) throws ZipException, IOException {
        try {
            File file = new File(targetDir + target.getName());
            if (target.isDirectory()) {
                if (!file.exists()) {
                    this.createDir(file);
                } else {
                    if (!file.delete()) {
                        // empty if block
                    }
                    this.createDir(file);
                }
            } else {
                int n;
                if (!file.getParentFile().exists()) {
                    this.createDir(file.getParentFile());
                }
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                int BUFSIZ = 2048;
                byte[] inbuf = new byte[2048];
                while ((n = zis.read(inbuf, 0, 2048)) != -1) {
                    void var8_10;
                    bos.write(inbuf, 0, (int)var8_10);
                }
                bos.flush();
                bos.close();
            }
        }
        catch (ZipException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private void createDir(File dir) {
        if (!dir.mkdirs() && this.mm_logger.isActive()) {
            this.mm_logger.warning("[FileData] Cannot create directory : " + dir.getName());
        }
    }

    private void zipDir(String realPath, ZipOutputStream zos) {
        File dirObj = new File(realPath);
        if (dirObj.exists()) {
            if (dirObj.isDirectory()) {
                File[] fileList = dirObj.listFiles();
                int i = 0;
                while (i < fileList.length) {
                    if (fileList[i].isDirectory()) {
                        this.zipDir(realPath + File.separator + fileList[i].getName(), zos);
                    } else if (fileList[i].isFile()) {
                        this.zipFile(realPath + File.separator + fileList[i].getName(), zos);
                    }
                    ++i;
                }
            } else {
                this.zipFile(realPath, zos);
            }
        } else if (this.mm_logger.isActive()) {
            this.mm_logger.warning("[FileData] File or directory does not exist : " + dirObj.getAbsolutePath());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void zipFile(String realPath, ZipOutputStream zos) {
        try {
            int byteCount;
            File file = new File(realPath);
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            CRC32 crc32 = new CRC32();
            ZipEntry fileEntry = new ZipEntry(realPath.substring(realPath.lastIndexOf(File.separator) + 1));
            fileEntry.setSize(file.length());
            fileEntry.setTime(file.lastModified());
            fileEntry.setCrc(crc32.getValue());
            zos.putNextEntry(fileEntry);
            byte[] data = new byte[1024];
            while ((byteCount = bis.read(data, 0, 1024)) > -1) {
                void var9_10;
                crc32.update(data, 0, (int)var9_10);
                zos.write(data, 0, (int)var9_10);
            }
            fileEntry.setCrc(crc32.getValue());
            bis.close();
            fis.close();
            zos.closeEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

