/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.ui.wizards.imports;

import com.sap.ide.tools.ui.wizards.imports.PluginMessages;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public class IaikImportWizardPage
extends WizardDataTransferPage {
    private static final String PAGE_MESSAGE = "Import IAIK jar file";
    private static final String PAGE_DESCRIPTION = "Import file iaik_jce.jar from SDA sap_java_crypto_toolkit.sda";
    private static final String PAGE_TITLE = "Import";
    private static final String FILE_IMPORT_MASK = "*.sda;*.jar";
    private boolean entryChanged = false;
    private ZipFile selectedSdaFile;
    protected Combo sourceNameField;
    protected Button sourceBrowseButton;

    protected IaikImportWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
    }

    public ZipFile getSelectedSdaFile() {
        return this.selectedSdaFile;
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
    }

    public boolean cancel() {
        if (this.selectedSdaFile != null) {
            this.closeZipFile(this.selectedSdaFile);
        }
        return true;
    }

    public boolean finish() {
        if (this.selectedSdaFile != null) {
            this.closeZipFile(this.selectedSdaFile);
        }
        return true;
    }

    protected void handleSourceBrowseButtonPressed() {
        String selectedFile = this.queryZipFileToImport();
        if (selectedFile != null && !selectedFile.equals(this.sourceNameField.getText())) {
            this.selectedSdaFile = this.getSpecifiedSourceFile(selectedFile);
            if (this.selectedSdaFile != null) {
                this.setSourceName(selectedFile);
                super.setPageComplete(true);
            }
        }
    }

    protected String queryZipFileToImport() {
        FileDialog dialog = new FileDialog(this.sourceNameField.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{FILE_IMPORT_MASK});
        String currentSourceString = this.sourceNameField.getText();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        return dialog.open();
    }

    protected ZipFile getSpecifiedSourceFile() {
        return this.getSpecifiedSourceFile(this.sourceNameField.getText());
    }

    private ZipFile getSpecifiedSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException e) {
            this.displayErrorDialog(PluginMessages.getString("ZipImport.badFormat"));
        }
        catch (IOException e) {
            this.displayErrorDialog(PluginMessages.getString("ZipImport.couldNotRead"));
        }
        this.sourceNameField.setFocus();
        return null;
    }

    protected boolean closeZipFile(ZipFile file) {
        try {
            file.close();
        }
        catch (IOException e) {
            this.displayErrorDialog(PluginMessages.format("ZipImport.couldNotClose", new Object[]{file.getName()}));
            return false;
        }
        return true;
    }

    protected void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.sourceNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.sourceNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.sourceNameField.select(selectionIndex);
        }
    }

    private void updateFromSourceField() {
        this.setSourceName(this.sourceNameField.getText());
        this.updateWidgetEnablements();
    }

    protected void createRootDirectoryGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        new Label(sourceContainerGroup, 0).setText(PluginMessages.getString("Import.rootLabelText"));
        this.sourceNameField = new Combo(sourceContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IaikImportWizardPage.this.updateFromSourceField();
            }
        });
        this.sourceNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                IaikImportWizardPage.this.entryChanged = true;
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.sourceNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (IaikImportWizardPage.this.entryChanged) {
                    IaikImportWizardPage.this.entryChanged = false;
                    IaikImportWizardPage.this.updateFromSourceField();
                }
            }
        });
        this.sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.sourceBrowseButton.setText(PluginMessages.getString("Import.browse"));
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
    }

    protected void createSourceGroup(Composite parent) {
        this.createRootDirectoryGroup(parent);
    }

    public void createControl(Composite parent) {
        super.setDescription(PAGE_DESCRIPTION);
        super.setPageComplete(false);
        super.setTitle(PAGE_MESSAGE);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        this.createSourceGroup(composite);
        this.setControl((Control)composite);
    }

    public void displayErrorMessage(String message) {
        this.displayErrorDialog(message);
    }
}

