/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.debugExtensionPlugin;

import com.sap.ide.eclipse.debugExtensionPlugin.DebugSourceLocatorListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.ui.JavaUISourceLocator;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.launching.sourcelookup.IJavaSourceLocation;
import org.eclipse.ui.IEditorInput;

public class DebugSourceLocator
implements IPersistableSourceLocator,
ISourcePresentation {
    private static DelegatingModelPresentation fPresentation = new DelegatingModelPresentation();
    private JavaUISourceLocator javaSourceLocator;
    private Object sourceElement;
    private ArrayList debugSourceLocatorListeners;

    public DebugSourceLocator(ISourceLocator sourceLocator, ArrayList listeners) {
        this.javaSourceLocator = (JavaUISourceLocator)sourceLocator;
        this.debugSourceLocatorListeners = listeners;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        Iterator iter = ((AbstractList)this.debugSourceLocatorListeners).iterator();
        while (iter.hasNext()) {
            DebugSourceLocatorListener listener = (DebugSourceLocatorListener)iter.next();
            Object result = listener.getSourceElement(stackFrame);
            if (result == null) continue;
            return result;
        }
        this.sourceElement = this.javaSourceLocator.getSourceElement(stackFrame);
        return this.sourceElement;
    }

    public IEditorInput getEditorInput(Object element) {
        Iterator iter = ((AbstractList)this.debugSourceLocatorListeners).iterator();
        while (iter.hasNext()) {
            DebugSourceLocatorListener listener = (DebugSourceLocatorListener)iter.next();
            IEditorInput inp = listener.getEditorInput(element);
            if (inp == null) continue;
            return inp;
        }
        IEditorInput input = null;
        try {
            input = EditorUtility.getEditorInput((Object)element);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return input;
    }

    public String getEditorId(IEditorInput input, Object element) {
        Iterator iter = ((AbstractList)this.debugSourceLocatorListeners).iterator();
        while (iter.hasNext()) {
            DebugSourceLocatorListener listener = (DebugSourceLocatorListener)iter.next();
            String id = listener.getEditorId(input, element);
            if (id == null) continue;
            return id;
        }
        return fPresentation.getEditorId(input, element);
    }

    public String getMemento() throws CoreException {
        return this.javaSourceLocator.getMemento();
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.javaSourceLocator.initializeDefaults(configuration);
    }

    public void initializeFromMemento(String memento) throws CoreException {
        this.javaSourceLocator.initializeFromMemento(memento);
    }

    public IJavaSourceLocation[] getSourceLocations() {
        return this.javaSourceLocator.getSourceLocations();
    }

    public void setSourceLocations(IJavaSourceLocation[] locations) {
        this.javaSourceLocator.setSourceLocations(locations);
    }
}

