/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.debugExtensionPlugin;

import com.sap.ide.eclipse.debugExtensionPlugin.DebugSourceLocator;
import com.sap.ide.eclipse.debugExtensionPlugin.DebugSourceLocatorListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DebugExtensionPlugin
extends AbstractUIPlugin
implements IStartup {
    private static DebugExtensionPlugin plugin;
    private ArrayList debugSourceLocatorListeners;
    private DebugListener debugListener;

    public DebugExtensionPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static DebugExtensionPlugin getDefault() {
        return plugin;
    }

    public void earlyStartup() {
    }

    public void addDebugSourceLocatorListener(DebugSourceLocatorListener listener) {
        this.installDebugListener();
        if (!this.debugSourceLocatorListeners.contains(listener)) {
            this.debugSourceLocatorListeners.add(listener);
        }
    }

    public void removeDebugSourceLocatorListener(DebugSourceLocatorListener listener) {
        if (this.debugSourceLocatorListeners != null) {
            ((AbstractCollection)this.debugSourceLocatorListeners).remove(listener);
        }
    }

    public void installDebugListener() {
        if (this.debugListener == null) {
            this.debugListener = new DebugListener();
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this.debugListener);
            if (this.debugSourceLocatorListeners == null) {
                this.debugSourceLocatorListeners = new ArrayList();
            }
        }
    }

    class DebugListener
    implements IDebugEventSetListener {
        DebugListener() {
        }

        public void handleDebugEvents(DebugEvent[] debugEvents) {
            ISourceLocator javaLocator;
            ILaunch[] launches;
            if (!DebugExtensionPlugin.this.debugSourceLocatorListeners.isEmpty() && (launches = DebugPlugin.getDefault().getLaunchManager().getLaunches()).length != 0 && (javaLocator = launches[launches.length - 1].getSourceLocator()) != null && !(javaLocator instanceof DebugSourceLocator)) {
                DebugSourceLocator sourceLocator = new DebugSourceLocator(javaLocator, DebugExtensionPlugin.this.debugSourceLocatorListeners);
                launches[launches.length - 1].setSourceLocator((ISourceLocator)sourceLocator);
            }
        }
    }
}

