/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode.visitors;

import com.sap.tools.webdynpro.bytecode.CPItem;
import com.sap.tools.webdynpro.bytecode.ClassFile;
import com.sap.tools.webdynpro.bytecode.FieldInfo;
import com.sap.tools.webdynpro.bytecode.Instruction;
import com.sap.tools.webdynpro.bytecode.MethodInfo;
import com.sap.tools.webdynpro.bytecode.attributes.CodeAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.ConstantValueAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.DeprecatedAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.ExceptionsAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.InnerClassesAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.LineNumberTableAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.LocalVariableTableAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.SourceFileAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.SyntheticAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.UnknownAttribute;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Class_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_FieldRefInfo;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_InterfaceMethodRefInfo;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_MethodRefInfo;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_NameAndType_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_String_Info;
import com.sap.tools.webdynpro.bytecode.visitors.DefaultVisitor;

public class CPRenumberingVisitor
extends DefaultVisitor {
    private int[] renumber;

    private int renumber(int i) {
        if (this.renumber[i] < 0) {
            throw new RuntimeException();
        }
        return this.renumber[i];
    }

    public Object visit(ClassFile cf, Object data) {
        if (!(data instanceof int[])) {
            throw new IllegalArgumentException("parameter data must be an int array");
        }
        this.renumber = (int[])data;
        cf.setThisClassIndex(this.renumber(cf.getThisClassIndex()));
        cf.setSuperClassIndex(this.renumber(cf.getSuperClassIndex()));
        int i = 0;
        while (i < cf.getInterfacesCount()) {
            cf.setInterfaceIndex(i, this.renumber(cf.getInterfaceIndex(i)));
            ++i;
        }
        return cf.letChildrenAccept(this, data);
    }

    public Object visit(CodeAttribute code, Object data) {
        code.setAttributeNameIndex(this.renumber(code.getAttributeNameIndex()));
        int i = 0;
        while (i < code.getExceptionTableCount()) {
            code.getExceptionTable(i).setCatchType(this.renumber(code.getExceptionTable(i).getCatchType()));
            ++i;
        }
        return code.letChildrenAccept(this, data);
    }

    public Object visit(CPItem cp_item, Object data) {
        switch (cp_item.type()) {
            case 7: {
                ((CONST_Class_Info)cp_item).setNameIndex(this.renumber(((CONST_Class_Info)cp_item).getNameIndex()));
                break;
            }
            case 9: {
                ((CONST_FieldRefInfo)cp_item).setClassIndex(this.renumber(((CONST_FieldRefInfo)cp_item).getClassIndex()));
                ((CONST_FieldRefInfo)cp_item).setNameAndTypeIndex(this.renumber(((CONST_FieldRefInfo)cp_item).getNameAndTypeIndex()));
                break;
            }
            case 10: {
                ((CONST_MethodRefInfo)cp_item).setClassIndex(this.renumber(((CONST_MethodRefInfo)cp_item).getClassIndex()));
                ((CONST_MethodRefInfo)cp_item).setNameAndTypeIndex(this.renumber(((CONST_MethodRefInfo)cp_item).getNameAndTypeIndex()));
                break;
            }
            case 11: {
                ((CONST_InterfaceMethodRefInfo)cp_item).setClassIndex(this.renumber(((CONST_InterfaceMethodRefInfo)cp_item).getClassIndex()));
                ((CONST_InterfaceMethodRefInfo)cp_item).setNameAndTypeIndex(this.renumber(((CONST_InterfaceMethodRefInfo)cp_item).getNameAndTypeIndex()));
                break;
            }
            case 8: {
                ((CONST_String_Info)cp_item).setStringIndex(this.renumber(((CONST_String_Info)cp_item).getStringIndex()));
                break;
            }
            case 12: {
                ((CONST_NameAndType_Info)cp_item).setNameIndex(this.renumber(((CONST_NameAndType_Info)cp_item).getNameIndex()));
                ((CONST_NameAndType_Info)cp_item).setDescriptorIndex(this.renumber(((CONST_NameAndType_Info)cp_item).getDescriptorIndex()));
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new RuntimeException("unexpected cpool type " + cp_item.type());
            }
        }
        return cp_item.letChildrenAccept(this, data);
    }

    public Object visit(FieldInfo field, Object data) {
        field.setNameIndex(this.renumber(field.getNameIndex()));
        field.setDescriptorIndex(this.renumber(field.getDescriptorIndex()));
        return field.letChildrenAccept(this, data);
    }

    public Object visit(MethodInfo method, Object data) {
        method.setNameIndex(this.renumber(method.getNameIndex()));
        method.setDescriptorIndex(this.renumber(method.getDescriptorIndex()));
        return method.letChildrenAccept(this, data);
    }

    public Object visit(InnerClassesAttribute innerClasses, Object data) {
        innerClasses.setAttributeNameIndex(this.renumber(innerClasses.getAttributeNameIndex()));
        int i = 0;
        while (i < innerClasses.getClasses().length) {
            InnerClassesAttribute.InnerClassInfo ici = innerClasses.getClasses()[i];
            ici.setInnerClassInfoIndex(this.renumber(ici.getInnerClassInfoIndex()));
            ici.setOuterClassInfoIndex(this.renumber(ici.getOuterClassInfoIndex()));
            ici.setInnerNameIndex(this.renumber(ici.getInnerNameIndex()));
            ++i;
        }
        return innerClasses.letChildrenAccept(this, data);
    }

    public Object visit(Instruction code, Object data) {
        if (code.isOperand1AConstant()) {
            code.setOperand1Index(this.renumber(code.getOperand1()));
        }
        return code.letChildrenAccept(this, data);
    }

    public Object visit(UnknownAttribute any, Object data) {
        any.setAttributeNameIndex(this.renumber(any.getAttributeNameIndex()));
        if (any.getAttributeLength() > 0) {
            throw new RuntimeException("can't determine reachability: unknown attribute " + any);
        }
        return any.letChildrenAccept(this, data);
    }

    public Object visit(ConstantValueAttribute constValue, Object data) {
        constValue.setAttributeNameIndex(this.renumber(constValue.getAttributeNameIndex()));
        constValue.setConstantValueIndex(this.renumber(constValue.getConstantValueIndex()));
        return constValue.letChildrenAccept(this, data);
    }

    public Object visit(ExceptionsAttribute exceptions, Object data) {
        exceptions.setAttributeNameIndex(this.renumber(exceptions.getAttributeNameIndex()));
        int[] exceptionIndex = exceptions.getExceptionIndexes();
        int i = 0;
        while (i < exceptionIndex.length) {
            exceptionIndex[i] = this.renumber(exceptionIndex[i]);
            ++i;
        }
        return exceptions.letChildrenAccept(this, data);
    }

    public Object visit(LineNumberTableAttribute lineTable, Object data) {
        lineTable.setAttributeNameIndex(this.renumber(lineTable.getAttributeNameIndex()));
        return lineTable.letChildrenAccept(this, data);
    }

    public Object visit(LocalVariableTableAttribute locVarTable, Object data) {
        locVarTable.setAttributeNameIndex(this.renumber(locVarTable.getAttributeNameIndex()));
        int i = 0;
        while (i < locVarTable.getLocalVariables().length) {
            locVarTable.getLocalVariables()[i].setNameIndex(this.renumber(locVarTable.getLocalVariables()[i].getNameIndex()));
            locVarTable.getLocalVariables()[i].setDescriptorIndex(this.renumber(locVarTable.getLocalVariables()[i].getDescriptorIndex()));
            ++i;
        }
        return locVarTable.letChildrenAccept(this, data);
    }

    public Object visit(SourceFileAttribute attr, Object data) {
        attr.setAttributeNameIndex(this.renumber(attr.getAttributeNameIndex()));
        attr.setSourceFileIndex(this.renumber(attr.getSourceFileIndex()));
        return attr.letChildrenAccept(this, data);
    }

    public Object visit(DeprecatedAttribute attr, Object data) {
        attr.setAttributeNameIndex(this.renumber(attr.getAttributeNameIndex()));
        return attr.letChildrenAccept(this, data);
    }

    public Object visit(SyntheticAttribute attr, Object data) {
        attr.setAttributeNameIndex(this.renumber(attr.getAttributeNameIndex()));
        return attr.letChildrenAccept(this, data);
    }
}

