/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode.visitors;

import com.sap.tools.webdynpro.bytecode.CPItem;
import com.sap.tools.webdynpro.bytecode.ClassFile;
import com.sap.tools.webdynpro.bytecode.Instruction;
import com.sap.tools.webdynpro.bytecode.MemberInfo;
import com.sap.tools.webdynpro.bytecode.attributes.CodeAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.ConstantValueAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.DeprecatedAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.ExceptionsAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.InnerClassesAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.LineNumberTableAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.LocalVariableTableAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.SourceFileAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.SyntheticAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.UnknownAttribute;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Class_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Double_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Float_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Integer_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Long_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_MemberRefInfo;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_NameAndType_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_String_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Utf8_Info;
import com.sap.tools.webdynpro.bytecode.visitors.DefaultVisitor;
import java.util.BitSet;

public class CPReachabilityVisitor
extends DefaultVisitor {
    private final CPItem[] cpool;
    private final BitSet reached;

    public CPReachabilityVisitor(ClassFile clazz) {
        this.cpool = clazz.getConstantPool();
        this.reached = new BitSet(this.cpool.length);
        this.reached.set(0);
    }

    public BitSet getReached() {
        return this.reached;
    }

    public boolean isReached(int index) {
        return this.reached.get(index);
    }

    private boolean reached(int index) {
        if (!this.reached.get(index)) {
            this.reached.set(index);
            CPItem info = this.cpool[index];
            if (info != null) {
                info.accept(this, null);
                return true;
            }
        }
        return false;
    }

    public Object visit(ClassFile cf, Object data) {
        this.reached(cf.getThisClassIndex());
        this.reached(cf.getSuperClassIndex());
        int i = 0;
        while (i < cf.getInterfacesCount()) {
            this.reached(cf.getInterfaceIndex(i));
            ++i;
        }
        cf.letChildrenAccept(this, data, false, true, true, true);
        InnerClassesAttribute ica = (InnerClassesAttribute)cf.getAttribute("InnerClasses");
        if (ica != null) {
            this.postProcess(ica);
        }
        return this.reached;
    }

    public Object visit(CONST_Class_Info clazz, Object data) {
        this.reached(clazz.getNameIndex());
        return clazz.letChildrenAccept(this, data);
    }

    public Object visit(CONST_Double_Info item, Object data) {
        this.reached.set(item.getIndex() + 1);
        return item.letChildrenAccept(this, data);
    }

    protected Object visit(CONST_MemberRefInfo ref, Object data) {
        this.reached(ref.getClassIndex());
        this.reached(ref.getNameAndTypeIndex());
        return ref.letChildrenAccept(this, data);
    }

    public Object visit(CONST_Float_Info item, Object data) {
        return item.letChildrenAccept(this, data);
    }

    public Object visit(CONST_Integer_Info item, Object data) {
        return item.letChildrenAccept(this, data);
    }

    public Object visit(CONST_Long_Info item, Object data) {
        this.reached.set(item.getIndex() + 1);
        return item.letChildrenAccept(this, data);
    }

    public Object visit(CONST_NameAndType_Info nt, Object data) {
        this.reached(nt.getNameIndex());
        this.reached(nt.getDescriptorIndex());
        return nt.letChildrenAccept(this, data);
    }

    public Object visit(CONST_String_Info str, Object data) {
        this.reached(str.getStringIndex());
        return str.letChildrenAccept(this, data);
    }

    public Object visit(CONST_Utf8_Info utf8, Object data) {
        return utf8.letChildrenAccept(this, data);
    }

    public Object visit(CodeAttribute code, Object data) {
        this.reached(code.getAttributeNameIndex());
        int i = 0;
        while (i < code.getExceptionTableCount()) {
            this.reached(code.getExceptionTable(i).getCatchType());
            ++i;
        }
        return code.letChildrenAccept(this, data);
    }

    protected Object visit(MemberInfo member, Object data) {
        this.reached(member.getNameIndex());
        this.reached(member.getDescriptorIndex());
        return member.letChildrenAccept(this, data);
    }

    public Object visit(InnerClassesAttribute innerClasses, Object data) {
        return innerClasses.letChildrenAccept(this, data);
    }

    protected void postProcess(InnerClassesAttribute innerClasses) {
        InnerClassesAttribute.InnerClassInfo[] classes = innerClasses.getClasses();
        BitSet requiredEntries = new BitSet(classes.length);
        boolean reachabilityChanged = true;
        do {
            reachabilityChanged = false;
            int i = 0;
            while (i < classes.length) {
                InnerClassesAttribute.InnerClassInfo ici = classes[i];
                if (!requiredEntries.get(i) && ici.isRequired(this.reached)) {
                    if (this.reached(ici.getInnerClassInfoIndex())) {
                        reachabilityChanged = true;
                    }
                    if (this.reached(ici.getOuterClassInfoIndex())) {
                        reachabilityChanged = true;
                    }
                    if (this.reached(ici.getInnerNameIndex())) {
                        reachabilityChanged = true;
                    }
                    requiredEntries.set(i);
                }
                ++i;
            }
        } while (reachabilityChanged);
        if (requiredEntries.length() > 0) {
            this.reached(innerClasses.getAttributeNameIndex());
        }
    }

    public Object visit(Instruction code, Object data) {
        if (code.getOperand1AsConstant() != null) {
            this.reached(code.getOperand1());
        }
        return code.letChildrenAccept(this, data);
    }

    public Object visit(UnknownAttribute any, Object data) {
        this.reached(any.getAttributeNameIndex());
        if (any.getAttributeLength() > 0) {
            throw new RuntimeException("can't determine reachability: unknown attribute " + any);
        }
        return any.letChildrenAccept(this, data);
    }

    public Object visit(ConstantValueAttribute constValue, Object data) {
        this.reached(constValue.getAttributeNameIndex());
        this.reached(constValue.getConstantValueIndex());
        return constValue.letChildrenAccept(this, data);
    }

    public Object visit(ExceptionsAttribute exceptions, Object data) {
        this.reached(exceptions.getAttributeNameIndex());
        int[] exceptionIndex = exceptions.getExceptionIndexes();
        int i = 0;
        while (i < exceptionIndex.length) {
            this.reached(exceptionIndex[i]);
            ++i;
        }
        return exceptions.letChildrenAccept(this, data);
    }

    public Object visit(LineNumberTableAttribute lineTable, Object data) {
        this.reached(lineTable.getAttributeNameIndex());
        return lineTable.letChildrenAccept(this, data);
    }

    public Object visit(LocalVariableTableAttribute locVarTable, Object data) {
        this.reached(locVarTable.getAttributeNameIndex());
        int i = 0;
        while (i < locVarTable.getLocalVariables().length) {
            this.reached(locVarTable.getLocalVariables()[i].getNameIndex());
            this.reached(locVarTable.getLocalVariables()[i].getDescriptorIndex());
            ++i;
        }
        return locVarTable.letChildrenAccept(this, data);
    }

    public Object visit(SourceFileAttribute attr, Object data) {
        this.reached(attr.getAttributeNameIndex());
        this.reached(attr.getSourceFileIndex());
        return attr.letChildrenAccept(this, data);
    }

    public Object visit(DeprecatedAttribute attr, Object data) {
        this.reached(attr.getAttributeNameIndex());
        return attr.letChildrenAccept(this, data);
    }

    public Object visit(SyntheticAttribute attr, Object data) {
        this.reached(attr.getAttributeNameIndex());
        return attr.letChildrenAccept(this, data);
    }
}

