/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode.util;

import com.sap.tools.webdynpro.bytecode.ClassFile;
import com.sap.tools.webdynpro.bytecode.ClassFileElementFactory;
import com.sap.tools.webdynpro.bytecode.ClassFileLoader;
import com.sap.tools.webdynpro.bytecode.ClassFileNotFoundException;
import com.sap.tools.webdynpro.bytecode.util.ClasspathScanner;
import com.sap.tools.webdynpro.bytecode.util.StringUtil;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;

public class URLClassFileLoader
extends ClassFileLoader {
    private final String classpath;
    private static String[] NO_TYPES = new String[0];
    private static String[] ALL_TYPES = new String[]{"**/*.class"};

    private static Object[] createClassLoaderInfo(String classpath, ClassFileLoader parent, ClassFileElementFactory factory) {
        if (factory == null) {
            factory = parent != null ? parent.getFactory() : new ClassFileLoader.DefaultFactory();
        }
        if (parent == null) {
            parent = ClassFileLoader.createSystemClassFileLoader(factory);
        }
        String[] paths = StringUtil.divide(classpath, ";", true);
        ArrayList<URL> urlList = new ArrayList<URL>();
        try {
            int i = 0;
            while (i < paths.length) {
                if (!StringUtil.isEmpty(paths[i])) {
                    urlList.add(new File(paths[i]).toURL());
                }
                ++i;
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage());
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        Object[] result = new Object[]{new MyURLClassLoader(urls, parent.getClassLoader()), parent, factory, classpath};
        return result;
    }

    private URLClassFileLoader(Object[] info) {
        super((ClassLoader)info[0], (ClassFileLoader)info[1], (ClassFileElementFactory)info[2]);
        this.classpath = (String)info[3];
    }

    public URLClassFileLoader(String classpath, ClassFileLoader parent, ClassFileElementFactory factory) {
        this(URLClassFileLoader.createClassLoaderInfo(classpath, parent, factory));
    }

    public URLClassFileLoader(String classpath) {
        this(classpath, null, null);
    }

    public Collection getClassNames() {
        ClasspathScanner cpScanner = new ClasspathScanner(this.classpath);
        cpScanner.scan(ALL_TYPES, NO_TYPES);
        return cpScanner.getClassNames();
    }

    public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        if (this.getClassLoader() instanceof MyURLClassLoader) {
            return ((MyURLClassLoader)this.getClassLoader()).loadClass(className, resolve);
        }
        throw new UnsupportedOperationException();
    }

    public String getClasspath() {
        return this.classpath;
    }

    public String toString() {
        return "URLClassFileLoader@" + Integer.toHexString(System.identityHashCode(this)) + "[" + this.classpath + "]";
    }

    public ClassFile loadClassFile(File fileName) {
        try {
            FileInputStream in = new FileInputStream(fileName);
            ClassFile cf = this.getFactory().createClassFile(this);
            cf.read(new DataInputStream(in));
            return cf;
        }
        catch (IOException e) {
            throw new ClassFileNotFoundException("error while loading class from file '" + fileName + "'", e);
        }
    }

    private static class MyURLClassLoader
    extends URLClassLoader {
        private MyURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(className, resolve);
        }
    }
}

