/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode.util;

public abstract class StringUtil {
    public static final String concat(String[] strings, String separator) {
        if (strings == null) {
            return null;
        }
        return StringUtil.concat(strings, separator, strings.length);
    }

    public static final String concat(String[] strings, String separator, int length) {
        if (strings == null) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        if (strings.length < length) {
            throw new IllegalArgumentException("length larger than array size");
        }
        int size = (length - 1) * separator.length();
        int i = 0;
        while (i < length) {
            size += strings[i].length();
            ++i;
        }
        StringBuffer buffer = new StringBuffer(size);
        int i2 = 0;
        while (i2 < length) {
            if (i2 > 0) {
                buffer.append(separator);
            }
            buffer.append(strings[i2]);
            ++i2;
        }
        return buffer.toString();
    }

    public static final boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static final String[] divide(String text, String separator) {
        return StringUtil.divide(text, separator, true);
    }

    public static final String[] divide(String text, String separator, boolean trim) {
        if (StringUtil.isEmpty(separator)) {
            throw new IllegalArgumentException();
        }
        if (StringUtil.isEmpty(text)) {
            return new String[0];
        }
        int separators = 0;
        int i = 0;
        while (i < text.length()) {
            if (text.startsWith(separator, i)) {
                ++separators;
                i += separator.length();
                continue;
            }
            ++i;
        }
        String[] array = new String[separators + 1];
        int offset = 0;
        int i2 = 0;
        while (i2 < separators) {
            int index = text.indexOf(separator, offset);
            array[i2] = text.substring(offset, index);
            if (trim) {
                array[i2] = array[i2].trim();
            }
            offset = index + separator.length();
            ++i2;
        }
        array[separators] = text.substring(offset);
        if (trim) {
            array[separators] = array[separators].trim();
        }
        return array;
    }

    public static final String getQualifiedClassName(String packageName, String unqualifiedClassName) {
        if (packageName == null || "".equals(packageName)) {
            return unqualifiedClassName;
        }
        return packageName + "." + unqualifiedClassName;
    }

    public static final String getUnqualifiedClassName(Class clazz) {
        return StringUtil.getUnqualifiedClassName(clazz.getName());
    }

    public static final String getUnqualifiedClassName(String fullClassName) {
        int index = fullClassName.lastIndexOf(46);
        return index < 0 ? fullClassName : fullClassName.substring(index + 1);
    }

    public static final String getPackageName(Class clazz) {
        return StringUtil.getPackageName(clazz.getName());
    }

    public static final String getPackageName(String fullClassName) {
        int index = fullClassName.lastIndexOf(46);
        return index < 0 ? "" : fullClassName.substring(0, index);
    }

    public static final String capitalize(String str) {
        if (StringUtil.isEmpty(str) || Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static final String decapitalize(String str) {
        if (StringUtil.isEmpty(str) || Character.isLowerCase(str.charAt(0))) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }
}

