/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode.util;

import com.sap.tools.webdynpro.bytecode.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.ZipScanner;

public class ClasspathScanner {
    private Set allNames;
    private final String[] cpEntries;
    private final DirectoryScanner[] scanners;
    private final File[] basedirs;

    public ClasspathScanner(String cp) {
        this.cpEntries = StringUtil.divide(cp, ";");
        ArrayList<Object> tmpScanners = new ArrayList<Object>();
        ArrayList<File> tmpBasedirs = new ArrayList<File>();
        int i = 0;
        while (i < this.cpEntries.length) {
            File cpEntry = new File(this.cpEntries[i]);
            if (cpEntry.isDirectory()) {
                DirectoryScanner ds = new DirectoryScanner();
                ds.setBasedir(cpEntry);
                tmpScanners.add(ds);
                tmpBasedirs.add(cpEntry);
            } else if (cpEntry.canRead()) {
                ZipScanner zs = new ZipScanner();
                zs.setBasedir(new File("."));
                zs.setSrc(cpEntry);
                tmpScanners.add(zs);
                tmpBasedirs.add(null);
            }
            ++i;
        }
        this.scanners = tmpScanners.toArray(new DirectoryScanner[tmpScanners.size()]);
        this.basedirs = tmpBasedirs.toArray(new File[tmpBasedirs.size()]);
    }

    public void scan(String[] includes, String[] excludes) {
        this.allNames = new TreeSet();
        int i = 0;
        while (i < this.scanners.length) {
            this.scanners[i].setIncludes(includes);
            this.scanners[i].setExcludes(excludes);
            if (!(this.scanners[i] instanceof ZipScanner)) {
                this.scanners[i].scan();
            }
            this.allNames.addAll(Arrays.asList(this.scanners[i].getIncludedFiles()));
            ++i;
        }
    }

    public String toString() {
        return this.allNames.toString();
    }

    public Collection getClassNames() {
        ArrayList<String> names = new ArrayList<String>(this.allNames.size());
        Iterator iter = this.allNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (name.endsWith(".class")) {
                name = name.substring(0, name.length() - ".class".length());
            }
            name = name.replace('/', '.');
            name = name.replace('\\', '.');
            names.add(name);
        }
        return names;
    }

    public File getFileName(String className) {
        String fileName = className.replace('.', '/') + ".java";
        int i = 0;
        while (i < this.basedirs.length) {
            File f;
            if (this.basedirs[i] != null && (f = new File(this.basedirs[i], fileName)).canRead()) {
                return f;
            }
            ++i;
        }
        return null;
    }

    public long getFileSize(String fileName) {
        int i = 0;
        while (i < this.basedirs.length) {
            File f;
            if (this.basedirs[i] != null && (f = new File(this.basedirs[i], fileName)).canRead()) {
                return f.length();
            }
            ++i;
        }
        return -1L;
    }
}

