/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode.filters;

import java.util.Collection;

public abstract class Filter {
    public abstract boolean accepts(Object var1);

    public static Filter or(Collection filters) {
        return new OrFilter(filters);
    }

    private static class OrFilter
    extends Filter {
        private static final Filter[] NO_FILTERS = new Filter[0];
        private final Filter[] filters;

        OrFilter(Collection filters) {
            this.filters = filters.toArray(NO_FILTERS);
        }

        public boolean accepts(Object o) {
            int i = 0;
            while (i < this.filters.length) {
                if (this.filters[i].accepts(o)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("[");
            int i = 0;
            while (i < this.filters.length) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(this.filters[i]);
                ++i;
            }
            buf.append("]");
            return buf.toString();
        }
    }
}

