/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode.cpitems;

import com.sap.tools.webdynpro.bytecode.CPItem;
import com.sap.tools.webdynpro.bytecode.ClassFile;
import com.sap.tools.webdynpro.bytecode.ClassFileVisitor;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;

public class CONST_Utf8_Info
extends CPItem {
    private int length;
    private byte[] bytes;
    private transient String string = null;

    public CONST_Utf8_Info(ClassFile classFile, int tag) {
        super(classFile, tag);
    }

    public int size() {
        return super.size() + 2 + this.length;
    }

    public void read(DataInput in) throws IOException {
        this.length = in.readUnsignedShort();
        this.bytes = new byte[2 + this.length];
        this.bytes[0] = (byte)(this.length >> 8);
        this.bytes[1] = (byte)(this.length & 0xFF);
        in.readFully(this.bytes, 2, this.length);
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeShort(this.length);
        out.write(this.bytes, 2, this.length);
    }

    public String getString() {
        if (this.string == null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
                DataInputStream dis = new DataInputStream(bais);
                this.string = dis.readUTF();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.string = "";
            }
        }
        return this.string;
    }

    public int getLength() {
        return this.length;
    }

    public Object accept(ClassFileVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        CONST_Utf8_Info other = (CONST_Utf8_Info)o;
        return this.getString().equals(other.getString());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public String toString() {
        return this.getString();
    }
}

