/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode.cpitems;

import com.sap.tools.webdynpro.bytecode.CPItem;
import com.sap.tools.webdynpro.bytecode.ClassFile;
import com.sap.tools.webdynpro.bytecode.ClassFileVisitor;
import com.sap.tools.webdynpro.bytecode.MemberInfo;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Utf8_Info;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CONST_Class_Info
extends CPItem {
    private int nameIndex;
    private transient String className;

    public CONST_Class_Info(ClassFile classFile, int tag) {
        super(classFile, tag);
    }

    public int size() {
        return super.size() + 2;
    }

    public void read(DataInput in) throws IOException {
        this.nameIndex = in.readUnsignedShort();
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeShort(this.nameIndex);
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public CONST_Utf8_Info getName() {
        return (CONST_Utf8_Info)this.getCPItem(this.nameIndex);
    }

    public String getClassName() {
        if (this.className == null) {
            this.className = this.getName().getString();
            if (this.className.startsWith("[")) {
                MemberInfo.Parser p = new MemberInfo.Parser();
                this.className = p.parseFieldDescriptor(this.className);
            }
            this.className = this.className.replace('/', '.');
        }
        return this.className;
    }

    public void setNameIndex(int i) {
        this.nameIndex = i;
    }

    public Object accept(ClassFileVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        CONST_Class_Info other = (CONST_Class_Info)o;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName().getString();
    }
}

