/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode.attributes;

import com.sap.tools.webdynpro.bytecode.AbstractInfo;
import com.sap.tools.webdynpro.bytecode.AttributeInfo;
import com.sap.tools.webdynpro.bytecode.ClassFileVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LocalVariableTableAttribute
extends AttributeInfo {
    public static final String ATTRIBUTE_NAME = "LocalVariableTable";
    private LocalVariable[] localVariables;

    public LocalVariableTableAttribute(AbstractInfo parent, int attribute_name_index) {
        super(parent, attribute_name_index);
    }

    public void read(DataInput in) throws IOException {
        super.read(in);
        int local_variable_length_table = in.readUnsignedShort();
        this.localVariables = new LocalVariable[local_variable_length_table];
        int i = 0;
        while (i < local_variable_length_table) {
            this.localVariables[i] = new LocalVariable();
            this.localVariables[i].startPC = in.readUnsignedShort();
            this.localVariables[i].length = in.readUnsignedShort();
            this.localVariables[i].nameIndex = in.readUnsignedShort();
            this.localVariables[i].descriptorIndex = in.readUnsignedShort();
            this.localVariables[i].index = in.readUnsignedShort();
            ++i;
        }
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeShort(this.localVariables.length);
        int i = 0;
        while (i < this.localVariables.length) {
            out.writeShort(this.localVariables[i].startPC);
            out.writeShort(this.localVariables[i].length);
            out.writeShort(this.localVariables[i].nameIndex);
            out.writeShort(this.localVariables[i].descriptorIndex);
            out.writeShort(this.localVariables[i].index);
            ++i;
        }
    }

    public int sizeOfContent() {
        return 2 + 10 * this.localVariables.length;
    }

    public Object accept(ClassFileVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public LocalVariable[] getLocalVariables() {
        return this.localVariables;
    }

    public static class LocalVariable {
        private int startPC;
        private int length;
        private int nameIndex;
        private int descriptorIndex;
        private int index;

        public int getDescriptorIndex() {
            return this.descriptorIndex;
        }

        public int getIndex() {
            return this.index;
        }

        public int getLength() {
            return this.length;
        }

        public int getNameIndex() {
            return this.nameIndex;
        }

        public int getStartPC() {
            return this.startPC;
        }

        public void setDescriptorIndex(int i) {
            this.descriptorIndex = i;
        }

        public void setIndex(int i) {
            this.index = i;
        }

        public void setLength(int i) {
            this.length = i;
        }

        public void setNameIndex(int i) {
            this.nameIndex = i;
        }

        public void setStartPC(int i) {
            this.startPC = i;
        }
    }
}

