/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode.attributes;

import com.sap.tools.webdynpro.bytecode.AbstractInfo;
import com.sap.tools.webdynpro.bytecode.AttributeInfo;
import com.sap.tools.webdynpro.bytecode.ClassFileVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LineNumberTableAttribute
extends AttributeInfo {
    public static final String ATTRIBUTE_NAME = "LineNumberTable";
    private LineNumberTableEntry[] lineNumberTable;

    public LineNumberTableAttribute(AbstractInfo parent, int attribute_name_index) {
        super(parent, attribute_name_index);
    }

    public int getLineNumberTableLength() {
        return this.lineNumberTable.length;
    }

    public LineNumberTableEntry getLineNumberTable(int index) {
        return this.lineNumberTable[index];
    }

    public int sizeOfContent() {
        return 2 + 4 * this.lineNumberTable.length;
    }

    public void read(DataInput in) throws IOException {
        super.read(in);
        int line_number_table_length = in.readUnsignedShort();
        this.lineNumberTable = new LineNumberTableEntry[line_number_table_length];
        int i = 0;
        while (i < line_number_table_length) {
            this.lineNumberTable[i] = new LineNumberTableEntry();
            this.lineNumberTable[i].startPC = in.readUnsignedShort();
            this.lineNumberTable[i].lineNumber = in.readUnsignedShort();
            ++i;
        }
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeShort(this.lineNumberTable.length);
        int i = 0;
        while (i < this.lineNumberTable.length) {
            out.writeShort(this.lineNumberTable[i].startPC);
            out.writeShort(this.lineNumberTable[i].lineNumber);
            ++i;
        }
    }

    public Object accept(ClassFileVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public static class LineNumberTableEntry {
        private int startPC;
        private int lineNumber;

        public int getStartPC() {
            return this.startPC;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

