/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode.attributes;

import com.sap.tools.webdynpro.bytecode.AbstractInfo;
import com.sap.tools.webdynpro.bytecode.AttributeInfo;
import com.sap.tools.webdynpro.bytecode.ClassFileVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;

public class InnerClassesAttribute
extends AttributeInfo {
    public static final String ATTRIBUTE_NAME = "InnerClasses";
    private InnerClassInfo[] classes;

    public InnerClassesAttribute(AbstractInfo parent, int attribute_name_index) {
        super(parent, attribute_name_index);
    }

    public int sizeOfContent() {
        return 2 + 8 * this.classes.length;
    }

    public void read(DataInput in) throws IOException {
        super.read(in);
        int number_of_classes = in.readUnsignedShort();
        this.classes = new InnerClassInfo[number_of_classes];
        int i = 0;
        while (i < number_of_classes) {
            this.classes[i] = new InnerClassInfo();
            this.classes[i].read(in);
            ++i;
        }
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeShort(this.classes.length);
        int i = 0;
        while (i < this.classes.length) {
            this.classes[i].write(out);
            ++i;
        }
    }

    public Object accept(ClassFileVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public InnerClassInfo[] getClasses() {
        return this.classes;
    }

    public void condense(BitSet reached) {
        int remainingEntries = 0;
        int i = 0;
        while (i < this.classes.length) {
            if (this.classes[i].isRequired(reached)) {
                this.classes[remainingEntries++] = this.classes[i];
            }
            ++i;
        }
        if (remainingEntries > 0) {
            if (remainingEntries < this.classes.length) {
                InnerClassInfo[] oldClasses = this.classes;
                this.classes = new InnerClassInfo[remainingEntries];
                System.arraycopy(oldClasses, 0, this.classes, 0, remainingEntries);
            }
        } else {
            this.getDeclaringClass().removeAttribute(this);
        }
    }

    public final class InnerClassInfo
    extends AbstractInfo {
        private int innerClassInfoIndex;
        private int outerClassInfoIndex;
        private int innerNameIndex;
        private int innerClassAccessFlags;

        InnerClassInfo() {
            super(InnerClassesAttribute.this);
        }

        public Object accept(ClassFileVisitor visitor, Object data) {
            return data;
        }

        public int size() {
            return 8;
        }

        public void read(DataInput in) throws IOException {
            this.innerClassInfoIndex = in.readUnsignedShort();
            this.outerClassInfoIndex = in.readUnsignedShort();
            this.innerNameIndex = in.readUnsignedShort();
            this.innerClassAccessFlags = in.readUnsignedShort();
        }

        public void write(DataOutput out) throws IOException {
            out.writeShort(this.innerClassInfoIndex);
            out.writeShort(this.outerClassInfoIndex);
            out.writeShort(this.innerNameIndex);
            out.writeShort(this.innerClassAccessFlags);
        }

        public int getInnerClassAccessFlags() {
            return this.innerClassAccessFlags;
        }

        public int getInnerClassInfoIndex() {
            return this.innerClassInfoIndex;
        }

        public int getInnerNameIndex() {
            return this.innerNameIndex;
        }

        public int getOuterClassInfoIndex() {
            return this.outerClassInfoIndex;
        }

        public void setInnerClassAccessFlags(int i) {
            this.innerClassAccessFlags = i;
        }

        public void setInnerClassInfoIndex(int i) {
            this.innerClassInfoIndex = i;
        }

        public void setInnerNameIndex(int i) {
            this.innerNameIndex = i;
        }

        public void setOuterClassInfoIndex(int i) {
            this.outerClassInfoIndex = i;
        }

        public boolean isRequired(BitSet reachableCPItems) {
            int this_class = this.getDeclaringClass().getThisClassIndex();
            return this.innerClassInfoIndex == this_class || this.outerClassInfoIndex == this_class || reachableCPItems.get(this.innerClassInfoIndex);
        }
    }
}

