/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode.attributes;

import com.sap.tools.webdynpro.bytecode.AbstractInfo;
import com.sap.tools.webdynpro.bytecode.AttributeInfo;
import com.sap.tools.webdynpro.bytecode.ClassFileVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ExceptionsAttribute
extends AttributeInfo {
    public static final String ATTRIBUTE_NAME = "Exceptions";
    private int[] exceptionIndexes;

    public ExceptionsAttribute(AbstractInfo parent, int attribute_name_index) {
        super(parent, attribute_name_index);
    }

    public void read(DataInput in) throws IOException {
        super.read(in);
        int number_of_exceptions = in.readUnsignedShort();
        this.exceptionIndexes = new int[number_of_exceptions];
        int i = 0;
        while (i < number_of_exceptions) {
            this.exceptionIndexes[i] = in.readUnsignedShort();
            ++i;
        }
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeShort(this.exceptionIndexes.length);
        int i = 0;
        while (i < this.exceptionIndexes.length) {
            out.writeShort(this.exceptionIndexes[i]);
            ++i;
        }
    }

    public int sizeOfContent() {
        return 2 + 2 * this.exceptionIndexes.length;
    }

    public Object accept(ClassFileVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public int[] getExceptionIndexes() {
        return this.exceptionIndexes;
    }

    public int getExceptionIndexesCount() {
        return this.exceptionIndexes.length;
    }
}

