/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode.attributes;

import com.sap.tools.webdynpro.bytecode.AbstractInfo;
import com.sap.tools.webdynpro.bytecode.AttributeInfo;
import com.sap.tools.webdynpro.bytecode.ClassFileVisitor;
import com.sap.tools.webdynpro.bytecode.Instruction;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CodeAttribute
extends AttributeInfo {
    public static final String ATTRIBUTE_NAME = "Code";
    private int maxStack;
    private int maxLocals;
    private byte[] code;
    private Instruction[] instructions;
    private ExceptionTableEntry[] exceptionTable;
    private List attributes;
    private transient Map attributesByName;

    public CodeAttribute(AbstractInfo parent, int attribute_name_index) {
        super(parent, attribute_name_index);
    }

    public int sizeOfContent() {
        int sizeOfContent = 8 + this.code.length + 2 + 8 * this.exceptionTable.length + 2;
        int i = 0;
        while (i < this.getAttributesCount()) {
            sizeOfContent += this.getAttribute(i).size();
            ++i;
        }
        return sizeOfContent;
    }

    public void read(DataInput in) throws IOException {
        super.read(in);
        this.maxStack = in.readUnsignedShort();
        this.maxLocals = in.readUnsignedShort();
        int code_length = in.readInt();
        this.code = new byte[code_length];
        in.readFully(this.code);
        int exceptionTableLength = in.readUnsignedShort();
        this.exceptionTable = new ExceptionTableEntry[exceptionTableLength];
        int i = 0;
        while (i < exceptionTableLength) {
            this.exceptionTable[i] = new ExceptionTableEntry();
            this.exceptionTable[i].startPC = in.readUnsignedShort();
            this.exceptionTable[i].endPC = in.readUnsignedShort();
            this.exceptionTable[i].handlerPC = in.readUnsignedShort();
            this.exceptionTable[i].catchType = in.readUnsignedShort();
            ++i;
        }
        int attributes_count = in.readUnsignedShort();
        this.attributes = new ArrayList(attributes_count);
        int i2 = 0;
        while (i2 < attributes_count) {
            AttributeInfo attribute = AttributeInfo.readAttributeInfo(this, in);
            this.attributes.add(attribute);
            if (this.attributesByName == null) {
                this.attributesByName = new HashMap();
            }
            this.attributesByName.put(attribute.getName(), attribute);
            ++i2;
        }
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeShort(this.maxStack);
        out.writeShort(this.maxLocals);
        out.writeInt(this.code.length);
        out.write(this.code);
        out.writeShort(this.exceptionTable.length);
        int i = 0;
        while (i < this.exceptionTable.length) {
            out.writeShort(this.exceptionTable[i].startPC);
            out.writeShort(this.exceptionTable[i].endPC);
            out.writeShort(this.exceptionTable[i].handlerPC);
            out.writeShort(this.exceptionTable[i].catchType);
            ++i;
        }
        out.writeShort(this.attributes.size());
        int i2 = 0;
        while (i2 < this.attributes.size()) {
            this.getAttribute(i2).write(out);
            ++i2;
        }
    }

    private void ensureInstructions() {
        if (this.instructions == null) {
            try {
                this.instructions = Instruction.readInstructions(this, this.code);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public int getAttributesCount() {
        return this.attributes.size();
    }

    public AttributeInfo getAttribute(int index) {
        return (AttributeInfo)this.attributes.get(index);
    }

    public AttributeInfo getAttribute(String attributeName) {
        if (this.attributesByName == null) {
            return null;
        }
        return (AttributeInfo)this.attributesByName.get(attributeName);
    }

    public void removeAttribute(AttributeInfo attribute) {
        int index = this.attributes.indexOf(attribute);
        this.attributes.remove(index);
        this.attributesByName.remove(attribute.getName());
        this.getDeclaringClass().makeDirty();
    }

    public int getCodeLength() {
        return this.code.length;
    }

    public byte[] getCode() {
        return this.code;
    }

    public int getExceptionTableCount() {
        return this.exceptionTable.length;
    }

    public ExceptionTableEntry getExceptionTable(int index) {
        return this.exceptionTable[index];
    }

    public Object accept(ClassFileVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object letChildrenAccept(ClassFileVisitor visitor, Object data) {
        this.ensureInstructions();
        int i = 0;
        while (i < this.instructions.length) {
            data = this.instructions[i].accept(visitor, data);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.attributes.size()) {
            data = this.getAttribute(i2).accept(visitor, data);
            ++i2;
        }
        return data;
    }

    public class ExceptionTableEntry {
        private int startPC;
        private int endPC;
        private int handlerPC;
        private int catchType;

        public int getCatchType() {
            return this.catchType;
        }

        public void setCatchType(int i) {
            this.catchType = i;
        }
    }
}

