/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode;

import com.sap.tools.webdynpro.bytecode.AbstractInfo;
import com.sap.tools.webdynpro.bytecode.AttributeInfo;
import com.sap.tools.webdynpro.bytecode.ClassFileVisitor;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Utf8_Info;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MemberInfo
extends AbstractInfo {
    private int access_flags;
    private int nameIndex;
    private int descriptorIndex;
    private List attributes;
    private transient Map attributesByName;
    private transient Signature signature;

    public MemberInfo(AbstractInfo parent) {
        super(parent);
    }

    public int getAccessFlags() {
        return this.access_flags;
    }

    public void setAccessFlags(int i) {
        this.access_flags = i;
    }

    public String getDescriptor() {
        return ((CONST_Utf8_Info)this.getCPItem(this.descriptorIndex)).getString();
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public void setDescriptorIndex(int i) {
        this.descriptorIndex = i;
    }

    public String getName() {
        return ((CONST_Utf8_Info)this.getCPItem(this.nameIndex)).getString();
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(int i) {
        this.nameIndex = i;
    }

    public int getAttributesCount() {
        return this.attributes.size();
    }

    public AttributeInfo getAttribute(int index) {
        return (AttributeInfo)this.attributes.get(index);
    }

    public AttributeInfo getAttribute(String attributeName) {
        if (this.attributesByName == null) {
            return null;
        }
        return (AttributeInfo)this.attributesByName.get(attributeName);
    }

    public int size() {
        int size = 8;
        int i = 0;
        while (i < this.attributes.size()) {
            size += this.getAttribute(i).size();
            ++i;
        }
        return size;
    }

    public void read(DataInput in) throws IOException {
        this.access_flags = in.readUnsignedShort();
        this.nameIndex = in.readUnsignedShort();
        this.descriptorIndex = in.readUnsignedShort();
        int attributes_count = in.readUnsignedShort();
        this.attributes = new ArrayList(attributes_count);
        int i = 0;
        while (i < attributes_count) {
            AttributeInfo attribute = AttributeInfo.readAttributeInfo(this, in);
            this.attributes.add(attribute);
            if (this.attributesByName == null) {
                this.attributesByName = new HashMap();
            }
            this.attributesByName.put(attribute.getName(), attribute);
            ++i;
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeShort(this.access_flags);
        out.writeShort(this.nameIndex);
        out.writeShort(this.descriptorIndex);
        out.writeShort(this.attributes.size());
        int i = 0;
        while (i < this.attributes.size()) {
            this.getAttribute(i).write(out);
            ++i;
        }
    }

    public Object letChildrenAccept(ClassFileVisitor visitor, Object data) {
        int i = 0;
        while (i < this.attributes.size()) {
            data = this.getAttribute(i).accept(visitor, data);
            ++i;
        }
        return data;
    }

    public Signature getSignature() {
        if (this.signature == null) {
            this.signature = new Signature(this.getName(), this.getDescriptor());
        }
        return this.signature;
    }

    public static class Parser {
        int p = 0;
        int l;
        int c;
        String str;

        private void init(String data) {
            this.p = 0;
            this.l = data.length();
            this.str = data;
        }

        private void next() {
            if (this.p < this.l) {
                this.c = this.str.charAt(this.p++);
                return;
            }
            this.c = -1;
        }

        private String parseFieldType() {
            String dimensions = "";
            while (this.c == 91) {
                dimensions = dimensions + "[]";
                this.next();
            }
            switch (this.c) {
                case 66: {
                    this.next();
                    return "byte" + dimensions;
                }
                case 67: {
                    this.next();
                    return "char" + dimensions;
                }
                case 68: {
                    this.next();
                    return "double" + dimensions;
                }
                case 70: {
                    this.next();
                    return "float" + dimensions;
                }
                case 73: {
                    this.next();
                    return "int" + dimensions;
                }
                case 74: {
                    this.next();
                    return "long" + dimensions;
                }
                case 76: {
                    int p2 = this.str.indexOf(59, this.p);
                    if (p2 < 0) {
                        throw new RuntimeException("no ';' found after " + this.p + " in '" + this.str + "'");
                    }
                    String type = this.str.substring(this.p, p2);
                    this.p = p2 + 1;
                    this.next();
                    return type + dimensions;
                }
                case 83: {
                    this.next();
                    return "short" + dimensions;
                }
                case 90: {
                    this.next();
                    return "boolean" + dimensions;
                }
            }
            throw new RuntimeException("unexpected type char '" + (char)this.c + "' at position in descriptor " + this.p + " in '" + this.str + "'");
        }

        public String parseFieldDescriptor(String descriptor) {
            this.init(descriptor);
            this.next();
            return this.parseFieldType();
        }

        public String[] parseMethodDescriptor(String descriptor) {
            this.init(descriptor);
            ArrayList<String> args = new ArrayList<String>();
            this.next();
            if (this.c != 40) {
                throw new RuntimeException();
            }
            this.next();
            while (this.c != 41) {
                args.add(this.parseFieldType());
            }
            this.next();
            if (this.c == 86) {
                args.add(null);
            } else {
                args.add(this.parseFieldType());
            }
            return args.toArray(new String[args.size()]);
        }
    }

    public static final class Signature {
        private final String name;
        private final String descriptor;

        public Signature(String name, String descriptor) {
            if (name == null || descriptor == null) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            this.descriptor = descriptor;
        }

        public String getName() {
            return this.name;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.descriptor.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Signature other = (Signature)obj;
            return this.name.equals(other.name) && this.descriptor.equals(other.descriptor);
        }

        public String toString() {
            return this.name + " " + this.descriptor;
        }

        public String toExternal() {
            StringBuffer buf = new StringBuffer();
            Parser p = new Parser();
            if (this.descriptor.indexOf(40) >= 0) {
                String[] args = p.parseMethodDescriptor(this.descriptor);
                if (args[args.length - 1] == null) {
                    buf.append("void");
                } else {
                    buf.append(args[args.length - 1].replace('/', '.'));
                }
                buf.append(' ').append(this.name).append('(');
                int i = 0;
                while (i < args.length - 1) {
                    buf.append(args[i].replace('/', '.'));
                    if (i < args.length - 2) {
                        buf.append(',');
                    }
                    ++i;
                }
                buf.append(')');
            } else {
                String type = p.parseFieldDescriptor(this.descriptor);
                buf.append(type.replace('/', '.'));
                buf.append(' ').append(this.name);
            }
            return buf.toString();
        }
    }
}

