/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode;

import com.sap.tools.webdynpro.bytecode.AbstractInfo;
import com.sap.tools.webdynpro.bytecode.CPItem;
import com.sap.tools.webdynpro.bytecode.ClassFileElementFactory;
import com.sap.tools.webdynpro.bytecode.ClassFileVisitor;
import com.sap.tools.webdynpro.bytecode.attributes.CodeAttribute;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class Instruction
extends AbstractInfo {
    private boolean isWide = false;
    private int size = 1;
    private int offset;
    private Operation operation;
    private int operand1;
    private int operand2;

    protected Instruction(CodeAttribute parent) {
        super(parent);
    }

    public int size() {
        return this.size;
    }

    private int readOperand(OperandInfo operand, DataInput in, boolean isWide) throws IOException {
        int opSize = operand.size;
        if (isWide) {
            opSize *= 2;
        }
        this.size += opSize;
        switch (operand.type) {
            case 1: 
            case 3: 
            case 6: {
                if (opSize == 1) {
                    return in.readUnsignedByte();
                }
                if (opSize == 2) {
                    return in.readUnsignedShort();
                }
                if (opSize == 4) {
                    return in.readInt();
                }
                throw new RuntimeException();
            }
            case 2: 
            case 4: {
                if (opSize == 1) {
                    return in.readByte();
                }
                if (opSize == 2) {
                    return in.readShort();
                }
                if (opSize == 4) {
                    return in.readInt();
                }
                throw new RuntimeException();
            }
            case 5: {
                return in.readByte();
            }
        }
        throw new RuntimeException();
    }

    public void read(DataInput in, int offset, boolean isWide) throws IOException {
        this.offset = offset++;
        this.operation = Operation.findByOpcode(in.readUnsignedByte());
        this.size = 1;
        if (this.operation == null) {
            throw new RuntimeException("unknown operation");
        }
        if (this.operation.operandInfo1 != null) {
            if (this.operation.operandInfo1 == OperandInfo.TABLESWITCH) {
                while ((offset & 3) != 0) {
                    in.readByte();
                    ++offset;
                    ++this.size;
                }
                int _default = in.readInt();
                int _low = in.readInt();
                int _high = in.readInt();
                this.size += 12 + 4 * (_high - _low + 1);
                int i = 0;
                while (i < _high - _low + 1) {
                    int _disp = in.readInt();
                    ++i;
                }
            } else if (this.operation.operandInfo1 == OperandInfo.LOOKUPSWITCH) {
                while ((offset & 3) != 0) {
                    in.readByte();
                    ++offset;
                    ++this.size;
                }
                int _default2 = in.readInt();
                int _npairs = in.readInt();
                this.size += 8 + 8 * _npairs;
                int i = 0;
                while (i < _npairs) {
                    int _match = in.readInt();
                    int _disp = in.readInt();
                    ++i;
                }
            } else {
                this.operand1 = this.readOperand(this.operation.operandInfo1, in, isWide);
            }
            if (this.operation.operandInfo2 != null) {
                this.operand2 = this.readOperand(this.operation.operandInfo2, in, isWide);
                if (this.operation.operandInfo3 != null) {
                    this.readOperand(this.operation.operandInfo3, in, isWide);
                }
            }
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean hasOperands() {
        return this.operation.operandInfo1 != null;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public int getOperand1() {
        return this.operand1;
    }

    public int getOperand2() {
        return this.operand2;
    }

    public boolean isOperand1AConstant() {
        return this.operation.operandInfo1 != null && this.operation.operandInfo1.isCPItemIndex();
    }

    public CPItem getOperand1AsConstant() {
        if (this.isOperand1AConstant()) {
            return this.getCPItem(this.operand1);
        }
        return null;
    }

    public void setOperand1Index(int index) {
        if (this.operation.operandInfo1 == null || !this.operation.operandInfo1.isCPItemIndex()) {
            throw new RuntimeException();
        }
        this.operand1 = index;
        int opSize = this.operation.operandInfo1.size;
        if (opSize == 1) {
            ((CodeAttribute)this.getParent()).getCode()[this.offset + 1] = (byte)this.operand1;
        } else if (opSize == 2) {
            ((CodeAttribute)this.getParent()).getCode()[this.offset + 1] = (byte)(this.operand1 >> 8);
            ((CodeAttribute)this.getParent()).getCode()[this.offset + 2] = (byte)(this.operand1 & 0xFF);
        } else {
            throw new RuntimeException();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.offset).append(": ");
        buf.append(this.operation.mnemonic);
        if (this.operation.operandInfo1 != null) {
            buf.append("  ");
            buf.append("#").append(this.operand1).append(",#").append(this.operand2).append("; (").append(this.size()).append(")");
        }
        return buf.toString();
    }

    public Object accept(ClassFileVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void read(DataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(DataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static Instruction[] readInstructions(CodeAttribute parent, DataInput in, int length) throws IOException {
        ClassFileElementFactory factory = parent.getDeclaringClass().getClassFileLoader().getFactory();
        boolean wide = false;
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        int offset = 0;
        while (offset < length) {
            Instruction inst = factory.createInstruction(parent, -1);
            inst.read(in, offset, wide);
            wide = inst.operation == Operation.wide;
            offset += inst.size();
            instructions.add(inst);
        }
        return instructions.toArray(new Instruction[instructions.size()]);
    }

    public static Instruction[] readInstructions(CodeAttribute parent, byte[] code) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(code));
        return Instruction.readInstructions(parent, in, code.length);
    }

    public static class Operation {
        private static Operation[] operations = new Operation[256];
        public static final Operation nop = new Operation(0, "nop");
        public static final Operation aconst_null = new Operation(1, "aconst_null");
        public static final Operation iconst_m1 = new Operation(2, "iconst_m1");
        public static final Operation iconst_0 = new Operation(3, "iconst_0");
        public static final Operation iconst_1 = new Operation(4, "iconst_1");
        public static final Operation iconst_2 = new Operation(5, "iconst_2");
        public static final Operation iconst_3 = new Operation(6, "iconst_3");
        public static final Operation iconst_4 = new Operation(7, "iconst_4");
        public static final Operation iconst_5 = new Operation(8, "iconst_5");
        public static final Operation lconst_0 = new Operation(9, "lconst_0");
        public static final Operation lconst_1 = new Operation(10, "lconst_1");
        public static final Operation fconst_0 = new Operation(11, "fconst_0");
        public static final Operation fconst_1 = new Operation(12, "fconst_1");
        public static final Operation fconst_2 = new Operation(13, "fconst_2");
        public static final Operation dconst_0 = new Operation(14, "dconst_0");
        public static final Operation dconst_1 = new Operation(15, "dconst_1");
        public static final Operation bipush = new Operation(16, "bipush", OperandInfo.IMMEDIATE_BYTE);
        public static final Operation sipush = new Operation(17, "sipush", OperandInfo.IMMEDIATE_SHORT);
        public static final Operation ldc = new Operation(18, "ldc", OperandInfo.SHORT_CONST_INDEX);
        public static final Operation ldc_w = new Operation(19, "ldc_w", OperandInfo.CONST_INDEX);
        public static final Operation ldc2_w = new Operation(20, "ldc2_w", OperandInfo.CONST_INDEX);
        public static final Operation iload = new Operation(21, "iload", OperandInfo.VAR_INDEX);
        public static final Operation lload = new Operation(22, "lload", OperandInfo.VAR_INDEX);
        public static final Operation fload = new Operation(23, "fload", OperandInfo.VAR_INDEX);
        public static final Operation dload = new Operation(24, "dload", OperandInfo.VAR_INDEX);
        public static final Operation aload = new Operation(25, "aload", OperandInfo.VAR_INDEX);
        public static final Operation iload_0 = new Operation(26, "iload_0");
        public static final Operation iload_1 = new Operation(27, "iload_1");
        public static final Operation iload_2 = new Operation(28, "iload_2");
        public static final Operation iload_3 = new Operation(29, "iload_3");
        public static final Operation lload_0 = new Operation(30, "lload_0");
        public static final Operation lload_1 = new Operation(31, "lload_1");
        public static final Operation lload_2 = new Operation(32, "lload_2");
        public static final Operation lload_3 = new Operation(33, "lload_3");
        public static final Operation fload_0 = new Operation(34, "fload_0");
        public static final Operation fload_1 = new Operation(35, "fload_1");
        public static final Operation fload_2 = new Operation(36, "fload_2");
        public static final Operation fload_3 = new Operation(37, "fload_3");
        public static final Operation dload_0 = new Operation(38, "dload_0");
        public static final Operation dload_1 = new Operation(39, "dload_1");
        public static final Operation dload_2 = new Operation(40, "dload_2");
        public static final Operation dload_3 = new Operation(41, "dload_3");
        public static final Operation aload_0 = new Operation(42, "aload_0");
        public static final Operation aload_1 = new Operation(43, "aload_1");
        public static final Operation aload_2 = new Operation(44, "aload_2");
        public static final Operation aload_3 = new Operation(45, "aload_3");
        public static final Operation iaload = new Operation(46, "iaload");
        public static final Operation laload = new Operation(47, "laload");
        public static final Operation faload = new Operation(48, "faload");
        public static final Operation daload = new Operation(49, "daload");
        public static final Operation aaload = new Operation(50, "aaload");
        public static final Operation baload = new Operation(51, "baload");
        public static final Operation caload = new Operation(52, "caload");
        public static final Operation saload = new Operation(53, "saload");
        public static final Operation istore = new Operation(54, "istore", OperandInfo.VAR_INDEX);
        public static final Operation lstore = new Operation(55, "lstore", OperandInfo.VAR_INDEX);
        public static final Operation fstore = new Operation(56, "fstore", OperandInfo.VAR_INDEX);
        public static final Operation dstore = new Operation(57, "dstore", OperandInfo.VAR_INDEX);
        public static final Operation astore = new Operation(58, "astore", OperandInfo.VAR_INDEX);
        public static final Operation istore_0 = new Operation(59, "istore_0");
        public static final Operation istore_1 = new Operation(60, "istore_1");
        public static final Operation istore_2 = new Operation(61, "istore_2");
        public static final Operation istore_3 = new Operation(62, "istore_3");
        public static final Operation lstore_0 = new Operation(63, "lstore_0");
        public static final Operation lstore_1 = new Operation(64, "lstore_1");
        public static final Operation lstore_2 = new Operation(65, "lstore_2");
        public static final Operation lstore_3 = new Operation(66, "lstore_3");
        public static final Operation fstore_0 = new Operation(67, "fstore_0");
        public static final Operation fstore_1 = new Operation(68, "fstore_1");
        public static final Operation fstore_2 = new Operation(69, "fstore_2");
        public static final Operation fstore_3 = new Operation(70, "fstore_3");
        public static final Operation dstore_0 = new Operation(71, "dstore_0");
        public static final Operation dstore_1 = new Operation(72, "dstore_1");
        public static final Operation dstore_2 = new Operation(73, "dstore_2");
        public static final Operation dstore_3 = new Operation(74, "dstore_3");
        public static final Operation astore_0 = new Operation(75, "astore_0");
        public static final Operation astore_1 = new Operation(76, "astore_1");
        public static final Operation astore_2 = new Operation(77, "astore_2");
        public static final Operation astore_3 = new Operation(78, "astore_3");
        public static final Operation iastore = new Operation(79, "iastore");
        public static final Operation lastore = new Operation(80, "lastore");
        public static final Operation fastore = new Operation(81, "fastore");
        public static final Operation dastore = new Operation(82, "dastore");
        public static final Operation aastore = new Operation(83, "aastore");
        public static final Operation bastore = new Operation(84, "bastore");
        public static final Operation castore = new Operation(85, "castore");
        public static final Operation sastore = new Operation(86, "sastore");
        public static final Operation pop = new Operation(87, "pop");
        public static final Operation pop2 = new Operation(88, "pop2");
        public static final Operation dup = new Operation(89, "dup");
        public static final Operation dup_x1 = new Operation(90, "dup_x1");
        public static final Operation dup_x2 = new Operation(91, "dup_x2");
        public static final Operation dup2 = new Operation(92, "dup2");
        public static final Operation dup2_x1 = new Operation(93, "dup2_x1");
        public static final Operation dup2_x2 = new Operation(94, "dup2_x2");
        public static final Operation swap = new Operation(95, "swap");
        public static final Operation iadd = new Operation(96, "iadd");
        public static final Operation ladd = new Operation(97, "ladd");
        public static final Operation fadd = new Operation(98, "fadd");
        public static final Operation dadd = new Operation(99, "dadd");
        public static final Operation isub = new Operation(100, "isub");
        public static final Operation lsub = new Operation(101, "lsub");
        public static final Operation fsub = new Operation(102, "fsub");
        public static final Operation dsub = new Operation(103, "dsub");
        public static final Operation imul = new Operation(104, "imul");
        public static final Operation lmul = new Operation(105, "lmul");
        public static final Operation fmul = new Operation(106, "fmul");
        public static final Operation dmul = new Operation(107, "dmul");
        public static final Operation idiv = new Operation(108, "idiv");
        public static final Operation ldiv = new Operation(109, "ldiv");
        public static final Operation fdiv = new Operation(110, "fdiv");
        public static final Operation ddiv = new Operation(111, "ddiv");
        public static final Operation irem = new Operation(112, "irem");
        public static final Operation lrem = new Operation(113, "lrem");
        public static final Operation frem = new Operation(114, "frem");
        public static final Operation drem = new Operation(115, "drem");
        public static final Operation ineg = new Operation(116, "ineg");
        public static final Operation lneg = new Operation(117, "lneg");
        public static final Operation fneg = new Operation(118, "fneg");
        public static final Operation dneg = new Operation(119, "dneg");
        public static final Operation ishl = new Operation(120, "ishl");
        public static final Operation lshl = new Operation(121, "lshl");
        public static final Operation ishr = new Operation(122, "ishr");
        public static final Operation lshr = new Operation(123, "lshr");
        public static final Operation iushr = new Operation(124, "iushr");
        public static final Operation lushr = new Operation(125, "lushr");
        public static final Operation iand = new Operation(126, "iand");
        public static final Operation land = new Operation(127, "land");
        public static final Operation ior = new Operation(128, "ior");
        public static final Operation lor = new Operation(129, "lor");
        public static final Operation ixor = new Operation(130, "ixor");
        public static final Operation lxor = new Operation(131, "lxor");
        public static final Operation iinc = new Operation(132, "iinc", OperandInfo.VAR_INDEX, OperandInfo.IMMEDIATE_BYTE, OperandInfo.NONE);
        public static final Operation i2l = new Operation(133, "i2l");
        public static final Operation i2f = new Operation(134, "i2f");
        public static final Operation i2d = new Operation(135, "i2d");
        public static final Operation l2i = new Operation(136, "l2i");
        public static final Operation l2f = new Operation(137, "l2f");
        public static final Operation l2d = new Operation(138, "l2d");
        public static final Operation f2i = new Operation(139, "f2i");
        public static final Operation f2l = new Operation(140, "f2l");
        public static final Operation f2d = new Operation(141, "f2d");
        public static final Operation d2i = new Operation(142, "d2i");
        public static final Operation d2l = new Operation(143, "d2l");
        public static final Operation d2f = new Operation(144, "d2f");
        public static final Operation i2b = new Operation(145, "i2b");
        public static final Operation i2c = new Operation(146, "i2c");
        public static final Operation i2s = new Operation(147, "i2s");
        public static final Operation lcmp = new Operation(148, "lcmp");
        public static final Operation fcmpl = new Operation(149, "fcmpl");
        public static final Operation fcmpg = new Operation(150, "fcmpg");
        public static final Operation dcmpl = new Operation(151, "dcmpl");
        public static final Operation dcmpg = new Operation(152, "dcmpg");
        public static final Operation ifeq = new Operation(153, "ifeq", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation ifne = new Operation(154, "ifne", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation iflt = new Operation(155, "iflt", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation ifge = new Operation(156, "ifge", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation ifgt = new Operation(157, "ifgt", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation ifle = new Operation(158, "ifle", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation if_icmpeq = new Operation(159, "if_icmpeq", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation if_icmpne = new Operation(160, "if_icmpne", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation if_icmplt = new Operation(161, "if_icmplt", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation if_icmpge = new Operation(162, "if_icmpge", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation if_icmpgt = new Operation(163, "if_icmpgt", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation if_icmple = new Operation(164, "if_icmple", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation if_acmpeq = new Operation(165, "if_acmpeq", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation if_acmpne = new Operation(166, "if_acmpne", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation _goto = new Operation(167, "goto", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation jsr = new Operation(168, "jsr", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation ret = new Operation(169, "ret", OperandInfo.VAR_INDEX);
        public static final Operation tableswitch = new Operation(170, "tableswitch", OperandInfo.TABLESWITCH);
        public static final Operation lookupswitch = new Operation(171, "lookupswitch", OperandInfo.LOOKUPSWITCH);
        public static final Operation ireturn = new Operation(172, "ireturn");
        public static final Operation lreturn = new Operation(173, "lreturn");
        public static final Operation freturn = new Operation(174, "freturn");
        public static final Operation dreturn = new Operation(175, "dreturn");
        public static final Operation areturn = new Operation(176, "areturn");
        public static final Operation _return = new Operation(177, "return");
        public static final Operation getstatic = new Operation(178, "getstatic", OperandInfo.CONST_INDEX);
        public static final Operation putstatic = new Operation(179, "putstatic", OperandInfo.CONST_INDEX);
        public static final Operation getfield = new Operation(180, "getfield", OperandInfo.CONST_INDEX);
        public static final Operation putfield = new Operation(181, "putfield", OperandInfo.CONST_INDEX);
        public static final Operation invokevirtual = new Operation(182, "invokevirtual", OperandInfo.CONST_INDEX);
        public static final Operation invokespecial = new Operation(183, "invokespecial", OperandInfo.CONST_INDEX);
        public static final Operation invokestatic = new Operation(184, "invokestatic", OperandInfo.CONST_INDEX);
        public static final Operation invokeinterface = new Operation(185, "invokeinterface", OperandInfo.CONST_INDEX, OperandInfo.IMMEDIATE_UBYTE, OperandInfo.IMMEDIATE_BYTE);
        public static final Operation xxxunusedxxx1 = new Operation(186, "xxxunusedxxx1");
        public static final Operation _new = new Operation(187, "new", OperandInfo.CONST_INDEX);
        public static final Operation newarray = new Operation(188, "newarray", OperandInfo.PRIMITIVE_TYPE);
        public static final Operation anewarray = new Operation(189, "anewarray", OperandInfo.CONST_INDEX);
        public static final Operation arraylength = new Operation(190, "arraylength");
        public static final Operation athrow = new Operation(191, "athrow");
        public static final Operation checkcast = new Operation(192, "checkcast", OperandInfo.CONST_INDEX);
        public static final Operation _instanceof = new Operation(193, "instanceof", OperandInfo.CONST_INDEX);
        public static final Operation monitorenter = new Operation(194, "monitorenter");
        public static final Operation monitorexit = new Operation(195, "monitorexit");
        public static final Operation wide = new Operation(196, "wide");
        public static final Operation multianewarray = new Operation(197, "multianewarray", OperandInfo.CONST_INDEX, OperandInfo.IMMEDIATE_UBYTE, OperandInfo.NONE);
        public static final Operation ifnull = new Operation(198, "ifnull", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation ifnonnull = new Operation(199, "ifnonnull", OperandInfo.SHORT_DISPLACEMENT);
        public static final Operation goto_w = new Operation(200, "goto_w", OperandInfo.DISPLACEMENT);
        public static final Operation jsr_w = new Operation(201, "jsr_w", OperandInfo.DISPLACEMENT);
        public static final Operation breakpoint = new Operation(202, "breakpoint");
        public static final Operation impdep1 = new Operation(254, "impdep1");
        public static final Operation impdep2 = new Operation(255, "impdep2");
        private final int opcode;
        private final String mnemonic;
        private final OperandInfo operandInfo1;
        private final OperandInfo operandInfo2;
        private final OperandInfo operandInfo3;

        public static Operation findByOpcode(int opcode) {
            return operations[opcode];
        }

        private Operation(int opcode, String mnemonic, OperandInfo operandInfo1, OperandInfo operandInfo2, OperandInfo operandInfo3) {
            Operation.operations[opcode] = this;
            this.opcode = opcode;
            this.mnemonic = mnemonic;
            this.operandInfo1 = operandInfo1;
            this.operandInfo2 = operandInfo2;
            this.operandInfo3 = operandInfo3;
        }

        private Operation(int opcode, String mnemonic) {
            this(opcode, mnemonic, OperandInfo.NONE, OperandInfo.NONE, OperandInfo.NONE);
        }

        private Operation(int opcode, String mnemonic, OperandInfo operandInfo1) {
            this(opcode, mnemonic, operandInfo1, OperandInfo.NONE, OperandInfo.NONE);
        }

        public int getOpcode() {
            return this.opcode;
        }

        public String getMnemonic() {
            return this.mnemonic;
        }

        public OperandInfo getOperandInfo1() {
            return this.operandInfo1;
        }

        public OperandInfo getOperandInfo2() {
            return this.operandInfo2;
        }

        public OperandInfo getOperandInfo3() {
            return this.operandInfo3;
        }
    }

    public static class OperandInfo {
        public static final int TYPE_NONE = 0;
        public static final int TYPE_VAR_INDEX = 1;
        public static final int TYPE_IMMEDIATE_SIGNED = 2;
        public static final int TYPE_CP_ITEM_INDEX = 3;
        public static final int TYPE_DISPLACEMENT = 4;
        public static final int TYPE_PRIMITIVE_TYPE = 5;
        public static final int TYPE_IMMEDIATE_UNSIGNED = 6;
        public static final int TYPE_SPECIAL_TABLESWITCH = 7;
        public static final int TYPE_SPECIAL_LOOKUPSWITCH = 8;
        public static final OperandInfo NONE = null;
        public static final OperandInfo VAR_INDEX = new OperandInfo(1, 1);
        public static final OperandInfo IMMEDIATE_BYTE = new OperandInfo(2, 1);
        public static final OperandInfo IMMEDIATE_SHORT = new OperandInfo(2, 2);
        public static final OperandInfo SHORT_CONST_INDEX = new OperandInfo(3, 1);
        public static final OperandInfo CONST_INDEX = new OperandInfo(3, 2);
        public static final OperandInfo SHORT_DISPLACEMENT = new OperandInfo(4, 2);
        public static final OperandInfo DISPLACEMENT = new OperandInfo(4, 4);
        public static final OperandInfo TABLESWITCH = new OperandInfo(7, 0);
        public static final OperandInfo LOOKUPSWITCH = new OperandInfo(8, 0);
        public static final OperandInfo PRIMITIVE_TYPE = new OperandInfo(5, 1);
        public static final OperandInfo IMMEDIATE_UBYTE = new OperandInfo(6, 1);
        private final int type;
        private final int size;

        private OperandInfo(int type, int size) {
            this.type = type;
            this.size = size;
        }

        public int getType() {
            return this.type;
        }

        public boolean isComplex() {
            return this.type == 7 || this.type == 8;
        }

        private boolean isSigned() {
            return this.type == 2 || this.type == 4;
        }

        private boolean isUnsigned() {
            return this.type == 1 || this.type == 3 || this.type == 6;
        }

        private boolean isCPItemIndex() {
            return this.type == 3;
        }
    }
}

