/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode;

import com.sap.tools.webdynpro.bytecode.AbstractInfo;
import com.sap.tools.webdynpro.bytecode.AttributeInfo;
import com.sap.tools.webdynpro.bytecode.CPItem;
import com.sap.tools.webdynpro.bytecode.ClassFile;
import com.sap.tools.webdynpro.bytecode.ClassFileElementFactory;
import com.sap.tools.webdynpro.bytecode.ClassFileNotFoundException;
import com.sap.tools.webdynpro.bytecode.FieldInfo;
import com.sap.tools.webdynpro.bytecode.Instruction;
import com.sap.tools.webdynpro.bytecode.MethodInfo;
import com.sap.tools.webdynpro.bytecode.attributes.CodeAttribute;
import com.sap.tools.webdynpro.bytecode.attributes.UnknownAttribute;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Class_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Double_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_FieldRefInfo;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Float_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Integer_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_InterfaceMethodRefInfo;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Long_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_MethodRefInfo;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_NameAndType_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_String_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Utf8_Info;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ClassFileLoader {
    private static final ClassFileLoader systemClassFileLoader = new ClassFileLoader(new DefaultFactory());
    private ClassLoader classLoader;
    private final ClassFileLoader parent;
    private final ClassFileElementFactory factory;
    private Map classes = new HashMap();

    public static ClassFileLoader getSystemClassFileLoader() {
        return systemClassFileLoader;
    }

    public static ClassFileLoader createSystemClassFileLoader(ClassFileElementFactory factory) {
        return new ClassFileLoader(factory);
    }

    private ClassFileLoader(ClassFileElementFactory factory) {
        this.classLoader = ClassLoader.getSystemClassLoader();
        this.parent = null;
        this.factory = factory == null ? new DefaultFactory() : factory;
    }

    public ClassFileLoader(ClassLoader originLoader, ClassFileLoader parent, ClassFileElementFactory factory) {
        if (originLoader == null) {
            throw new IllegalArgumentException("origin classloader must not be null");
        }
        this.classLoader = originLoader;
        this.parent = parent == null ? ClassFileLoader.createSystemClassFileLoader(this.factory) : parent;
        this.factory = factory == null ? new DefaultFactory() : factory;
    }

    public ClassFileLoader(ClassLoader originLoader, ClassFileLoader parent) {
        this(originLoader, parent, new DefaultFactory());
    }

    public ClassFileLoader(ClassLoader originLoader) {
        this(originLoader, systemClassFileLoader);
    }

    public ClassFileElementFactory getFactory() {
        return this.factory;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private ClassFile findLoadedClassFile(String className) {
        return (ClassFile)this.classes.get(className);
    }

    public ClassFile loadClassFile(String className) {
        ClassFile cf = this.findLoadedClassFile(className);
        if (cf == null) {
            try {
                if (this.parent != null) {
                    cf = this.parent.findClassFile(className);
                }
            }
            catch (ClassFileNotFoundException classFileNotFoundException) {
                // empty catch block
            }
            if (cf == null) {
                cf = this.findClassFile(className);
            }
            this.classes.put(className, cf);
        }
        return cf;
    }

    protected ClassFile findClassFile(String className) {
        try {
            ClassFile classFile;
            InputStream in;
            String resourceName = className.replace('.', '/') + ".class";
            URL url = this.getClassLoader().getResource(resourceName);
            InputStream inputStream = in = url != null ? url.openStream() : null;
            if (in == null) {
                throw new ClassFileNotFoundException("class '" + className + "' not found via " + this.classLoader);
            }
            try {
                ClassFile cf = this.factory.createClassFile(this);
                cf.read(new DataInputStream(in));
                classFile = cf;
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return classFile;
        }
        catch (IOException e) {
            throw new ClassFileNotFoundException("error while loading class '" + className + "'", e);
        }
    }

    public ClassFile defineClassFile(String className, byte[] b, int offset, int length) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(b, offset, length);
            ClassFile cf = this.factory.createClassFile(this);
            cf.read(new DataInputStream(in));
            this.classes.put(className, cf);
            return cf;
        }
        catch (IOException e) {
            throw new ClassFileNotFoundException("error while defining class '" + className + "'", e);
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.getClassLoader().loadClass(className);
    }

    public ClassFile loadClassFile(File fileName) {
        try {
            FileInputStream in = new FileInputStream(fileName);
            ClassFile cf = this.factory.createClassFile(this);
            cf.read(new DataInputStream(in));
            return cf;
        }
        catch (IOException e) {
            throw new ClassFileNotFoundException("error while loading class from file '" + fileName + "'", e);
        }
    }

    public static class DefaultFactory
    implements ClassFileElementFactory {
        private final Map attributeTypes = new HashMap();
        static /* synthetic */ Class class$com$sap$tools$webdynpro$bytecode$AbstractInfo;
        static /* synthetic */ Class class$com$sap$tools$webdynpro$bytecode$attributes$CodeAttribute;
        static /* synthetic */ Class class$com$sap$tools$webdynpro$bytecode$attributes$ConstantValueAttribute;
        static /* synthetic */ Class class$com$sap$tools$webdynpro$bytecode$attributes$ExceptionsAttribute;
        static /* synthetic */ Class class$com$sap$tools$webdynpro$bytecode$attributes$InnerClassesAttribute;
        static /* synthetic */ Class class$com$sap$tools$webdynpro$bytecode$attributes$SyntheticAttribute;
        static /* synthetic */ Class class$com$sap$tools$webdynpro$bytecode$attributes$SourceFileAttribute;
        static /* synthetic */ Class class$com$sap$tools$webdynpro$bytecode$attributes$DeprecatedAttribute;
        static /* synthetic */ Class class$com$sap$tools$webdynpro$bytecode$attributes$LineNumberTableAttribute;
        static /* synthetic */ Class class$com$sap$tools$webdynpro$bytecode$attributes$LocalVariableTableAttribute;

        public DefaultFactory() {
            this.registerAttributeType("Code", class$com$sap$tools$webdynpro$bytecode$attributes$CodeAttribute == null ? (class$com$sap$tools$webdynpro$bytecode$attributes$CodeAttribute = DefaultFactory.class$("com.sap.tools.webdynpro.bytecode.attributes.CodeAttribute")) : class$com$sap$tools$webdynpro$bytecode$attributes$CodeAttribute);
            this.registerAttributeType("ConstantValue", class$com$sap$tools$webdynpro$bytecode$attributes$ConstantValueAttribute == null ? (class$com$sap$tools$webdynpro$bytecode$attributes$ConstantValueAttribute = DefaultFactory.class$("com.sap.tools.webdynpro.bytecode.attributes.ConstantValueAttribute")) : class$com$sap$tools$webdynpro$bytecode$attributes$ConstantValueAttribute);
            this.registerAttributeType("Exceptions", class$com$sap$tools$webdynpro$bytecode$attributes$ExceptionsAttribute == null ? (class$com$sap$tools$webdynpro$bytecode$attributes$ExceptionsAttribute = DefaultFactory.class$("com.sap.tools.webdynpro.bytecode.attributes.ExceptionsAttribute")) : class$com$sap$tools$webdynpro$bytecode$attributes$ExceptionsAttribute);
            this.registerAttributeType("InnerClasses", class$com$sap$tools$webdynpro$bytecode$attributes$InnerClassesAttribute == null ? (class$com$sap$tools$webdynpro$bytecode$attributes$InnerClassesAttribute = DefaultFactory.class$("com.sap.tools.webdynpro.bytecode.attributes.InnerClassesAttribute")) : class$com$sap$tools$webdynpro$bytecode$attributes$InnerClassesAttribute);
            this.registerAttributeType("Synthetic", class$com$sap$tools$webdynpro$bytecode$attributes$SyntheticAttribute == null ? (class$com$sap$tools$webdynpro$bytecode$attributes$SyntheticAttribute = DefaultFactory.class$("com.sap.tools.webdynpro.bytecode.attributes.SyntheticAttribute")) : class$com$sap$tools$webdynpro$bytecode$attributes$SyntheticAttribute);
            this.registerAttributeType("SourceFile", class$com$sap$tools$webdynpro$bytecode$attributes$SourceFileAttribute == null ? (class$com$sap$tools$webdynpro$bytecode$attributes$SourceFileAttribute = DefaultFactory.class$("com.sap.tools.webdynpro.bytecode.attributes.SourceFileAttribute")) : class$com$sap$tools$webdynpro$bytecode$attributes$SourceFileAttribute);
            this.registerAttributeType("Deprecated", class$com$sap$tools$webdynpro$bytecode$attributes$DeprecatedAttribute == null ? (class$com$sap$tools$webdynpro$bytecode$attributes$DeprecatedAttribute = DefaultFactory.class$("com.sap.tools.webdynpro.bytecode.attributes.DeprecatedAttribute")) : class$com$sap$tools$webdynpro$bytecode$attributes$DeprecatedAttribute);
            this.registerAttributeType("LineNumberTable", class$com$sap$tools$webdynpro$bytecode$attributes$LineNumberTableAttribute == null ? (class$com$sap$tools$webdynpro$bytecode$attributes$LineNumberTableAttribute = DefaultFactory.class$("com.sap.tools.webdynpro.bytecode.attributes.LineNumberTableAttribute")) : class$com$sap$tools$webdynpro$bytecode$attributes$LineNumberTableAttribute);
            this.registerAttributeType("LocalVariableTable", class$com$sap$tools$webdynpro$bytecode$attributes$LocalVariableTableAttribute == null ? (class$com$sap$tools$webdynpro$bytecode$attributes$LocalVariableTableAttribute = DefaultFactory.class$("com.sap.tools.webdynpro.bytecode.attributes.LocalVariableTableAttribute")) : class$com$sap$tools$webdynpro$bytecode$attributes$LocalVariableTableAttribute);
        }

        protected void registerAttributeType(String attributeName, Class attributeClass) {
            try {
                Constructor constructor = attributeClass.getConstructor(class$com$sap$tools$webdynpro$bytecode$AbstractInfo == null ? (class$com$sap$tools$webdynpro$bytecode$AbstractInfo = DefaultFactory.class$("com.sap.tools.webdynpro.bytecode.AbstractInfo")) : class$com$sap$tools$webdynpro$bytecode$AbstractInfo, Integer.TYPE);
                this.attributeTypes.put(attributeName, constructor);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        public AttributeInfo createAttribute(AbstractInfo parent, int attributeNameIndex) {
            AttributeInfo ai;
            String attributeName = ((CONST_Utf8_Info)parent.getCPItem(attributeNameIndex)).getString();
            Constructor constructor = (Constructor)this.attributeTypes.get(attributeName);
            if (constructor != null) {
                try {
                    ai = (AttributeInfo)constructor.newInstance(parent, new Integer(attributeNameIndex));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            } else {
                ai = new UnknownAttribute(parent, attributeNameIndex);
            }
            return ai;
        }

        public ClassFile createClassFile(ClassFileLoader loader) {
            return new ClassFile(loader);
        }

        public CPItem createCPItem(ClassFile parent, int tag) {
            switch (tag) {
                case 7: {
                    return new CONST_Class_Info(parent, tag);
                }
                case 9: {
                    return new CONST_FieldRefInfo(parent, tag);
                }
                case 10: {
                    return new CONST_MethodRefInfo(parent, tag);
                }
                case 11: {
                    return new CONST_InterfaceMethodRefInfo(parent, tag);
                }
                case 8: {
                    return new CONST_String_Info(parent, tag);
                }
                case 3: {
                    return new CONST_Integer_Info(parent, tag);
                }
                case 4: {
                    return new CONST_Float_Info(parent, tag);
                }
                case 5: {
                    return new CONST_Long_Info(parent, tag);
                }
                case 6: {
                    return new CONST_Double_Info(parent, tag);
                }
                case 12: {
                    return new CONST_NameAndType_Info(parent, tag);
                }
                case 1: {
                    return new CONST_Utf8_Info(parent, tag);
                }
            }
            throw new RuntimeException("unexpected cpool tag " + tag);
        }

        public FieldInfo createField(ClassFile parent) {
            return new FieldInfo(parent);
        }

        public MethodInfo createMethod(ClassFile parent) {
            return new MethodInfo(parent);
        }

        public Instruction createInstruction(CodeAttribute parent, int opcode) {
            return new Instruction(parent);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

