/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode;

import com.sap.tools.webdynpro.bytecode.AbstractInfo;
import com.sap.tools.webdynpro.bytecode.AttributeInfo;
import com.sap.tools.webdynpro.bytecode.CPItem;
import com.sap.tools.webdynpro.bytecode.ClassFileLoader;
import com.sap.tools.webdynpro.bytecode.ClassFileVisitor;
import com.sap.tools.webdynpro.bytecode.FieldInfo;
import com.sap.tools.webdynpro.bytecode.MemberInfo;
import com.sap.tools.webdynpro.bytecode.MethodInfo;
import com.sap.tools.webdynpro.bytecode.attributes.InnerClassesAttribute;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Class_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Double_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Long_Info;
import com.sap.tools.webdynpro.bytecode.visitors.CPReachabilityVisitor;
import com.sap.tools.webdynpro.bytecode.visitors.CPRenumberingVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClassFile
extends AbstractInfo {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_VARARGS = 128;
    private ClassFileLoader cfLoader;
    private int magic;
    private int minor_version;
    private int major_version;
    private CPItem[] constantPool;
    private int access_flags;
    private int thisClassIndex;
    private int superClassIndex;
    private int[] interfaceIndexes;
    private List fields;
    private transient Map fieldsBySignature;
    private List methods;
    private transient Map methodsBySignature;
    private List attributes;
    private transient Map attributesByName;
    private transient boolean dirty = false;

    protected ClassFile(ClassFileLoader cfLoader) {
        super(null);
        this.cfLoader = cfLoader;
    }

    public ClassFileLoader getClassFileLoader() {
        return this.cfLoader;
    }

    public CPItem[] getConstantPool() {
        return this.constantPool;
    }

    public void condenseConstantPool(CPReachabilityVisitor reachabilityVisitor, ClassFileVisitor renumVisitor) {
        this.accept(reachabilityVisitor, null);
        BitSet reached = reachabilityVisitor.getReached();
        InnerClassesAttribute ica = (InnerClassesAttribute)this.getAttribute("InnerClasses");
        if (ica != null) {
            ica.condense(reached);
        }
        int[] renum = this.retainCPItems(reached);
        this.accept(renumVisitor, renum);
    }

    public void condenseConstantPool() {
        this.condenseConstantPool(new CPReachabilityVisitor(this), new CPRenumberingVisitor());
    }

    int sizeOfCPItems(BitSet reached) {
        int size = 0;
        int i = 0;
        while (i < this.constantPool.length) {
            if (reached.get(i) && this.constantPool[i] != null) {
                size += this.constantPool[i].size();
            }
            ++i;
        }
        return size;
    }

    protected int[] retainCPItems(BitSet itemsToKeep) {
        CPItem[] tmpPool = new CPItem[this.constantPool.length];
        int[] renumber = new int[this.constantPool.length];
        int remainingCPItems = 0;
        int i = 0;
        while (i < this.constantPool.length) {
            if (i == 0 || itemsToKeep.get(i)) {
                tmpPool[remainingCPItems] = this.constantPool[i];
                if (tmpPool[remainingCPItems] != null) {
                    tmpPool[remainingCPItems].setIndex(remainingCPItems);
                }
                renumber[i] = remainingCPItems++;
            } else {
                renumber[i] = -1;
            }
            ++i;
        }
        this.constantPool = new CPItem[remainingCPItems];
        System.arraycopy(tmpPool, 0, this.constantPool, 0, remainingCPItems);
        return renumber;
    }

    public void read(DataInput in) throws IOException {
        this.magic = in.readInt();
        this.minor_version = in.readUnsignedShort();
        this.major_version = in.readUnsignedShort();
        int constant_pool_count = in.readUnsignedShort();
        this.constantPool = new CPItem[constant_pool_count];
        int i = 1;
        while (i < constant_pool_count) {
            this.constantPool[i] = CPItem.readCPItem(this, i, in);
            if (this.constantPool[i] instanceof CONST_Long_Info || this.constantPool[i] instanceof CONST_Double_Info) {
                this.constantPool[++i] = null;
            }
            ++i;
        }
        this.access_flags = in.readUnsignedShort();
        this.thisClassIndex = in.readUnsignedShort();
        this.superClassIndex = in.readUnsignedShort();
        int interfaces_count = in.readUnsignedShort();
        this.interfaceIndexes = new int[interfaces_count];
        int i2 = 0;
        while (i2 < interfaces_count) {
            this.interfaceIndexes[i2] = in.readUnsignedShort();
            ++i2;
        }
        int fields_count = in.readUnsignedShort();
        this.fields = new ArrayList(fields_count);
        this.fieldsBySignature = new HashMap();
        int i3 = 0;
        while (i3 < fields_count) {
            FieldInfo fieldInfo = this.cfLoader.getFactory().createField(this);
            fieldInfo.read(in);
            this.fields.add(fieldInfo);
            this.fieldsBySignature.put(fieldInfo.getSignature(), fieldInfo);
            ++i3;
        }
        int methods_count = in.readUnsignedShort();
        this.methods = new ArrayList(methods_count);
        this.methodsBySignature = new HashMap();
        int i4 = 0;
        while (i4 < methods_count) {
            MethodInfo methodInfo = this.cfLoader.getFactory().createMethod(this);
            methodInfo.read(in);
            this.methods.add(methodInfo);
            this.methodsBySignature.put(methodInfo.getSignature(), methodInfo);
            ++i4;
        }
        int attributes_count = in.readUnsignedShort();
        this.attributes = new ArrayList(attributes_count);
        int i5 = 0;
        while (i5 < attributes_count) {
            AttributeInfo attribute = AttributeInfo.readAttributeInfo(this, in);
            this.attributes.add(attribute);
            if (this.attributesByName == null) {
                this.attributesByName = new HashMap();
            }
            this.attributesByName.put(attribute.getName(), attribute);
            ++i5;
        }
    }

    public int size() {
        int size = 24;
        int i = 1;
        while (i < this.constantPool.length) {
            if (this.constantPool[i] != null) {
                size += this.constantPool[i].size();
            }
            ++i;
        }
        size += 2 * this.interfaceIndexes.length;
        int i2 = 0;
        while (i2 < this.fields.size()) {
            size += ((FieldInfo)this.fields.get(i2)).size();
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.methods.size()) {
            size += ((MethodInfo)this.methods.get(i3)).size();
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.attributes.size()) {
            size += ((AttributeInfo)this.attributes.get(i4)).size();
            ++i4;
        }
        return size;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.magic);
        out.writeShort(this.minor_version);
        out.writeShort(this.major_version);
        out.writeShort(this.constantPool.length);
        int i = 1;
        while (i < this.constantPool.length) {
            this.constantPool[i].write(out);
            if (this.constantPool[i] instanceof CONST_Long_Info || this.constantPool[i] instanceof CONST_Double_Info) {
                ++i;
            }
            ++i;
        }
        out.writeShort(this.access_flags);
        out.writeShort(this.thisClassIndex);
        out.writeShort(this.superClassIndex);
        out.writeShort(this.interfaceIndexes.length);
        int i2 = 0;
        while (i2 < this.interfaceIndexes.length) {
            out.writeShort(this.interfaceIndexes[i2]);
            ++i2;
        }
        out.writeShort(this.fields.size());
        int i3 = 0;
        while (i3 < this.fields.size()) {
            ((FieldInfo)this.fields.get(i3)).write(out);
            ++i3;
        }
        out.writeShort(this.methods.size());
        int i4 = 0;
        while (i4 < this.methods.size()) {
            ((MethodInfo)this.methods.get(i4)).write(out);
            ++i4;
        }
        out.writeShort(this.attributes.size());
        int i5 = 0;
        while (i5 < this.attributes.size()) {
            ((AttributeInfo)this.attributes.get(i5)).write(out);
            ++i5;
        }
    }

    public int getFieldsCount() {
        return this.fields.size();
    }

    public int indexOf(FieldInfo field) {
        return this.fields.indexOf(field);
    }

    public FieldInfo findField(MemberInfo.Signature signature) {
        return (FieldInfo)this.fieldsBySignature.get(signature);
    }

    public FieldInfo getField(int index) {
        return (FieldInfo)this.fields.get(index);
    }

    public void removeField(int index) {
        this.fields.remove(index);
        this.makeDirty();
    }

    public FieldInfo[] getFields() {
        return this.fields.toArray(new FieldInfo[this.fields.size()]);
    }

    public int getMethodsCount() {
        return this.methods.size();
    }

    public MethodInfo[] getMethods() {
        return this.methods.toArray(new MethodInfo[this.methods.size()]);
    }

    public int indexOf(MethodInfo method) {
        int index = this.methods.indexOf(method);
        if (index < 0) {
            System.out.println("class " + String.valueOf(System.identityHashCode(method.getDeclaringClass())));
            System.out.println("method " + String.valueOf(System.identityHashCode(method)));
            System.out.println("this class " + String.valueOf(System.identityHashCode(this)));
            int i = 0;
            while (i < this.methods.size()) {
                System.out.println(String.valueOf(System.identityHashCode(this.methods.get(i))) + ":" + String.valueOf(i) + this.methods.get(i));
                ++i;
            }
        }
        return this.methods.indexOf(method);
    }

    public Collection findMethods(String methodName) {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>(5);
        Iterator it = this.methods.iterator();
        while (it.hasNext()) {
            MethodInfo method = (MethodInfo)it.next();
            if (!method.getName().equals(methodName)) continue;
            result.add(method);
        }
        return result;
    }

    public MethodInfo findMethod(MemberInfo.Signature signature) {
        return (MethodInfo)this.methodsBySignature.get(signature);
    }

    public MethodInfo getMethod(int index) {
        return (MethodInfo)this.methods.get(index);
    }

    public void removeMethod(int index) {
        MethodInfo method = (MethodInfo)this.methods.get(index);
        this.methods.remove(index);
        this.methodsBySignature.remove(method.getSignature());
        this.makeDirty();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void makeDirty() {
        this.dirty = true;
    }

    public Object accept(ClassFileVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object letChildrenAccept(ClassFileVisitor visitor, Object data, boolean visitCP, boolean visitFields, boolean visitMethods, boolean visitAttributes) {
        int i;
        if (visitCP) {
            i = 1;
            while (i < this.constantPool.length) {
                data = this.constantPool[i].accept(visitor, data);
                if (this.constantPool[i] instanceof CONST_Double_Info || this.constantPool[i] instanceof CONST_Long_Info) {
                    ++i;
                }
                ++i;
            }
        }
        if (visitFields) {
            i = 0;
            while (i < this.fields.size()) {
                data = ((FieldInfo)this.fields.get(i)).accept(visitor, data);
                ++i;
            }
        }
        if (visitMethods) {
            i = 0;
            while (i < this.methods.size()) {
                data = ((MethodInfo)this.methods.get(i)).accept(visitor, data);
                ++i;
            }
        }
        if (visitAttributes) {
            i = 0;
            while (i < this.attributes.size()) {
                data = ((AttributeInfo)this.attributes.get(i)).accept(visitor, data);
                ++i;
            }
        }
        return data;
    }

    public Object letChildrenAccept(ClassFileVisitor visitor, Object data) {
        return this.letChildrenAccept(visitor, data, true, true, true, true);
    }

    public int getAccessFlags() {
        return this.access_flags;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getMajorVersion() {
        return this.major_version;
    }

    public int getMinorVersion() {
        return this.minor_version;
    }

    public int getThisClassIndex() {
        return this.thisClassIndex;
    }

    public CONST_Class_Info getThisClass() {
        return (CONST_Class_Info)this.getCPItem(this.thisClassIndex);
    }

    public void setAccessFlags(int i) {
        this.access_flags = i;
    }

    public void setMagic(int i) {
        this.magic = i;
    }

    public void setMajorVersion(int i) {
        this.major_version = i;
    }

    public void setMinorVersion(int i) {
        this.minor_version = i;
    }

    public void setThisClassIndex(int i) {
        this.thisClassIndex = i;
    }

    public String getName() {
        return this.getThisClass().getClassName();
    }

    public int getInterfacesCount() {
        return this.interfaceIndexes.length;
    }

    public int getInterfaceIndex(int index) {
        return this.interfaceIndexes[index];
    }

    public void setInterfaceIndex(int index, int value) {
        this.interfaceIndexes[index] = value;
    }

    public CONST_Class_Info getInterface(int index) {
        return (CONST_Class_Info)this.getCPItem(this.interfaceIndexes[index]);
    }

    public boolean isInterface() {
        return (this.access_flags & 0x200) != 0;
    }

    public int getAttributesCount() {
        return this.attributes.size();
    }

    public AttributeInfo getAttribute(int index) {
        return (AttributeInfo)this.attributes.get(index);
    }

    public AttributeInfo getAttribute(String attributeName) {
        if (this.attributesByName == null) {
            return null;
        }
        return (AttributeInfo)this.attributesByName.get(attributeName);
    }

    public void removeAttribute(AttributeInfo attribute) {
        int index = this.attributes.indexOf(attribute);
        this.attributes.remove(index);
        this.attributesByName.remove(attribute.getName());
        this.makeDirty();
    }

    public boolean isInnerClass() {
        InnerClassesAttribute ic = (InnerClassesAttribute)this.getAttribute("InnerClasses");
        if (ic == null) {
            return false;
        }
        int i = 0;
        while (i < ic.getClasses().length) {
            if (ic.getClasses()[i].getInnerClassInfoIndex() == this.thisClassIndex) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getSuperClassIndex() {
        return this.superClassIndex;
    }

    public void setSuperClassIndex(int i) {
        this.superClassIndex = i;
    }

    public CONST_Class_Info getSuperClass() {
        return (CONST_Class_Info)this.getCPItem(this.superClassIndex);
    }

    public String getSuperClassName() {
        if (this.superClassIndex == 0) {
            return null;
        }
        return this.getSuperClass().getClassName();
    }

    public boolean doesImplement(String className) {
        int i = 0;
        while (i < this.interfaceIndexes.length) {
            CONST_Class_Info intf = this.getInterface(i);
            if (className.equals(intf.getClassName())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

