/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode;

import com.sap.tools.webdynpro.bytecode.AbstractInfo;
import com.sap.tools.webdynpro.bytecode.ClassFile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class CPItem
extends AbstractInfo {
    public static final int CONST_Class = 7;
    public static final int CONST_Fieldref = 9;
    public static final int CONST_Methodref = 10;
    public static final int CONST_InterfaceMethodRef = 11;
    public static final int CONST_String = 8;
    public static final int CONST_Integer = 3;
    public static final int CONST_Float = 4;
    public static final int CONST_Long = 5;
    public static final int CONST_Double = 6;
    public static final int CONST_NameAndType = 12;
    public static final int CONST_Utf8 = 1;
    private final int tag;
    private transient int cp_index;

    static CPItem readCPItem(ClassFile parent, int index, DataInput in) throws IOException {
        byte tag = in.readByte();
        CPItem cpitem = parent.getClassFileLoader().getFactory().createCPItem(parent, tag);
        cpitem.setIndex(index);
        cpitem.read(in);
        return cpitem;
    }

    protected CPItem(ClassFile classFile, int tag) {
        super(classFile);
        this.tag = tag;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.tag);
    }

    public int type() {
        return this.tag;
    }

    public int size() {
        return 1;
    }

    public int getIndex() {
        return this.cp_index;
    }

    public void setIndex(int i) {
        this.cp_index = i;
    }
}

