/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode;

import com.sap.tools.webdynpro.bytecode.AbstractInfo;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Utf8_Info;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class AttributeInfo
extends AbstractInfo {
    private int attributeNameIndex;
    private int attributeLength;

    public static AttributeInfo readAttributeInfo(AbstractInfo parent, DataInput in) throws IOException {
        int attribute_name_index = in.readUnsignedShort();
        AttributeInfo ai = parent.getDeclaringClass().getClassFileLoader().getFactory().createAttribute(parent, attribute_name_index);
        ai.read(in);
        return ai;
    }

    protected AttributeInfo(AbstractInfo parent, int attribute_name_index) {
        super(parent);
        this.attributeNameIndex = attribute_name_index;
    }

    public String getName() {
        return ((CONST_Utf8_Info)this.getCPItem(this.attributeNameIndex)).getString();
    }

    public int getAttributeNameIndex() {
        return this.attributeNameIndex;
    }

    public void setAttributeNameIndex(int i) {
        this.attributeNameIndex = i;
    }

    public int getAttributeLength() {
        return this.attributeLength;
    }

    public final int size() {
        return 6 + this.sizeOfContent();
    }

    public abstract int sizeOfContent();

    public void read(DataInput in) throws IOException {
        this.attributeLength = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeShort(this.attributeNameIndex);
        out.writeInt(this.sizeOfContent());
    }

    public String toString() {
        String msg = "Attribute \"" + this.getName() + "\"";
        if (this.sizeOfContent() > 0) {
            msg = msg + " byte[" + this.sizeOfContent() + "]";
        }
        return msg;
    }
}

