/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.bytecode;

import com.sap.tools.webdynpro.bytecode.CPItem;
import com.sap.tools.webdynpro.bytecode.ClassFile;
import com.sap.tools.webdynpro.bytecode.ClassFileVisitor;
import com.sap.tools.webdynpro.bytecode.visitors.CPReachabilityVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;

public abstract class AbstractInfo {
    private final AbstractInfo parent;
    private final ClassFile declaringClass;

    protected AbstractInfo(AbstractInfo parent) {
        this.parent = parent;
        this.declaringClass = parent == null ? (ClassFile)this : parent.getDeclaringClass();
    }

    public AbstractInfo getParent() {
        return this.parent;
    }

    public ClassFile getDeclaringClass() {
        return this.declaringClass;
    }

    protected CPItem getCPItem(int index) {
        return this.getDeclaringClass().getConstantPool()[index];
    }

    public abstract void read(DataInput var1) throws IOException;

    public abstract void write(DataOutput var1) throws IOException;

    public abstract Object accept(ClassFileVisitor var1, Object var2);

    public Object letChildrenAccept(ClassFileVisitor visitor, Object data) {
        return data;
    }

    public abstract int size();

    public final int cumulatedSize() {
        int size = this.size();
        if (!(this instanceof ClassFile)) {
            CPReachabilityVisitor rv = new CPReachabilityVisitor(this.getDeclaringClass());
            this.accept(rv, null);
            BitSet reached = rv.getReached();
            size += this.getDeclaringClass().sizeOfCPItems(reached);
        }
        return size;
    }
}

